@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rdc.kotlin

import com.pulumi.alicloud.rdc.OrganizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RDC Organization resource.
 * For information about RDC Organization and how to use it, see [What is Organization](https://help.aliyun.com/document_detail/51678.html).
 * > **NOTE:** Available in v1.137.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.rdc.Organization("example", {
 *     organizationName: "example_value",
 *     source: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.rdc.Organization("example",
 *     organization_name="example_value",
 *     source="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Rdc.Organization("example", new()
 *     {
 *         OrganizationName = "example_value",
 *         Source = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rdc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rdc.NewOrganization(ctx, "example", &rdc.OrganizationArgs{
 * 			OrganizationName: pulumi.String("example_value"),
 * 			Source:           pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rdc.Organization;
 * import com.pulumi.alicloud.rdc.OrganizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Organization("example", OrganizationArgs.builder()
 *             .organizationName("example_value")
 *             .source("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:rdc:Organization
 *     properties:
 *       organizationName: example_value
 *       source: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDC Organization can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rdc/organization:Organization example <id>
 * ```
 * @property desiredMemberCount The desired member count.
 * @property organizationName Company name.
 * @property realPk User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
 * @property source This is organization source information
 */
public data class OrganizationArgs(
    public val desiredMemberCount: Output<Int>? = null,
    public val organizationName: Output<String>? = null,
    public val realPk: Output<String>? = null,
    public val source: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rdc.OrganizationArgs> {
    override fun toJava(): com.pulumi.alicloud.rdc.OrganizationArgs =
        com.pulumi.alicloud.rdc.OrganizationArgs.builder()
            .desiredMemberCount(desiredMemberCount?.applyValue({ args0 -> args0 }))
            .organizationName(organizationName?.applyValue({ args0 -> args0 }))
            .realPk(realPk?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationArgs].
 */
@PulumiTagMarker
public class OrganizationArgsBuilder internal constructor() {
    private var desiredMemberCount: Output<Int>? = null

    private var organizationName: Output<String>? = null

    private var realPk: Output<String>? = null

    private var source: Output<String>? = null

    /**
     * @param value The desired member count.
     */
    @JvmName("qakiefasswhqymvb")
    public suspend fun desiredMemberCount(`value`: Output<Int>) {
        this.desiredMemberCount = value
    }

    /**
     * @param value Company name.
     */
    @JvmName("iqxlkjkjwbooljaj")
    public suspend fun organizationName(`value`: Output<String>) {
        this.organizationName = value
    }

    /**
     * @param value User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
     */
    @JvmName("piusxnroyvnqsvps")
    public suspend fun realPk(`value`: Output<String>) {
        this.realPk = value
    }

    /**
     * @param value This is organization source information
     */
    @JvmName("ukgvgkuduirlblhq")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The desired member count.
     */
    @JvmName("eldbprnkppjgrhva")
    public suspend fun desiredMemberCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredMemberCount = mapped
    }

    /**
     * @param value Company name.
     */
    @JvmName("rlmwhypobscmsajg")
    public suspend fun organizationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationName = mapped
    }

    /**
     * @param value User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
     */
    @JvmName("udygpcvtcisucfvi")
    public suspend fun realPk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.realPk = mapped
    }

    /**
     * @param value This is organization source information
     */
    @JvmName("vvfhtapwrbgrgetx")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): OrganizationArgs = OrganizationArgs(
        desiredMemberCount = desiredMemberCount,
        organizationName = organizationName,
        realPk = realPk,
        source = source,
    )
}
