@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rdc.kotlin

import com.pulumi.alicloud.rdc.RdcFunctions.getOrganizationsPlain
import com.pulumi.alicloud.rdc.kotlin.inputs.GetOrganizationsPlainArgs
import com.pulumi.alicloud.rdc.kotlin.inputs.GetOrganizationsPlainArgsBuilder
import com.pulumi.alicloud.rdc.kotlin.outputs.GetOrganizationsResult
import com.pulumi.alicloud.rdc.kotlin.outputs.GetOrganizationsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object RdcFunctions {
    /**
     * This data source provides the Rdc Organizations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.137.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "tf-testAccOrganizations-Organizations";
     * const _default = new alicloud.rdc.Organization("default", {
     *     organizationName: name,
     *     source: name,
     * });
     * const ids = alicloud.rdc.getOrganizationsOutput({
     *     ids: [_default&#46;id],
     * });
     * export const rdcOrganizationId1 = ids.apply(ids => ids.id);
     * const nameRegex = alicloud.rdc.getOrganizations({
     *     nameRegex: "^my-Organization",
     * });
     * export const rdcOrganizationId2 = nameRegex.then(nameRegex => nameRegex.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "tf-testAccOrganizations-Organizations"
     * default = alicloud.rdc.Organization("default",
     *     organization_name=name,
     *     source=name)
     * ids = alicloud.rdc.get_organizations_output(ids=[default&#46;id])
     * pulumi.export("rdcOrganizationId1", ids.id)
     * name_regex = alicloud.rdc.get_organizations(name_regex="^my-Organization")
     * pulumi.export("rdcOrganizationId2", name_regex.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "tf-testAccOrganizations-Organizations";
     *     var @default = new AliCloud.Rdc.Organization("default", new()
     *     {
     *         OrganizationName = name,
     *         Source = name,
     *     });
     *     var ids = AliCloud.Rdc.GetOrganizations.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             @default.Id,
     *         },
     *     });
     *     var nameRegex = AliCloud.Rdc.GetOrganizations.Invoke(new()
     *     {
     *         NameRegex = "^my-Organization",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["rdcOrganizationId1"] = ids.Apply(getOrganizationsResult => getOrganizationsResult.Id),
     *         ["rdcOrganizationId2"] = nameRegex.Apply(getOrganizationsResult => getOrganizationsResult.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rdc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "tf-testAccOrganizations-Organizations"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_, err := rdc.NewOrganization(ctx, "default", &rdc.OrganizationArgs{
     * 			OrganizationName: pulumi.String(name),
     * 			Source:           pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := rdc.GetOrganizationsOutput(ctx, rdc.GetOrganizationsOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				_default.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("rdcOrganizationId1", ids.ApplyT(func(ids rdc.GetOrganizationsResult) (*string, error) {
     * 			return &ids.Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		nameRegex, err := rdc.GetOrganizations(ctx, &rdc.GetOrganizationsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Organization"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("rdcOrganizationId2", nameRegex.Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rdc.Organization;
     * import com.pulumi.alicloud.rdc.OrganizationArgs;
     * import com.pulumi.alicloud.rdc.RdcFunctions;
     * import com.pulumi.alicloud.rdc.inputs.GetOrganizationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("tf-testAccOrganizations-Organizations");
     *         var default_ = new Organization("default", OrganizationArgs.builder()
     *             .organizationName(name)
     *             .source(name)
     *             .build());
     *         final var ids = RdcFunctions.getOrganizations(GetOrganizationsArgs.builder()
     *             .ids(default_.id())
     *             .build());
     *         ctx.export("rdcOrganizationId1", ids.applyValue(getOrganizationsResult -> getOrganizationsResult).applyValue(ids -> ids.applyValue(getOrganizationsResult -> getOrganizationsResult.id())));
     *         final var nameRegex = RdcFunctions.getOrganizations(GetOrganizationsArgs.builder()
     *             .nameRegex("^my-Organization")
     *             .build());
     *         ctx.export("rdcOrganizationId2", nameRegex.applyValue(getOrganizationsResult -> getOrganizationsResult.id()));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: tf-testAccOrganizations-Organizations
     * resources:
     *   default:
     *     type: alicloud:rdc:Organization
     *     properties:
     *       organizationName: ${name}
     *       source: ${name}
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:rdc:getOrganizations
     *       Arguments:
     *         ids:
     *           - ${default.id}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:rdc:getOrganizations
     *       Arguments:
     *         nameRegex: ^my-Organization
     * outputs:
     *   rdcOrganizationId1: ${ids.id}
     *   rdcOrganizationId2: ${nameRegex.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOrganizations.
     * @return A collection of values returned by getOrganizations.
     */
    public suspend fun getOrganizations(argument: GetOrganizationsPlainArgs): GetOrganizationsResult =
        toKotlin(getOrganizationsPlain(argument.toJava()).await())

    /**
     * @see [getOrganizations].
     * @param ids A list of Organization IDs.
     * @param nameRegex A regex string to filter results by Organization name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param realPk User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
     * @return A collection of values returned by getOrganizations.
     */
    public suspend fun getOrganizations(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        realPk: String? = null,
    ): GetOrganizationsResult {
        val argument = GetOrganizationsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            realPk = realPk,
        )
        return toKotlin(getOrganizationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrganizations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rdc&#46;kotlin&#46;inputs&#46;GetOrganizationsPlainArgs].
     * @return A collection of values returned by getOrganizations.
     */
    public suspend fun getOrganizations(argument: suspend GetOrganizationsPlainArgsBuilder.() -> Unit): GetOrganizationsResult {
        val builder = GetOrganizationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getOrganizationsPlain(builtArgument.toJava()).await())
    }
}
