@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rdc.kotlin.inputs

import com.pulumi.alicloud.rdc.inputs.GetOrganizationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOrganizations.
 * @property ids A list of Organization IDs.
 * @property nameRegex A regex string to filter results by Organization name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property realPk User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
 */
public data class GetOrganizationsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val realPk: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rdc.inputs.GetOrganizationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rdc.inputs.GetOrganizationsPlainArgs =
        com.pulumi.alicloud.rdc.inputs.GetOrganizationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .realPk(realPk?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrganizationsPlainArgs].
 */
@PulumiTagMarker
public class GetOrganizationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var realPk: String? = null

    /**
     * @param value A list of Organization IDs.
     */
    @JvmName("cbmncyxjpsnjwsug")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Organization IDs.
     */
    @JvmName("ggmlnofvjnsjjgdd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Organization name.
     */
    @JvmName("uobgrolhlqtpbotm")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ftjquotosmykntaf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
     */
    @JvmName("paqxtiirxylffdqf")
    public suspend fun realPk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.realPk = mapped
    }

    internal fun build(): GetOrganizationsPlainArgs = GetOrganizationsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        realPk = realPk,
    )
}
