@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rdc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOrganizations.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property organizations
 * @property outputFile
 * @property realPk
 */
public data class GetOrganizationsResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val organizations: List<GetOrganizationsOrganization>,
    public val outputFile: String? = null,
    public val realPk: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rdc.outputs.GetOrganizationsResult): GetOrganizationsResult = GetOrganizationsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            organizations = javaType.organizations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rdc.kotlin.outputs.GetOrganizationsOrganization.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            realPk = javaType.realPk().map({ args0 -> args0 }).orElse(null),
        )
    }
}
