@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.AccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an RDS account resource and used to manage databases.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.120.0`. Please use new resource alicloud_rds_account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const creation = config.get("creation") || "Rds";
 * const name = config.get("name") || "dbaccountmysql";
 * const default = alicloud.getZones({
 *     availableResourceCreation: creation,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const instance = new alicloud.rds.Instance("instance", {
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 *     instanceType: "rds.mysql.s1.small",
 *     instanceStorage: 10,
 *     vswitchId: defaultSwitch.id,
 *     instanceName: name,
 * });
 * const account = new alicloud.rds.Account("account", {
 *     instanceId: instance.id,
 *     name: "tftestnormal",
 *     password: "Test12345",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * creation = config.get("creation")
 * if creation is None:
 *     creation = "Rds"
 * name = config.get("name")
 * if name is None:
 *     name = "dbaccountmysql"
 * default = alicloud.get_zones(available_resource_creation=creation)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * instance = alicloud.rds.Instance("instance",
 *     engine="MySQL",
 *     engine_version="5.6",
 *     instance_type="rds.mysql.s1.small",
 *     instance_storage=10,
 *     vswitch_id=default_switch.id,
 *     instance_name=name)
 * account = alicloud.rds.Account("account",
 *     instance_id=instance.id,
 *     name="tftestnormal",
 *     password="Test12345")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var creation = config.Get("creation") ?? "Rds";
 *     var name = config.Get("name") ?? "dbaccountmysql";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = creation,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var instance = new AliCloud.Rds.Instance("instance", new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *         InstanceType = "rds.mysql.s1.small",
 *         InstanceStorage = 10,
 *         VswitchId = defaultSwitch.Id,
 *         InstanceName = name,
 *     });
 *     var account = new AliCloud.Rds.Account("account", new()
 *     {
 *         InstanceId = instance.Id,
 *         Name = "tftestnormal",
 *         Password = "Test12345",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		creation := "Rds"
 * 		if param := cfg.Get("creation"); param != "" {
 * 			creation = param
 * 		}
 * 		name := "dbaccountmysql"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef(creation),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		instance, err := rds.NewInstance(ctx, "instance", &rds.InstanceArgs{
 * 			Engine:          pulumi.String("MySQL"),
 * 			EngineVersion:   pulumi.String("5.6"),
 * 			InstanceType:    pulumi.String("rds.mysql.s1.small"),
 * 			InstanceStorage: pulumi.Int(10),
 * 			VswitchId:       defaultSwitch.ID(),
 * 			InstanceName:    pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewAccount(ctx, "account", &rds.AccountArgs{
 * 			InstanceId: instance.ID(),
 * 			Name:       pulumi.String("tftestnormal"),
 * 			Password:   pulumi.String("Test12345"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.rds.Instance;
 * import com.pulumi.alicloud.rds.InstanceArgs;
 * import com.pulumi.alicloud.rds.Account;
 * import com.pulumi.alicloud.rds.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var creation = config.get("creation").orElse("Rds");
 *         final var name = config.get("name").orElse("dbaccountmysql");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation(creation)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .instanceType("rds.mysql.s1.small")
 *             .instanceStorage("10")
 *             .vswitchId(defaultSwitch.id())
 *             .instanceName(name)
 *             .build());
 *         var account = new Account("account", AccountArgs.builder()
 *             .instanceId(instance.id())
 *             .name("tftestnormal")
 *             .password("Test12345")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   creation:
 *     type: string
 *     default: Rds
 *   name:
 *     type: string
 *     default: dbaccountmysql
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   instance:
 *     type: alicloud:rds:Instance
 *     properties:
 *       engine: MySQL
 *       engineVersion: '5.6'
 *       instanceType: rds.mysql.s1.small
 *       instanceStorage: '10'
 *       vswitchId: ${defaultSwitch.id}
 *       instanceName: ${name}
 *   account:
 *     type: alicloud:rds:Account
 *     properties:
 *       instanceId: ${instance.id}
 *       name: tftestnormal
 *       password: Test12345
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: ${creation}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/account:Account example "rm-12345:tf_account"
 * ```
 * @property accountDescription
 * @property accountName
 * @property accountPassword
 * @property accountType
 * @property dbInstanceId
 * @property description Database description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
 * @property instanceId The Id of instance in which account belongs.
 * @property kmsEncryptedPassword An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 * @property name Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
 * @property password Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters. You have to specify one of `password` and `kms_encrypted_password` fields.
 * @property resetPermissionFlag
 * @property type Privilege type of account. The SQLServer engine does not support create high privilege accounts.
 * - Normal: Common privilege.
 * - Super: High privilege.
 * Default to Normal.
 */
public data class AccountArgs(
    public val accountDescription: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val accountPassword: Output<String>? = null,
    public val accountType: Output<String>? = null,
    public val dbInstanceId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'description' has been deprecated from provider version 1.120.0. New field
      'account_description' instead.
  """,
    )
    public val description: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id'
      instead.
  """,
    )
    public val instanceId: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password'
      instead.
  """,
    )
    public val password: Output<String>? = null,
    public val resetPermissionFlag: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.
  """,
    )
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.AccountArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.AccountArgs =
        com.pulumi.alicloud.rds.AccountArgs.builder()
            .accountDescription(accountDescription?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .accountPassword(accountPassword?.applyValue({ args0 -> args0 }))
            .accountType(accountType?.applyValue({ args0 -> args0 }))
            .dbInstanceId(dbInstanceId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resetPermissionFlag(resetPermissionFlag?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountDescription: Output<String>? = null

    private var accountName: Output<String>? = null

    private var accountPassword: Output<String>? = null

    private var accountType: Output<String>? = null

    private var dbInstanceId: Output<String>? = null

    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var resetPermissionFlag: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("tgdhhmirnartluex")
    public suspend fun accountDescription(`value`: Output<String>) {
        this.accountDescription = value
    }

    /**
     * @param value
     */
    @JvmName("pyvdsalxvxnobwap")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value
     */
    @JvmName("bwvvlhmilfdleymo")
    public suspend fun accountPassword(`value`: Output<String>) {
        this.accountPassword = value
    }

    /**
     * @param value
     */
    @JvmName("eowtylqfnqbdsjrd")
    public suspend fun accountType(`value`: Output<String>) {
        this.accountType = value
    }

    /**
     * @param value
     */
    @JvmName("hutmulhxfyroyrwe")
    public suspend fun dbInstanceId(`value`: Output<String>) {
        this.dbInstanceId = value
    }

    /**
     * @param value Database description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
     */
    @Deprecated(
        message = """
  Field 'description' has been deprecated from provider version 1.120.0. New field
      'account_description' instead.
  """,
    )
    @JvmName("eyclbhvjcwiyjhdl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Id of instance in which account belongs.
     */
    @Deprecated(
        message = """
  Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id'
      instead.
  """,
    )
    @JvmName("itibpnpgupjskfjy")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
     */
    @JvmName("wxmaeoijhxpipkqh")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("jduqiwqkmlpinuga")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.
  """,
    )
    @JvmName("fbcksdyxcubebaly")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters. You have to specify one of `password` and `kms_encrypted_password` fields.
     */
    @Deprecated(
        message = """
  Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password'
      instead.
  """,
    )
    @JvmName("xxwwoxpwnugjexmm")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value
     */
    @JvmName("gwmwyewrohyunrpw")
    public suspend fun resetPermissionFlag(`value`: Output<Boolean>) {
        this.resetPermissionFlag = value
    }

    /**
     * @param value Privilege type of account. The SQLServer engine does not support create high privilege accounts.
     * - Normal: Common privilege.
     * - Super: High privilege.
     * Default to Normal.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.
  """,
    )
    @JvmName("hsiqvohnlfnwibpp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("fpvtpsqiikctisqm")
    public suspend fun accountDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountDescription = mapped
    }

    /**
     * @param value
     */
    @JvmName("rbbkurmqfmqvvloj")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value
     */
    @JvmName("cgodtueprcisomdu")
    public suspend fun accountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPassword = mapped
    }

    /**
     * @param value
     */
    @JvmName("mrvrlvmxrsngsgcr")
    public suspend fun accountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value
     */
    @JvmName("cemabmylovpdxndd")
    public suspend fun dbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceId = mapped
    }

    /**
     * @param value Database description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
     */
    @Deprecated(
        message = """
  Field 'description' has been deprecated from provider version 1.120.0. New field
      'account_description' instead.
  """,
    )
    @JvmName("dfklhccvkacdyueb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Id of instance in which account belongs.
     */
    @Deprecated(
        message = """
  Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id'
      instead.
  """,
    )
    @JvmName("trodyjuqidltdehv")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
     */
    @JvmName("eqjtescpgffienug")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("qusqxsehqmrkiqle")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("snnbxjferrprrsic")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.
  """,
    )
    @JvmName("sgqlodookpaphcem")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters. You have to specify one of `password` and `kms_encrypted_password` fields.
     */
    @Deprecated(
        message = """
  Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password'
      instead.
  """,
    )
    @JvmName("hbfcxetjxiinpyrx")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value
     */
    @JvmName("dspsokfoeneliqwr")
    public suspend fun resetPermissionFlag(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resetPermissionFlag = mapped
    }

    /**
     * @param value Privilege type of account. The SQLServer engine does not support create high privilege accounts.
     * - Normal: Common privilege.
     * - Super: High privilege.
     * Default to Normal.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.
  """,
    )
    @JvmName("lbqriqpxjdglsthl")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountDescription = accountDescription,
        accountName = accountName,
        accountPassword = accountPassword,
        accountType = accountType,
        dbInstanceId = dbInstanceId,
        description = description,
        instanceId = instanceId,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        name = name,
        password = password,
        resetPermissionFlag = resetPermissionFlag,
        type = type,
    )
}
