@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BackupPolicy].
 */
@PulumiTagMarker
public class BackupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupPolicyArgs = BackupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupPolicyArgsBuilder.() -> Unit) {
        val builder = BackupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BackupPolicy {
        val builtJavaResource = com.pulumi.alicloud.rds.BackupPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BackupPolicy(builtJavaResource)
    }
}

/**
 * Provides an RDS instance backup policy resource and used to configure instance backup policy, see [What is DB Backup Policy](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-modifybackuppolicy).
 * > **NOTE:** Each DB instance has a backup policy and it will be set default values when destroying the resource.
 * > **NOTE:** Available since v1.5.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.rds.getZones({
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const instance = new alicloud.rds.Instance("instance", {
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 *     instanceType: "rds.mysql.s1.small",
 *     instanceStorage: 10,
 *     vswitchId: defaultSwitch.id,
 *     instanceName: name,
 * });
 * const policy = new alicloud.rds.BackupPolicy("policy", {instanceId: instance.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.rds.get_zones(engine="MySQL",
 *     engine_version="5.6")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * instance = alicloud.rds.Instance("instance",
 *     engine="MySQL",
 *     engine_version="5.6",
 *     instance_type="rds.mysql.s1.small",
 *     instance_storage=10,
 *     vswitch_id=default_switch.id,
 *     instance_name=name)
 * policy = alicloud.rds.BackupPolicy("policy", instance_id=instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Rds.GetZones.Invoke(new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var instance = new AliCloud.Rds.Instance("instance", new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *         InstanceType = "rds.mysql.s1.small",
 *         InstanceStorage = 10,
 *         VswitchId = defaultSwitch.Id,
 *         InstanceName = name,
 *     });
 *     var policy = new AliCloud.Rds.BackupPolicy("policy", new()
 *     {
 *         InstanceId = instance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := rds.GetZones(ctx, &rds.GetZonesArgs{
 * 			Engine:        pulumi.StringRef("MySQL"),
 * 			EngineVersion: pulumi.StringRef("5.6"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		instance, err := rds.NewInstance(ctx, "instance", &rds.InstanceArgs{
 * 			Engine:          pulumi.String("MySQL"),
 * 			EngineVersion:   pulumi.String("5.6"),
 * 			InstanceType:    pulumi.String("rds.mysql.s1.small"),
 * 			InstanceStorage: pulumi.Int(10),
 * 			VswitchId:       defaultSwitch.ID(),
 * 			InstanceName:    pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewBackupPolicy(ctx, "policy", &rds.BackupPolicyArgs{
 * 			InstanceId: instance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.RdsFunctions;
 * import com.pulumi.alicloud.rds.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.rds.Instance;
 * import com.pulumi.alicloud.rds.InstanceArgs;
 * import com.pulumi.alicloud.rds.BackupPolicy;
 * import com.pulumi.alicloud.rds.BackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = RdsFunctions.getZones(GetZonesArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .instanceType("rds.mysql.s1.small")
 *             .instanceStorage("10")
 *             .vswitchId(defaultSwitch.id())
 *             .instanceName(name)
 *             .build());
 *         var policy = new BackupPolicy("policy", BackupPolicyArgs.builder()
 *             .instanceId(instance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   instance:
 *     type: alicloud:rds:Instance
 *     properties:
 *       engine: MySQL
 *       engineVersion: '5.6'
 *       instanceType: rds.mysql.s1.small
 *       instanceStorage: '10'
 *       vswitchId: ${defaultSwitch.id}
 *       instanceName: ${name}
 *   policy:
 *     type: alicloud:rds:BackupPolicy
 *     properties:
 *       instanceId: ${instance.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:rds:getZones
 *       Arguments:
 *         engine: MySQL
 *         engineVersion: '5.6'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS backup policy can be imported using the id or instance id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/backupPolicy:BackupPolicy example "rm-12345678"
 * ```
 */
public class BackupPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.rds.BackupPolicy,
) : KotlinCustomResource(javaResource, BackupPolicyMapper) {
    /**
     * Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]&#46; When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
     */
    public val archiveBackupKeepCount: Output<Int>
        get() = javaResource.archiveBackupKeepCount().applyValue({ args0 -> args0 })

    /**
     * Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
     */
    public val archiveBackupKeepPolicy: Output<String>
        get() = javaResource.archiveBackupKeepPolicy().applyValue({ args0 -> args0 })

    /**
     * Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
     */
    public val archiveBackupRetentionPeriod: Output<Int>
        get() = javaResource.archiveBackupRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * The frequency at which you want to perform a snapshot backup on the instance. Valid values:
     * - -1: No backup frequencies are specified.
     * - 30: A snapshot backup is performed once every 30 minutes.
     * - 60: A snapshot backup is performed once every 60 minutes.
     * - 120: A snapshot backup is performed once every 120 minutes.
     * - 240: A snapshot backup is performed once every 240 minutes.
     * - 360: A snapshot backup is performed once every 360 minutes.
     * - 480: A snapshot backup is performed once every 480 minutes.
     * - 720: A snapshot backup is performed once every 720 minutes.
     * > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
     */
    public val backupInterval: Output<String>
        get() = javaResource.backupInterval().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period`
      instead
  """,
    )
    public val backupPeriods: Output<List<String>>
        get() = javaResource.backupPeriods().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
     */
    public val backupRetentionPeriod: Output<Int>?
        get() = javaResource.backupRetentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
     */
    @Deprecated(
        message = """
  Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time`
      instead
  """,
    )
    public val backupTime: Output<String>
        get() = javaResource.backupTime().applyValue({ args0 -> args0 })

    /**
     * Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
     * > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The compress type of instance policy. Valid values are `1`, `4`, `8`.
     */
    public val compressType: Output<String>
        get() = javaResource.compressType().applyValue({ args0 -> args0 })

    /**
     * Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
     */
    public val enableBackupLog: Output<Boolean>
        get() = javaResource.enableBackupLog().applyValue({ args0 -> args0 })

    /**
     * Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
     */
    public val highSpaceUsageProtection: Output<String>?
        get() = javaResource.highSpaceUsageProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Id of instance that can run database.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
     */
    public val localLogRetentionHours: Output<Int>
        get() = javaResource.localLogRetentionHours().applyValue({ args0 -> args0 })

    /**
     * Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
     */
    public val localLogRetentionSpace: Output<Int>
        get() = javaResource.localLogRetentionSpace().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
     */
    @Deprecated(
        message = """
  Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead
  """,
    )
    public val logBackup: Output<Boolean>
        get() = javaResource.logBackup().applyValue({ args0 -> args0 })

    /**
     * Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
     */
    public val logBackupFrequency: Output<String>
        get() = javaResource.logBackupFrequency().applyValue({ args0 -> args0 })

    /**
     * Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
     */
    public val logBackupRetentionPeriod: Output<Int>
        get() = javaResource.logBackupRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use
      `log_backup_retention_period` instead
  """,
    )
    public val logRetentionPeriod: Output<Int>
        get() = javaResource.logRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    public val preferredBackupPeriods: Output<List<String>>
        get() = javaResource.preferredBackupPeriods().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
     */
    public val preferredBackupTime: Output<String>?
        get() = javaResource.preferredBackupTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
     * * **None**: No archived backup files are retained.
     * * **Lastest**: Only the most recent archived backup file is retained.
     * * **All**: All archived backup files are retained.
     */
    public val releasedKeepPolicy: Output<String>
        get() = javaResource.releasedKeepPolicy().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'retention_period' has been deprecated from version 1.69.0. Use
      `backup_retention_period` instead
  """,
    )
    public val retentionPeriod: Output<Int>
        get() = javaResource.retentionPeriod().applyValue({ args0 -> args0 })
}

public object BackupPolicyMapper : ResourceMapper<BackupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rds.BackupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BackupPolicy = BackupPolicy(
        javaResource as
            com.pulumi.alicloud.rds.BackupPolicy,
    )
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupPolicy].
 */
public suspend fun backupPolicy(
    name: String,
    block: suspend BackupPolicyResourceBuilder.() -> Unit,
): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupPolicy(name: String): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
