@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.BackupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an RDS instance backup policy resource and used to configure instance backup policy, see [What is DB Backup Policy](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-modifybackuppolicy).
 * > **NOTE:** Each DB instance has a backup policy and it will be set default values when destroying the resource.
 * > **NOTE:** Available since v1.5.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.rds.getZones({
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const instance = new alicloud.rds.Instance("instance", {
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 *     instanceType: "rds.mysql.s1.small",
 *     instanceStorage: 10,
 *     vswitchId: defaultSwitch.id,
 *     instanceName: name,
 * });
 * const policy = new alicloud.rds.BackupPolicy("policy", {instanceId: instance.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.rds.get_zones(engine="MySQL",
 *     engine_version="5.6")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * instance = alicloud.rds.Instance("instance",
 *     engine="MySQL",
 *     engine_version="5.6",
 *     instance_type="rds.mysql.s1.small",
 *     instance_storage=10,
 *     vswitch_id=default_switch.id,
 *     instance_name=name)
 * policy = alicloud.rds.BackupPolicy("policy", instance_id=instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Rds.GetZones.Invoke(new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var instance = new AliCloud.Rds.Instance("instance", new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *         InstanceType = "rds.mysql.s1.small",
 *         InstanceStorage = 10,
 *         VswitchId = defaultSwitch.Id,
 *         InstanceName = name,
 *     });
 *     var policy = new AliCloud.Rds.BackupPolicy("policy", new()
 *     {
 *         InstanceId = instance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := rds.GetZones(ctx, &rds.GetZonesArgs{
 * 			Engine:        pulumi.StringRef("MySQL"),
 * 			EngineVersion: pulumi.StringRef("5.6"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		instance, err := rds.NewInstance(ctx, "instance", &rds.InstanceArgs{
 * 			Engine:          pulumi.String("MySQL"),
 * 			EngineVersion:   pulumi.String("5.6"),
 * 			InstanceType:    pulumi.String("rds.mysql.s1.small"),
 * 			InstanceStorage: pulumi.Int(10),
 * 			VswitchId:       defaultSwitch.ID(),
 * 			InstanceName:    pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewBackupPolicy(ctx, "policy", &rds.BackupPolicyArgs{
 * 			InstanceId: instance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.RdsFunctions;
 * import com.pulumi.alicloud.rds.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.rds.Instance;
 * import com.pulumi.alicloud.rds.InstanceArgs;
 * import com.pulumi.alicloud.rds.BackupPolicy;
 * import com.pulumi.alicloud.rds.BackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = RdsFunctions.getZones(GetZonesArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .instanceType("rds.mysql.s1.small")
 *             .instanceStorage("10")
 *             .vswitchId(defaultSwitch.id())
 *             .instanceName(name)
 *             .build());
 *         var policy = new BackupPolicy("policy", BackupPolicyArgs.builder()
 *             .instanceId(instance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   instance:
 *     type: alicloud:rds:Instance
 *     properties:
 *       engine: MySQL
 *       engineVersion: '5.6'
 *       instanceType: rds.mysql.s1.small
 *       instanceStorage: '10'
 *       vswitchId: ${defaultSwitch.id}
 *       instanceName: ${name}
 *   policy:
 *     type: alicloud:rds:BackupPolicy
 *     properties:
 *       instanceId: ${instance.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:rds:getZones
 *       Arguments:
 *         engine: MySQL
 *         engineVersion: '5.6'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS backup policy can be imported using the id or instance id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/backupPolicy:BackupPolicy example "rm-12345678"
 * ```
 * @property archiveBackupKeepCount Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]&#46; When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
 * @property archiveBackupKeepPolicy Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
 * @property archiveBackupRetentionPeriod Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
 * @property backupInterval The frequency at which you want to perform a snapshot backup on the instance. Valid values:
 * - -1: No backup frequencies are specified.
 * - 30: A snapshot backup is performed once every 30 minutes.
 * - 60: A snapshot backup is performed once every 60 minutes.
 * - 120: A snapshot backup is performed once every 120 minutes.
 * - 240: A snapshot backup is performed once every 240 minutes.
 * - 360: A snapshot backup is performed once every 360 minutes.
 * - 480: A snapshot backup is performed once every 480 minutes.
 * - 720: A snapshot backup is performed once every 720 minutes.
 * > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
 * @property backupPeriods It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
 * @property backupRetentionPeriod Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
 * @property backupTime It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
 * @property category Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
 * > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
 * @property compressType The compress type of instance policy. Valid values are `1`, `4`, `8`.
 * @property enableBackupLog Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
 * @property highSpaceUsageProtection Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
 * @property instanceId The Id of instance that can run database.
 * @property localLogRetentionHours Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
 * @property localLogRetentionSpace Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
 * @property logBackup It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
 * @property logBackupFrequency Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
 * @property logBackupRetentionPeriod Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
 * @property logRetentionPeriod It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
 * @property preferredBackupPeriods DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
 * @property preferredBackupTime DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
 * @property releasedKeepPolicy The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
 * * **None**: No archived backup files are retained.
 * * **Lastest**: Only the most recent archived backup file is retained.
 * * **All**: All archived backup files are retained.
 * @property retentionPeriod It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
 */
public data class BackupPolicyArgs(
    public val archiveBackupKeepCount: Output<Int>? = null,
    public val archiveBackupKeepPolicy: Output<String>? = null,
    public val archiveBackupRetentionPeriod: Output<Int>? = null,
    public val backupInterval: Output<String>? = null,
    @Deprecated(
        message = """
  Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period`
      instead
  """,
    )
    public val backupPeriods: Output<List<String>>? = null,
    public val backupRetentionPeriod: Output<Int>? = null,
    @Deprecated(
        message = """
  Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time`
      instead
  """,
    )
    public val backupTime: Output<String>? = null,
    public val category: Output<String>? = null,
    public val compressType: Output<String>? = null,
    public val enableBackupLog: Output<Boolean>? = null,
    public val highSpaceUsageProtection: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val localLogRetentionHours: Output<Int>? = null,
    public val localLogRetentionSpace: Output<Int>? = null,
    @Deprecated(
        message = """
  Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead
  """,
    )
    public val logBackup: Output<Boolean>? = null,
    public val logBackupFrequency: Output<String>? = null,
    public val logBackupRetentionPeriod: Output<Int>? = null,
    @Deprecated(
        message = """
  Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use
      `log_backup_retention_period` instead
  """,
    )
    public val logRetentionPeriod: Output<Int>? = null,
    public val preferredBackupPeriods: Output<List<String>>? = null,
    public val preferredBackupTime: Output<String>? = null,
    public val releasedKeepPolicy: Output<String>? = null,
    @Deprecated(
        message = """
  Attribute 'retention_period' has been deprecated from version 1.69.0. Use
      `backup_retention_period` instead
  """,
    )
    public val retentionPeriod: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.BackupPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.BackupPolicyArgs =
        com.pulumi.alicloud.rds.BackupPolicyArgs.builder()
            .archiveBackupKeepCount(archiveBackupKeepCount?.applyValue({ args0 -> args0 }))
            .archiveBackupKeepPolicy(archiveBackupKeepPolicy?.applyValue({ args0 -> args0 }))
            .archiveBackupRetentionPeriod(archiveBackupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .backupInterval(backupInterval?.applyValue({ args0 -> args0 }))
            .backupPeriods(backupPeriods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .backupRetentionPeriod(backupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .backupTime(backupTime?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .compressType(compressType?.applyValue({ args0 -> args0 }))
            .enableBackupLog(enableBackupLog?.applyValue({ args0 -> args0 }))
            .highSpaceUsageProtection(highSpaceUsageProtection?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .localLogRetentionHours(localLogRetentionHours?.applyValue({ args0 -> args0 }))
            .localLogRetentionSpace(localLogRetentionSpace?.applyValue({ args0 -> args0 }))
            .logBackup(logBackup?.applyValue({ args0 -> args0 }))
            .logBackupFrequency(logBackupFrequency?.applyValue({ args0 -> args0 }))
            .logBackupRetentionPeriod(logBackupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .logRetentionPeriod(logRetentionPeriod?.applyValue({ args0 -> args0 }))
            .preferredBackupPeriods(
                preferredBackupPeriods?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .preferredBackupTime(preferredBackupTime?.applyValue({ args0 -> args0 }))
            .releasedKeepPolicy(releasedKeepPolicy?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyArgsBuilder internal constructor() {
    private var archiveBackupKeepCount: Output<Int>? = null

    private var archiveBackupKeepPolicy: Output<String>? = null

    private var archiveBackupRetentionPeriod: Output<Int>? = null

    private var backupInterval: Output<String>? = null

    private var backupPeriods: Output<List<String>>? = null

    private var backupRetentionPeriod: Output<Int>? = null

    private var backupTime: Output<String>? = null

    private var category: Output<String>? = null

    private var compressType: Output<String>? = null

    private var enableBackupLog: Output<Boolean>? = null

    private var highSpaceUsageProtection: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var localLogRetentionHours: Output<Int>? = null

    private var localLogRetentionSpace: Output<Int>? = null

    private var logBackup: Output<Boolean>? = null

    private var logBackupFrequency: Output<String>? = null

    private var logBackupRetentionPeriod: Output<Int>? = null

    private var logRetentionPeriod: Output<Int>? = null

    private var preferredBackupPeriods: Output<List<String>>? = null

    private var preferredBackupTime: Output<String>? = null

    private var releasedKeepPolicy: Output<String>? = null

    private var retentionPeriod: Output<Int>? = null

    /**
     * @param value Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]&#46; When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
     */
    @JvmName("gpovtbfhnynkbajb")
    public suspend fun archiveBackupKeepCount(`value`: Output<Int>) {
        this.archiveBackupKeepCount = value
    }

    /**
     * @param value Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
     */
    @JvmName("cokpffyafnyrcsfr")
    public suspend fun archiveBackupKeepPolicy(`value`: Output<String>) {
        this.archiveBackupKeepPolicy = value
    }

    /**
     * @param value Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
     */
    @JvmName("rplwlnwqacpokooo")
    public suspend fun archiveBackupRetentionPeriod(`value`: Output<Int>) {
        this.archiveBackupRetentionPeriod = value
    }

    /**
     * @param value The frequency at which you want to perform a snapshot backup on the instance. Valid values:
     * - -1: No backup frequencies are specified.
     * - 30: A snapshot backup is performed once every 30 minutes.
     * - 60: A snapshot backup is performed once every 60 minutes.
     * - 120: A snapshot backup is performed once every 120 minutes.
     * - 240: A snapshot backup is performed once every 240 minutes.
     * - 360: A snapshot backup is performed once every 360 minutes.
     * - 480: A snapshot backup is performed once every 480 minutes.
     * - 720: A snapshot backup is performed once every 720 minutes.
     * > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
     */
    @JvmName("ocdelwngcrgqykgm")
    public suspend fun backupInterval(`value`: Output<String>) {
        this.backupInterval = value
    }

    /**
     * @param value It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period`
      instead
  """,
    )
    @JvmName("qhfhywvkwxhdntdt")
    public suspend fun backupPeriods(`value`: Output<List<String>>) {
        this.backupPeriods = value
    }

    @JvmName("eamlsclfihsbenpi")
    public suspend fun backupPeriods(vararg values: Output<String>) {
        this.backupPeriods = Output.all(values.asList())
    }

    /**
     * @param values It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period`
      instead
  """,
    )
    @JvmName("humhaknrinjlafav")
    public suspend fun backupPeriods(values: List<Output<String>>) {
        this.backupPeriods = Output.all(values)
    }

    /**
     * @param value Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
     */
    @JvmName("chpweljbbygvnfkx")
    public suspend fun backupRetentionPeriod(`value`: Output<Int>) {
        this.backupRetentionPeriod = value
    }

    /**
     * @param value It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
     */
    @Deprecated(
        message = """
  Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time`
      instead
  """,
    )
    @JvmName("dvodocjjbouxymia")
    public suspend fun backupTime(`value`: Output<String>) {
        this.backupTime = value
    }

    /**
     * @param value Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
     * > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
     */
    @JvmName("eginkqmmxhjxgspw")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The compress type of instance policy. Valid values are `1`, `4`, `8`.
     */
    @JvmName("spvulpejaxgdbwxm")
    public suspend fun compressType(`value`: Output<String>) {
        this.compressType = value
    }

    /**
     * @param value Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
     */
    @JvmName("dxvsievgamdrnmls")
    public suspend fun enableBackupLog(`value`: Output<Boolean>) {
        this.enableBackupLog = value
    }

    /**
     * @param value Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
     */
    @JvmName("jntpnwmkifelgnxh")
    public suspend fun highSpaceUsageProtection(`value`: Output<String>) {
        this.highSpaceUsageProtection = value
    }

    /**
     * @param value The Id of instance that can run database.
     */
    @JvmName("wgwxajeprbrvqwcl")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
     */
    @JvmName("huqluojguvgkswbe")
    public suspend fun localLogRetentionHours(`value`: Output<Int>) {
        this.localLogRetentionHours = value
    }

    /**
     * @param value Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
     */
    @JvmName("pixnvrhofsbebneb")
    public suspend fun localLogRetentionSpace(`value`: Output<Int>) {
        this.localLogRetentionSpace = value
    }

    /**
     * @param value It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
     */
    @Deprecated(
        message = """
  Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead
  """,
    )
    @JvmName("snyrwdlbyrwwdraq")
    public suspend fun logBackup(`value`: Output<Boolean>) {
        this.logBackup = value
    }

    /**
     * @param value Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
     */
    @JvmName("gwqgukgkggmdybua")
    public suspend fun logBackupFrequency(`value`: Output<String>) {
        this.logBackupFrequency = value
    }

    /**
     * @param value Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
     */
    @JvmName("hyuimfwsjgwbjwvl")
    public suspend fun logBackupRetentionPeriod(`value`: Output<Int>) {
        this.logBackupRetentionPeriod = value
    }

    /**
     * @param value It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use
      `log_backup_retention_period` instead
  """,
    )
    @JvmName("iejokuqdftgpfsam")
    public suspend fun logRetentionPeriod(`value`: Output<Int>) {
        this.logRetentionPeriod = value
    }

    /**
     * @param value DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("dxopqimsctogisro")
    public suspend fun preferredBackupPeriods(`value`: Output<List<String>>) {
        this.preferredBackupPeriods = value
    }

    @JvmName("bewpcmbadxvilbge")
    public suspend fun preferredBackupPeriods(vararg values: Output<String>) {
        this.preferredBackupPeriods = Output.all(values.asList())
    }

    /**
     * @param values DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("vivsqpdfgiturllx")
    public suspend fun preferredBackupPeriods(values: List<Output<String>>) {
        this.preferredBackupPeriods = Output.all(values)
    }

    /**
     * @param value DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
     */
    @JvmName("bxnpflspaubutlll")
    public suspend fun preferredBackupTime(`value`: Output<String>) {
        this.preferredBackupTime = value
    }

    /**
     * @param value The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
     * * **None**: No archived backup files are retained.
     * * **Lastest**: Only the most recent archived backup file is retained.
     * * **All**: All archived backup files are retained.
     */
    @JvmName("dwjfcfdjkhmmquua")
    public suspend fun releasedKeepPolicy(`value`: Output<String>) {
        this.releasedKeepPolicy = value
    }

    /**
     * @param value It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'retention_period' has been deprecated from version 1.69.0. Use
      `backup_retention_period` instead
  """,
    )
    @JvmName("klqtinfamffnmura")
    public suspend fun retentionPeriod(`value`: Output<Int>) {
        this.retentionPeriod = value
    }

    /**
     * @param value Instance archive backup keep count. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. When `archive_backup_keep_policy` is `ByMonth` Valid values: [1-31]&#46; When `archive_backup_keep_policy` is `ByWeek` Valid values: [1-7].
     */
    @JvmName("jaaoxvxofarpyuvs")
    public suspend fun archiveBackupKeepCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveBackupKeepCount = mapped
    }

    /**
     * @param value Instance archive backup keep policy. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values are `ByMonth`, `ByWeek`, `KeepAll`.
     */
    @JvmName("hdsujuwfppfojsxb")
    public suspend fun archiveBackupKeepPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveBackupKeepPolicy = mapped
    }

    /**
     * @param value Instance archive backup retention days. Valid when the `enable_backup_log` is `true` and instance is mysql local disk. Valid values: [30-1095], and `archive_backup_retention_period` must larger than `backup_retention_period` 730.
     */
    @JvmName("hbsrdbgaejyshnin")
    public suspend fun archiveBackupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveBackupRetentionPeriod = mapped
    }

    /**
     * @param value The frequency at which you want to perform a snapshot backup on the instance. Valid values:
     * - -1: No backup frequencies are specified.
     * - 30: A snapshot backup is performed once every 30 minutes.
     * - 60: A snapshot backup is performed once every 60 minutes.
     * - 120: A snapshot backup is performed once every 120 minutes.
     * - 240: A snapshot backup is performed once every 240 minutes.
     * - 360: A snapshot backup is performed once every 360 minutes.
     * - 480: A snapshot backup is performed once every 480 minutes.
     * - 720: A snapshot backup is performed once every 720 minutes.
     * > **NOTE:** Currently, the SQLServer instance does not support to modify `log_backup_retention_period`.
     */
    @JvmName("lljvxxfmnyqgxsby")
    public suspend fun backupInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupInterval = mapped
    }

    /**
     * @param value It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period`
      instead
  """,
    )
    @JvmName("xccdpvcwyqcwwpik")
    public suspend fun backupPeriods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPeriods = mapped
    }

    /**
     * @param values It has been deprecated from version 1.69.0, and use field 'preferred_backup_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'backup_period' has been deprecated from version 1.69.0. Use `preferred_backup_period`
      instead
  """,
    )
    @JvmName("kjqpiriurxcckgkk")
    public suspend fun backupPeriods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupPeriods = mapped
    }

    /**
     * @param value Instance backup retention days. Valid values: [7-730]. Default to 7. But mysql local disk is unlimited.
     */
    @JvmName("kstwpvvkyktbbwmb")
    public suspend fun backupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionPeriod = mapped
    }

    /**
     * @param value It has been deprecated from version 1.69.0, and use field 'preferred_backup_time' instead.
     */
    @Deprecated(
        message = """
  Attribute 'backup_time' has been deprecated from version 1.69.0. Use `preferred_backup_time`
      instead
  """,
    )
    @JvmName("wrnkijbvqcuprcvp")
    public suspend fun backupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupTime = mapped
    }

    /**
     * @param value Whether to enable second level backup.Valid values are `Flash`, `Standard`, Note:It only takes effect when the BackupPolicyMode parameter is DataBackupPolicy.
     * > **NOTE:** You can configure a backup policy by using this parameter and the PreferredBackupPeriod parameter. For example, if you set the PreferredBackupPeriod parameter to Saturday,Sunday and the BackupInterval parameter to -1, a snapshot backup is performed on every Saturday and Sunday.If the instance runs PostgreSQL, the BackupInterval parameter is supported only when the instance is equipped with standard SSDs or enhanced SSDs (ESSDs).This parameter takes effect only when you set the BackupPolicyMode parameter to DataBackupPolicy.
     */
    @JvmName("cdctdqvjaosqkgff")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The compress type of instance policy. Valid values are `1`, `4`, `8`.
     */
    @JvmName("nkbsnauujjceahdt")
    public suspend fun compressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressType = mapped
    }

    /**
     * @param value Whether to backup instance log. Valid values are `true`, `false`, Default to `true`. Note: The 'Basic Edition' category Rds instance does not support setting log backup. [What is Basic Edition](https://www.alibabacloud.com/help/doc-detail/48980.htm).
     */
    @JvmName("mcdxcticnioklkbl")
    public suspend fun enableBackupLog(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBackupLog = mapped
    }

    /**
     * @param value Instance high space usage protection policy. Valid when the `enable_backup_log` is `true`. Valid values are `Enable`, `Disable`.
     */
    @JvmName("omvwrgmdvincpvaq")
    public suspend fun highSpaceUsageProtection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highSpaceUsageProtection = mapped
    }

    /**
     * @param value The Id of instance that can run database.
     */
    @JvmName("xbchbbvsiimfmwya")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Instance log backup local retention hours. Valid when the `enable_backup_log` is `true`. Valid values: [0-7*24].
     */
    @JvmName("kwmqfduekbsyusvn")
    public suspend fun localLogRetentionHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localLogRetentionHours = mapped
    }

    /**
     * @param value Instance log backup local retention space. Valid when the `enable_backup_log` is `true`. Valid values: [0-50].
     */
    @JvmName("dbusrcyffdvykepy")
    public suspend fun localLogRetentionSpace(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localLogRetentionSpace = mapped
    }

    /**
     * @param value It has been deprecated from version 1.68.0, and use field 'enable_backup_log' instead.
     */
    @Deprecated(
        message = """
  Attribute 'log_backup' has been deprecated from version 1.68.0. Use `enable_backup_log` instead
  """,
    )
    @JvmName("nhmkunncifcbxria")
    public suspend fun logBackup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logBackup = mapped
    }

    /**
     * @param value Instance log backup frequency. Valid when the instance engine is `SQLServer`. Valid values are `LogInterval`.
     */
    @JvmName("sqnwbkwroxvrstjb")
    public suspend fun logBackupFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logBackupFrequency = mapped
    }

    /**
     * @param value Instance log backup retention days. Valid when the `enable_backup_log` is `1`. Valid values: [7-730]. Default to 7. It cannot be larger than `backup_retention_period`.
     */
    @JvmName("hprmrllspgdusunb")
    public suspend fun logBackupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logBackupRetentionPeriod = mapped
    }

    /**
     * @param value It has been deprecated from version 1.69.0, and use field 'log_backup_retention_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'log_retention_period' has been deprecated from version 1.69.0. Use
      `log_backup_retention_period` instead
  """,
    )
    @JvmName("dwqmxtuembxdvkuf")
    public suspend fun logRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logRetentionPeriod = mapped
    }

    /**
     * @param value DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("wyruftxcbtyeheov")
    public suspend fun preferredBackupPeriods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupPeriods = mapped
    }

    /**
     * @param values DB Instance backup period. Please set at least two days to ensure backing up at least twice a week. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("avhmgtmwesnddtug")
    public suspend fun preferredBackupPeriods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredBackupPeriods = mapped
    }

    /**
     * @param value DB instance backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
     */
    @JvmName("ctlwxaqsokmdcrcg")
    public suspend fun preferredBackupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupTime = mapped
    }

    /**
     * @param value The policy based on which ApsaraDB RDS retains archived backup files if the instance is released. Default value: None. Valid values:
     * * **None**: No archived backup files are retained.
     * * **Lastest**: Only the most recent archived backup file is retained.
     * * **All**: All archived backup files are retained.
     */
    @JvmName("gijlojmhsvdppiyf")
    public suspend fun releasedKeepPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releasedKeepPolicy = mapped
    }

    /**
     * @param value It has been deprecated from version 1.69.0, and use field 'backup_retention_period' instead.
     */
    @Deprecated(
        message = """
  Attribute 'retention_period' has been deprecated from version 1.69.0. Use
      `backup_retention_period` instead
  """,
    )
    @JvmName("hxxcrelsmskqernd")
    public suspend fun retentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    internal fun build(): BackupPolicyArgs = BackupPolicyArgs(
        archiveBackupKeepCount = archiveBackupKeepCount,
        archiveBackupKeepPolicy = archiveBackupKeepPolicy,
        archiveBackupRetentionPeriod = archiveBackupRetentionPeriod,
        backupInterval = backupInterval,
        backupPeriods = backupPeriods,
        backupRetentionPeriod = backupRetentionPeriod,
        backupTime = backupTime,
        category = category,
        compressType = compressType,
        enableBackupLog = enableBackupLog,
        highSpaceUsageProtection = highSpaceUsageProtection,
        instanceId = instanceId,
        localLogRetentionHours = localLogRetentionHours,
        localLogRetentionSpace = localLogRetentionSpace,
        logBackup = logBackup,
        logBackupFrequency = logBackupFrequency,
        logBackupRetentionPeriod = logBackupRetentionPeriod,
        logRetentionPeriod = logRetentionPeriod,
        preferredBackupPeriods = preferredBackupPeriods,
        preferredBackupTime = preferredBackupTime,
        releasedKeepPolicy = releasedKeepPolicy,
        retentionPeriod = retentionPeriod,
    )
}
