@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.DdrInstanceArgs.builder
import com.pulumi.alicloud.rds.kotlin.inputs.DdrInstanceParameterArgs
import com.pulumi.alicloud.rds.kotlin.inputs.DdrInstanceParameterArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.DdrInstancePgHbaConfArgs
import com.pulumi.alicloud.rds.kotlin.inputs.DdrInstancePgHbaConfArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * RDS ddr instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/ddrInstance:DdrInstance example rm-abc12345678
 * ```
 * @property acl The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
 * - cert
 * - perfer
 * - verify-ca
 * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
 * @property autoRenew Whether to renewal a DB instance automatically or not. It is valid when payment_type is `Subscription`. Default to `false`.
 * @property autoRenewPeriod Auto-renewal period of an instance, in the unit of the month. It is valid when payment_type is `Subscription`. Valid value:[1~12], Default to 1.
 * @property autoUpgradeMinorVersion The upgrade method to use. Valid values:
 * - Auto: Instances are automatically upgraded to a higher minor version.
 * - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
 * See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
 * @property backupSetId The ID of the backup set that is used for the restoration. You can call the DescribeCrossRegionBackups operation to query the ID of the backup set.
 * @property caType The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
 * - aliyun: a cloud certificate
 * - custom: a custom certificate
 * @property clientCaCert The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
 * @property clientCaEnabled Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
 * - 1: enables the public key
 * - 0: disables the public key
 * @property clientCertRevocationList The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
 * @property clientCrlEnabled Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
 * - 1: enables the CRL
 * - 0: disables the CRL
 * @property connectionStringPrefix The private connection string prefix. If you want to update public connection string prefix, please use resource alicloud.rds.Connection connection_prefix.
 * > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\|{};:'",<>/?
 * @property dbInstanceIpArrayAttribute The attribute of the IP address whitelist. By default, this parameter is empty.
 * > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
 * @property dbInstanceIpArrayName The name of the IP address whitelist. Default value: Default.
 * > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
 * @property dbInstanceStorageType The storage type of the instance. Valid values:
 * - local_ssd: specifies to use local SSDs. This value is recommended.
 * - cloud_ssd: specifies to use standard SSDs.
 * - cloud_essd: specifies to use enhanced SSDs (ESSDs).
 * - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
 * - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
 * > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
 * @property deletionProtection The switch of delete protection. Valid values:
 * - true: delete protect.
 * - false: no delete protect.
 * > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
 * @property effectiveTime The method to update the engine version and change.  Default value: Immediate. Valid values:
 * - Immediate: The change immediately takes effect.
 * - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
 * @property encryptionKey The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
 * @property engine Database type. Value options: MySQL, SQLServer.
 * > **NOTE:** When the 'EngineVersion' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
 * @property engineVersion Database version. Value options can refer to the latest docs [CreateDdrInstance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/restore-data-to-a-new-instance-across-regions) `EngineVersion`.
 * @property forceRestart Set it to true to make some parameter efficient when modifying them. Default to false.
 * @property freshWhiteListReadins The read-only instances to which you want to synchronize the IP address whitelist.
 * * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
 * * If the instance is not attached with a read-only instance, this parameter is empty.
 * @property haConfig The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
 * - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
 * - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
 * > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
 * @property instanceName The name of DB instance. It a string of 2 to 256 characters.
 * @property instanceStorage The storage capacity of the destination instance. Valid values: 5 to 2000. Unit: GB.
 * This value must be a multiple of 5 GB. For more information, see Primary ApsaraDB RDS instance types.
 * @property instanceType DB Instance type.
 * > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value.
 * @property maintainTime Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
 * @property manualHaTime The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
 * > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
 * @property modifyMode The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
 * - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
 * - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
 * - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
 * @property monitoringPeriod The monitoring frequency in seconds. Valid values are 5, 60, 300. Defaults to 300.
 * @property parameters Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
 * @property paymentType Valid values are `Subscription`, `PayAsYouGo`, Default to `PayAsYouGo`.
 * @property period The duration that you will buy DB instance (in month). It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 * @property pgHbaConfs The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
 * @property port The private port of the database service. If you want to update public port, please use resource alicloud.rds.Connection port.
 * @property privateIpAddress The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
 * @property releasedKeepPolicy The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
 * - None: No archived backup files are retained.
 * - Lastest: Only the last archived backup file is retained.
 * - All: All the archived backup files are retained.
 * > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
 * @property replicationAcl The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
 * - cert
 * - perfer
 * - verify-ca
 * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
 * @property resourceGroupId The ID of resource group which the DB instance belongs.
 * @property restoreTime The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
 * @property restoreType The method that is used to restore data. Valid values:
 * - BackupSet: Data is restored from a backup set. If you use this value, you must also specify the BackupSetID parameter.
 * - BackupTime: restores data to a point in time. You must also specify the RestoreTime, SourceRegion, and SourceDBInstanceName parameters.
 * @property securityGroupIds ) The list IDs to join ECS Security Group. At most supports three security groups.
 * @property securityIpMode Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
 * @property securityIpType The type of IP address in the IP address whitelist.
 * @property securityIps List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
 * @property serverCert The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
 * @property serverKey The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
 * @property sourceDbInstanceName The ID of the source instance if you want to restore data to a point in time.
 * @property sourceRegion The region ID of the source instance if you want to restore data to a point in time.
 * @property sqlCollectorConfigValue The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
 * @property sqlCollectorStatus The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
 * @property sslAction Actions performed on SSL functions, Valid values: `Open`: turn on SSL encryption; `Close`: turn off SSL encryption; `Update`: update SSL certificate. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
 * @property storageAutoScale Automatic storage space expansion switch. Valid values:
 * - Enable
 * - Disable
 * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
 * @property storageThreshold The trigger threshold (percentage) for automatic storage space expansion. Valid values:
 * - 10
 * - 20
 * - 30
 * - 40
 * - 50
 * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
 * @property storageUpperBound The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
 * > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
 * @property switchTime The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
 * > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * @property targetMinorVersion The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
 * - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
 * - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
 * - rds: The instance runs RDS Basic or High-availability Edition.
 * - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
 * - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
 * - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
 * > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
 * @property tcpConnectionType The availability check method of the instance. Valid values:
 * - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
 * - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
 * @property tdeStatus The TDE(Transparent Data Encryption) status. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
 * @property upgradeDbInstanceKernelVersion Whether to upgrade a minor version of the kernel. Valid values:
 * - true: upgrade
 * - false: not to upgrade
 * @property upgradeTime The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
 * - Immediate: The minor engine version is immediately updated.
 * - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
 * - SpecifyTime: The minor engine version is updated at the point in time you specify.
 * @property vpcId The VPC ID of the instance.
 * > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
 * @property vswitchId The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
 * @property whitelistNetworkType The network type of the IP address whitelist. Default value: MIX. Valid values:
 * - Classic: classic network in enhanced whitelist mode
 * - VPC: virtual private cloud (VPC) in enhanced whitelist mode
 * - MIX: standard whitelist mode
 * > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
 * @property zoneId The Zone to launch the DB instance. It supports multiple zone.
 * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
 * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
 */
public data class DdrInstanceArgs(
    public val acl: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val autoUpgradeMinorVersion: Output<String>? = null,
    public val backupSetId: Output<String>? = null,
    public val caType: Output<String>? = null,
    public val clientCaCert: Output<String>? = null,
    public val clientCaEnabled: Output<Int>? = null,
    public val clientCertRevocationList: Output<String>? = null,
    public val clientCrlEnabled: Output<Int>? = null,
    public val connectionStringPrefix: Output<String>? = null,
    public val dbInstanceIpArrayAttribute: Output<String>? = null,
    public val dbInstanceIpArrayName: Output<String>? = null,
    public val dbInstanceStorageType: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val effectiveTime: Output<String>? = null,
    public val encryptionKey: Output<String>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val forceRestart: Output<Boolean>? = null,
    public val freshWhiteListReadins: Output<String>? = null,
    public val haConfig: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceStorage: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    public val maintainTime: Output<String>? = null,
    public val manualHaTime: Output<String>? = null,
    public val modifyMode: Output<String>? = null,
    public val monitoringPeriod: Output<Int>? = null,
    public val parameters: Output<List<DdrInstanceParameterArgs>>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val pgHbaConfs: Output<List<DdrInstancePgHbaConfArgs>>? = null,
    public val port: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val releasedKeepPolicy: Output<String>? = null,
    public val replicationAcl: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val restoreTime: Output<String>? = null,
    public val restoreType: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val securityIpMode: Output<String>? = null,
    public val securityIpType: Output<String>? = null,
    public val securityIps: Output<List<String>>? = null,
    public val serverCert: Output<String>? = null,
    public val serverKey: Output<String>? = null,
    public val sourceDbInstanceName: Output<String>? = null,
    public val sourceRegion: Output<String>? = null,
    public val sqlCollectorConfigValue: Output<Int>? = null,
    public val sqlCollectorStatus: Output<String>? = null,
    public val sslAction: Output<String>? = null,
    public val storageAutoScale: Output<String>? = null,
    public val storageThreshold: Output<Int>? = null,
    public val storageUpperBound: Output<Int>? = null,
    public val switchTime: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetMinorVersion: Output<String>? = null,
    public val tcpConnectionType: Output<String>? = null,
    public val tdeStatus: Output<String>? = null,
    public val upgradeDbInstanceKernelVersion: Output<Boolean>? = null,
    public val upgradeTime: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val whitelistNetworkType: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.DdrInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.DdrInstanceArgs =
        com.pulumi.alicloud.rds.DdrInstanceArgs.builder()
            .acl(acl?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .backupSetId(backupSetId?.applyValue({ args0 -> args0 }))
            .caType(caType?.applyValue({ args0 -> args0 }))
            .clientCaCert(clientCaCert?.applyValue({ args0 -> args0 }))
            .clientCaEnabled(clientCaEnabled?.applyValue({ args0 -> args0 }))
            .clientCertRevocationList(clientCertRevocationList?.applyValue({ args0 -> args0 }))
            .clientCrlEnabled(clientCrlEnabled?.applyValue({ args0 -> args0 }))
            .connectionStringPrefix(connectionStringPrefix?.applyValue({ args0 -> args0 }))
            .dbInstanceIpArrayAttribute(dbInstanceIpArrayAttribute?.applyValue({ args0 -> args0 }))
            .dbInstanceIpArrayName(dbInstanceIpArrayName?.applyValue({ args0 -> args0 }))
            .dbInstanceStorageType(dbInstanceStorageType?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .forceRestart(forceRestart?.applyValue({ args0 -> args0 }))
            .freshWhiteListReadins(freshWhiteListReadins?.applyValue({ args0 -> args0 }))
            .haConfig(haConfig?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceStorage(instanceStorage?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .maintainTime(maintainTime?.applyValue({ args0 -> args0 }))
            .manualHaTime(manualHaTime?.applyValue({ args0 -> args0 }))
            .modifyMode(modifyMode?.applyValue({ args0 -> args0 }))
            .monitoringPeriod(monitoringPeriod?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .pgHbaConfs(
                pgHbaConfs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .releasedKeepPolicy(releasedKeepPolicy?.applyValue({ args0 -> args0 }))
            .replicationAcl(replicationAcl?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .restoreTime(restoreTime?.applyValue({ args0 -> args0 }))
            .restoreType(restoreType?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityIpMode(securityIpMode?.applyValue({ args0 -> args0 }))
            .securityIpType(securityIpType?.applyValue({ args0 -> args0 }))
            .securityIps(securityIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serverCert(serverCert?.applyValue({ args0 -> args0 }))
            .serverKey(serverKey?.applyValue({ args0 -> args0 }))
            .sourceDbInstanceName(sourceDbInstanceName?.applyValue({ args0 -> args0 }))
            .sourceRegion(sourceRegion?.applyValue({ args0 -> args0 }))
            .sqlCollectorConfigValue(sqlCollectorConfigValue?.applyValue({ args0 -> args0 }))
            .sqlCollectorStatus(sqlCollectorStatus?.applyValue({ args0 -> args0 }))
            .sslAction(sslAction?.applyValue({ args0 -> args0 }))
            .storageAutoScale(storageAutoScale?.applyValue({ args0 -> args0 }))
            .storageThreshold(storageThreshold?.applyValue({ args0 -> args0 }))
            .storageUpperBound(storageUpperBound?.applyValue({ args0 -> args0 }))
            .switchTime(switchTime?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetMinorVersion(targetMinorVersion?.applyValue({ args0 -> args0 }))
            .tcpConnectionType(tcpConnectionType?.applyValue({ args0 -> args0 }))
            .tdeStatus(tdeStatus?.applyValue({ args0 -> args0 }))
            .upgradeDbInstanceKernelVersion(upgradeDbInstanceKernelVersion?.applyValue({ args0 -> args0 }))
            .upgradeTime(upgradeTime?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .whitelistNetworkType(whitelistNetworkType?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DdrInstanceArgs].
 */
@PulumiTagMarker
public class DdrInstanceArgsBuilder internal constructor() {
    private var acl: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var autoUpgradeMinorVersion: Output<String>? = null

    private var backupSetId: Output<String>? = null

    private var caType: Output<String>? = null

    private var clientCaCert: Output<String>? = null

    private var clientCaEnabled: Output<Int>? = null

    private var clientCertRevocationList: Output<String>? = null

    private var clientCrlEnabled: Output<Int>? = null

    private var connectionStringPrefix: Output<String>? = null

    private var dbInstanceIpArrayAttribute: Output<String>? = null

    private var dbInstanceIpArrayName: Output<String>? = null

    private var dbInstanceStorageType: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var effectiveTime: Output<String>? = null

    private var encryptionKey: Output<String>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var forceRestart: Output<Boolean>? = null

    private var freshWhiteListReadins: Output<String>? = null

    private var haConfig: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceStorage: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var maintainTime: Output<String>? = null

    private var manualHaTime: Output<String>? = null

    private var modifyMode: Output<String>? = null

    private var monitoringPeriod: Output<Int>? = null

    private var parameters: Output<List<DdrInstanceParameterArgs>>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var pgHbaConfs: Output<List<DdrInstancePgHbaConfArgs>>? = null

    private var port: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var releasedKeepPolicy: Output<String>? = null

    private var replicationAcl: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var restoreTime: Output<String>? = null

    private var restoreType: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var securityIpMode: Output<String>? = null

    private var securityIpType: Output<String>? = null

    private var securityIps: Output<List<String>>? = null

    private var serverCert: Output<String>? = null

    private var serverKey: Output<String>? = null

    private var sourceDbInstanceName: Output<String>? = null

    private var sourceRegion: Output<String>? = null

    private var sqlCollectorConfigValue: Output<Int>? = null

    private var sqlCollectorStatus: Output<String>? = null

    private var sslAction: Output<String>? = null

    private var storageAutoScale: Output<String>? = null

    private var storageThreshold: Output<Int>? = null

    private var storageUpperBound: Output<Int>? = null

    private var switchTime: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetMinorVersion: Output<String>? = null

    private var tcpConnectionType: Output<String>? = null

    private var tdeStatus: Output<String>? = null

    private var upgradeDbInstanceKernelVersion: Output<Boolean>? = null

    private var upgradeTime: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var whitelistNetworkType: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - cert
     * - perfer
     * - verify-ca
     * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
     */
    @JvmName("dwkqdeumohftrpsb")
    public suspend fun acl(`value`: Output<String>) {
        this.acl = value
    }

    /**
     * @param value Whether to renewal a DB instance automatically or not. It is valid when payment_type is `Subscription`. Default to `false`.
     */
    @JvmName("gtjdldgvuvdeukun")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Auto-renewal period of an instance, in the unit of the month. It is valid when payment_type is `Subscription`. Valid value:[1~12], Default to 1.
     */
    @JvmName("elohfgpnfcicutxc")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The upgrade method to use. Valid values:
     * - Auto: Instances are automatically upgraded to a higher minor version.
     * - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
     * See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
     */
    @JvmName("snesdfydcekusqbe")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<String>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value The ID of the backup set that is used for the restoration. You can call the DescribeCrossRegionBackups operation to query the ID of the backup set.
     */
    @JvmName("fcekovawktdkenmp")
    public suspend fun backupSetId(`value`: Output<String>) {
        this.backupSetId = value
    }

    /**
     * @param value The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
     * - aliyun: a cloud certificate
     * - custom: a custom certificate
     */
    @JvmName("qwsfqcwjfahcojqj")
    public suspend fun caType(`value`: Output<String>) {
        this.caType = value
    }

    /**
     * @param value The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
     */
    @JvmName("bvowhweovdjfywmn")
    public suspend fun clientCaCert(`value`: Output<String>) {
        this.clientCaCert = value
    }

    /**
     * @param value Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
     * - 1: enables the public key
     * - 0: disables the public key
     */
    @JvmName("ygkmcqsrpudreysr")
    public suspend fun clientCaEnabled(`value`: Output<Int>) {
        this.clientCaEnabled = value
    }

    /**
     * @param value The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
     */
    @JvmName("euehhkqiwhsixuka")
    public suspend fun clientCertRevocationList(`value`: Output<String>) {
        this.clientCertRevocationList = value
    }

    /**
     * @param value Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - 1: enables the CRL
     * - 0: disables the CRL
     */
    @JvmName("oyldmmbjumqmbfix")
    public suspend fun clientCrlEnabled(`value`: Output<Int>) {
        this.clientCrlEnabled = value
    }

    /**
     * @param value The private connection string prefix. If you want to update public connection string prefix, please use resource alicloud.rds.Connection connection_prefix.
     * > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\|{};:'",<>/?
     */
    @JvmName("ybbyqprgxgqkddwp")
    public suspend fun connectionStringPrefix(`value`: Output<String>) {
        this.connectionStringPrefix = value
    }

    /**
     * @param value The attribute of the IP address whitelist. By default, this parameter is empty.
     * > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
     */
    @JvmName("xlekcxxetauwccta")
    public suspend fun dbInstanceIpArrayAttribute(`value`: Output<String>) {
        this.dbInstanceIpArrayAttribute = value
    }

    /**
     * @param value The name of the IP address whitelist. Default value: Default.
     * > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
     */
    @JvmName("ofdwsifxwofwucdw")
    public suspend fun dbInstanceIpArrayName(`value`: Output<String>) {
        this.dbInstanceIpArrayName = value
    }

    /**
     * @param value The storage type of the instance. Valid values:
     * - local_ssd: specifies to use local SSDs. This value is recommended.
     * - cloud_ssd: specifies to use standard SSDs.
     * - cloud_essd: specifies to use enhanced SSDs (ESSDs).
     * - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
     * - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
     * > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
     */
    @JvmName("hdmuemrhpftsijpp")
    public suspend fun dbInstanceStorageType(`value`: Output<String>) {
        this.dbInstanceStorageType = value
    }

    /**
     * @param value The switch of delete protection. Valid values:
     * - true: delete protect.
     * - false: no delete protect.
     * > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
     */
    @JvmName("axndarjjhebwdxly")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value The method to update the engine version and change.  Default value: Immediate. Valid values:
     * - Immediate: The change immediately takes effect.
     * - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
     */
    @JvmName("vjisntegutvwebut")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
     */
    @JvmName("jfahtgmjbggqjqnr")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value Database type. Value options: MySQL, SQLServer.
     * > **NOTE:** When the 'EngineVersion' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
     */
    @JvmName("jqadmmbsgcmrnets")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value Database version. Value options can refer to the latest docs [CreateDdrInstance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/restore-data-to-a-new-instance-across-regions) `EngineVersion`.
     */
    @JvmName("fhbixaenbcfurafs")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Set it to true to make some parameter efficient when modifying them. Default to false.
     */
    @JvmName("ljrvocukdjqsvcak")
    public suspend fun forceRestart(`value`: Output<Boolean>) {
        this.forceRestart = value
    }

    /**
     * @param value The read-only instances to which you want to synchronize the IP address whitelist.
     * * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
     * * If the instance is not attached with a read-only instance, this parameter is empty.
     */
    @JvmName("ycbyyotprpjltghx")
    public suspend fun freshWhiteListReadins(`value`: Output<String>) {
        this.freshWhiteListReadins = value
    }

    /**
     * @param value The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
     * - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
     * - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
     * > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
     */
    @JvmName("hyqwuyjklnnprtmm")
    public suspend fun haConfig(`value`: Output<String>) {
        this.haConfig = value
    }

    /**
     * @param value The name of DB instance. It a string of 2 to 256 characters.
     */
    @JvmName("gjmbesskqtnynsja")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The storage capacity of the destination instance. Valid values: 5 to 2000. Unit: GB.
     * This value must be a multiple of 5 GB. For more information, see Primary ApsaraDB RDS instance types.
     */
    @JvmName("gumynstdmqcobuab")
    public suspend fun instanceStorage(`value`: Output<Int>) {
        this.instanceStorage = value
    }

    /**
     * @param value DB Instance type.
     * > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value.
     */
    @JvmName("ixyfsumddirrxsvr")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    @JvmName("jnylepcbfhjsseqf")
    public suspend fun maintainTime(`value`: Output<String>) {
        this.maintainTime = value
    }

    /**
     * @param value The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     * > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
     */
    @JvmName("qqjxyufpukaysgji")
    public suspend fun manualHaTime(`value`: Output<String>) {
        this.manualHaTime = value
    }

    /**
     * @param value The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
     * - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
     * - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
     * - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
     */
    @JvmName("amgpwqbxcmjsdqkg")
    public suspend fun modifyMode(`value`: Output<String>) {
        this.modifyMode = value
    }

    /**
     * @param value The monitoring frequency in seconds. Valid values are 5, 60, 300. Defaults to 300.
     */
    @JvmName("derymvmawfjwxarb")
    public suspend fun monitoringPeriod(`value`: Output<Int>) {
        this.monitoringPeriod = value
    }

    /**
     * @param value Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("rwfbtqedlvimeayo")
    public suspend fun parameters(`value`: Output<List<DdrInstanceParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("gsalljpxttmtoqil")
    public suspend fun parameters(vararg values: Output<DdrInstanceParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("jofswtkeypdacbbq")
    public suspend fun parameters(values: List<Output<DdrInstanceParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Valid values are `Subscription`, `PayAsYouGo`, Default to `PayAsYouGo`.
     */
    @JvmName("jpqtsithyjgnofcg")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration that you will buy DB instance (in month). It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("vwwpsrowecqfjjli")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("rlplnbtphppdusnx")
    public suspend fun pgHbaConfs(`value`: Output<List<DdrInstancePgHbaConfArgs>>) {
        this.pgHbaConfs = value
    }

    @JvmName("jouvqcigicgbxlvc")
    public suspend fun pgHbaConfs(vararg values: Output<DdrInstancePgHbaConfArgs>) {
        this.pgHbaConfs = Output.all(values.asList())
    }

    /**
     * @param values The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("wjafheivugpbsinl")
    public suspend fun pgHbaConfs(values: List<Output<DdrInstancePgHbaConfArgs>>) {
        this.pgHbaConfs = Output.all(values)
    }

    /**
     * @param value The private port of the database service. If you want to update public port, please use resource alicloud.rds.Connection port.
     */
    @JvmName("uiujatqnfnipksje")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
     */
    @JvmName("rgecdkglvfaskgji")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
     * - None: No archived backup files are retained.
     * - Lastest: Only the last archived backup file is retained.
     * - All: All the archived backup files are retained.
     * > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
     */
    @JvmName("jijxpklrfkkcgdhs")
    public suspend fun releasedKeepPolicy(`value`: Output<String>) {
        this.releasedKeepPolicy = value
    }

    /**
     * @param value The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - cert
     * - perfer
     * - verify-ca
     * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
     */
    @JvmName("kagsqxiwashdnqtt")
    public suspend fun replicationAcl(`value`: Output<String>) {
        this.replicationAcl = value
    }

    /**
     * @param value The ID of resource group which the DB instance belongs.
     */
    @JvmName("ugkbdfcitdbjnqec")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     */
    @JvmName("lbfmxalcxhxwsfuy")
    public suspend fun restoreTime(`value`: Output<String>) {
        this.restoreTime = value
    }

    /**
     * @param value The method that is used to restore data. Valid values:
     * - BackupSet: Data is restored from a backup set. If you use this value, you must also specify the BackupSetID parameter.
     * - BackupTime: restores data to a point in time. You must also specify the RestoreTime, SourceRegion, and SourceDBInstanceName parameters.
     */
    @JvmName("gyjceofrqqqbueha")
    public suspend fun restoreType(`value`: Output<String>) {
        this.restoreType = value
    }

    /**
     * @param value ) The list IDs to join ECS Security Group. At most supports three security groups.
     */
    @JvmName("uyqwglyxbrrhfrka")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("fjvaqgtfgqatxpqx")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values ) The list IDs to join ECS Security Group. At most supports three security groups.
     */
    @JvmName("lopjhygrpasubows")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
     */
    @JvmName("obfrmfalipmvvfhp")
    public suspend fun securityIpMode(`value`: Output<String>) {
        this.securityIpMode = value
    }

    /**
     * @param value The type of IP address in the IP address whitelist.
     */
    @JvmName("pefeuqbwuxjkcvro")
    public suspend fun securityIpType(`value`: Output<String>) {
        this.securityIpType = value
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("isgjhesoxjtrfprj")
    public suspend fun securityIps(`value`: Output<List<String>>) {
        this.securityIps = value
    }

    @JvmName("cqwpkujbyhaxcfcs")
    public suspend fun securityIps(vararg values: Output<String>) {
        this.securityIps = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("lmgbikxafvnfdbuk")
    public suspend fun securityIps(values: List<Output<String>>) {
        this.securityIps = Output.all(values)
    }

    /**
     * @param value The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
     */
    @JvmName("ypgsgngkerkyrmgw")
    public suspend fun serverCert(`value`: Output<String>) {
        this.serverCert = value
    }

    /**
     * @param value The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
     */
    @JvmName("blxctjablltvxkfy")
    public suspend fun serverKey(`value`: Output<String>) {
        this.serverKey = value
    }

    /**
     * @param value The ID of the source instance if you want to restore data to a point in time.
     */
    @JvmName("jckwmqalvjwesgpk")
    public suspend fun sourceDbInstanceName(`value`: Output<String>) {
        this.sourceDbInstanceName = value
    }

    /**
     * @param value The region ID of the source instance if you want to restore data to a point in time.
     */
    @JvmName("dtcsamnviwkatgpk")
    public suspend fun sourceRegion(`value`: Output<String>) {
        this.sourceRegion = value
    }

    /**
     * @param value The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
     */
    @JvmName("pjabeovhonhnouxl")
    public suspend fun sqlCollectorConfigValue(`value`: Output<Int>) {
        this.sqlCollectorConfigValue = value
    }

    /**
     * @param value The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
     */
    @JvmName("jfftnapymmndfpho")
    public suspend fun sqlCollectorStatus(`value`: Output<String>) {
        this.sqlCollectorStatus = value
    }

    /**
     * @param value Actions performed on SSL functions, Valid values: `Open`: turn on SSL encryption; `Close`: turn off SSL encryption; `Update`: update SSL certificate. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
     */
    @JvmName("dkdgyhhihbiahslw")
    public suspend fun sslAction(`value`: Output<String>) {
        this.sslAction = value
    }

    /**
     * @param value Automatic storage space expansion switch. Valid values:
     * - Enable
     * - Disable
     * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
     */
    @JvmName("ddyvqyttvvunsule")
    public suspend fun storageAutoScale(`value`: Output<String>) {
        this.storageAutoScale = value
    }

    /**
     * @param value The trigger threshold (percentage) for automatic storage space expansion. Valid values:
     * - 10
     * - 20
     * - 30
     * - 40
     * - 50
     * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
     */
    @JvmName("sifbdurldvfgwyuy")
    public suspend fun storageThreshold(`value`: Output<Int>) {
        this.storageThreshold = value
    }

    /**
     * @param value The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
     * > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
     */
    @JvmName("crvwilyrfvgkafpq")
    public suspend fun storageUpperBound(`value`: Output<Int>) {
        this.storageUpperBound = value
    }

    /**
     * @param value The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
     * > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
     */
    @JvmName("ldtwcygarndfspdh")
    public suspend fun switchTime(`value`: Output<String>) {
        this.switchTime = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("xpcvvqssktjcsoub")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
     * - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
     * - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
     * - rds: The instance runs RDS Basic or High-availability Edition.
     * - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
     * - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
     * - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
     * > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
     */
    @JvmName("eapxyrbgxewsenis")
    public suspend fun targetMinorVersion(`value`: Output<String>) {
        this.targetMinorVersion = value
    }

    /**
     * @param value The availability check method of the instance. Valid values:
     * - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
     * - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
     */
    @JvmName("ggvrohvklslyjujx")
    public suspend fun tcpConnectionType(`value`: Output<String>) {
        this.tcpConnectionType = value
    }

    /**
     * @param value The TDE(Transparent Data Encryption) status. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
     */
    @JvmName("kbgdxfywxeuxxjon")
    public suspend fun tdeStatus(`value`: Output<String>) {
        this.tdeStatus = value
    }

    /**
     * @param value Whether to upgrade a minor version of the kernel. Valid values:
     * - true: upgrade
     * - false: not to upgrade
     */
    @JvmName("gwqpukimnasgakvi")
    public suspend fun upgradeDbInstanceKernelVersion(`value`: Output<Boolean>) {
        this.upgradeDbInstanceKernelVersion = value
    }

    /**
     * @param value The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
     * - Immediate: The minor engine version is immediately updated.
     * - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
     * - SpecifyTime: The minor engine version is updated at the point in time you specify.
     */
    @JvmName("kfoloyproekbjvnb")
    public suspend fun upgradeTime(`value`: Output<String>) {
        this.upgradeTime = value
    }

    /**
     * @param value The VPC ID of the instance.
     * > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
     */
    @JvmName("gtahqkxmdviarlde")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
     */
    @JvmName("ggmjvtoovadtkdth")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The network type of the IP address whitelist. Default value: MIX. Valid values:
     * - Classic: classic network in enhanced whitelist mode
     * - VPC: virtual private cloud (VPC) in enhanced whitelist mode
     * - MIX: standard whitelist mode
     * > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
     */
    @JvmName("dbkxhacjmbphnfos")
    public suspend fun whitelistNetworkType(`value`: Output<String>) {
        this.whitelistNetworkType = value
    }

    /**
     * @param value The Zone to launch the DB instance. It supports multiple zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
     * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
     */
    @JvmName("duoshafdqmbamgum")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - cert
     * - perfer
     * - verify-ca
     * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
     */
    @JvmName("pyuussnpshkmtwub")
    public suspend fun acl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value Whether to renewal a DB instance automatically or not. It is valid when payment_type is `Subscription`. Default to `false`.
     */
    @JvmName("rxbtnnudghcupppg")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Auto-renewal period of an instance, in the unit of the month. It is valid when payment_type is `Subscription`. Valid value:[1~12], Default to 1.
     */
    @JvmName("lofosjupknsgicuw")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The upgrade method to use. Valid values:
     * - Auto: Instances are automatically upgraded to a higher minor version.
     * - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
     * See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
     */
    @JvmName("odyswgyehljkixlh")
    public suspend fun autoUpgradeMinorVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value The ID of the backup set that is used for the restoration. You can call the DescribeCrossRegionBackups operation to query the ID of the backup set.
     */
    @JvmName("ljrjdtkrmidqcnyg")
    public suspend fun backupSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSetId = mapped
    }

    /**
     * @param value The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
     * - aliyun: a cloud certificate
     * - custom: a custom certificate
     */
    @JvmName("dwfifbppcmqwxboy")
    public suspend fun caType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caType = mapped
    }

    /**
     * @param value The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
     */
    @JvmName("koiecudtwgdscmup")
    public suspend fun clientCaCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCaCert = mapped
    }

    /**
     * @param value Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
     * - 1: enables the public key
     * - 0: disables the public key
     */
    @JvmName("rcworrjalponhijb")
    public suspend fun clientCaEnabled(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCaEnabled = mapped
    }

    /**
     * @param value The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
     */
    @JvmName("mxkibfiijyfneecj")
    public suspend fun clientCertRevocationList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertRevocationList = mapped
    }

    /**
     * @param value Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - 1: enables the CRL
     * - 0: disables the CRL
     */
    @JvmName("eyhowjahhqrbqpqy")
    public suspend fun clientCrlEnabled(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCrlEnabled = mapped
    }

    /**
     * @param value The private connection string prefix. If you want to update public connection string prefix, please use resource alicloud.rds.Connection connection_prefix.
     * > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\|{};:'",<>/?
     */
    @JvmName("yjttweitperaaiyu")
    public suspend fun connectionStringPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStringPrefix = mapped
    }

    /**
     * @param value The attribute of the IP address whitelist. By default, this parameter is empty.
     * > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
     */
    @JvmName("rkawxbludxqesjge")
    public suspend fun dbInstanceIpArrayAttribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIpArrayAttribute = mapped
    }

    /**
     * @param value The name of the IP address whitelist. Default value: Default.
     * > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
     */
    @JvmName("plvkrvshumayqphb")
    public suspend fun dbInstanceIpArrayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIpArrayName = mapped
    }

    /**
     * @param value The storage type of the instance. Valid values:
     * - local_ssd: specifies to use local SSDs. This value is recommended.
     * - cloud_ssd: specifies to use standard SSDs.
     * - cloud_essd: specifies to use enhanced SSDs (ESSDs).
     * - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
     * - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
     * > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
     */
    @JvmName("ntkcfxrecoihyljp")
    public suspend fun dbInstanceStorageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceStorageType = mapped
    }

    /**
     * @param value The switch of delete protection. Valid values:
     * - true: delete protect.
     * - false: no delete protect.
     * > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
     */
    @JvmName("rpygxsibxslkcmda")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value The method to update the engine version and change.  Default value: Immediate. Valid values:
     * - Immediate: The change immediately takes effect.
     * - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
     */
    @JvmName("tidbeoheffrblhyk")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
     */
    @JvmName("eksebeabebxothlp")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value Database type. Value options: MySQL, SQLServer.
     * > **NOTE:** When the 'EngineVersion' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
     */
    @JvmName("qejrnaxdslgicnpi")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value Database version. Value options can refer to the latest docs [CreateDdrInstance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/restore-data-to-a-new-instance-across-regions) `EngineVersion`.
     */
    @JvmName("ehoqrbnacqdobvqj")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Set it to true to make some parameter efficient when modifying them. Default to false.
     */
    @JvmName("oudvjpqsvonfkykk")
    public suspend fun forceRestart(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceRestart = mapped
    }

    /**
     * @param value The read-only instances to which you want to synchronize the IP address whitelist.
     * * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
     * * If the instance is not attached with a read-only instance, this parameter is empty.
     */
    @JvmName("vvxdfqwrqabpgncm")
    public suspend fun freshWhiteListReadins(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.freshWhiteListReadins = mapped
    }

    /**
     * @param value The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
     * - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
     * - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
     * > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
     */
    @JvmName("xqwwuhyhxpvoovvb")
    public suspend fun haConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.haConfig = mapped
    }

    /**
     * @param value The name of DB instance. It a string of 2 to 256 characters.
     */
    @JvmName("ttgcodcgoccfogsw")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The storage capacity of the destination instance. Valid values: 5 to 2000. Unit: GB.
     * This value must be a multiple of 5 GB. For more information, see Primary ApsaraDB RDS instance types.
     */
    @JvmName("ntpuuacqhbuhysta")
    public suspend fun instanceStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceStorage = mapped
    }

    /**
     * @param value DB Instance type.
     * > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value.
     */
    @JvmName("hjnfgvyoeqmwqupg")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    @JvmName("gvlnhvxawngvxyit")
    public suspend fun maintainTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainTime = mapped
    }

    /**
     * @param value The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     * > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
     */
    @JvmName("rhhigvamviuonxvn")
    public suspend fun manualHaTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manualHaTime = mapped
    }

    /**
     * @param value The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
     * - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
     * - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
     * - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
     */
    @JvmName("dsjfpbjgaftnxysr")
    public suspend fun modifyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyMode = mapped
    }

    /**
     * @param value The monitoring frequency in seconds. Valid values are 5, 60, 300. Defaults to 300.
     */
    @JvmName("iepbbbjrplooccrm")
    public suspend fun monitoringPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringPeriod = mapped
    }

    /**
     * @param value Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("tmysisuupyrndacj")
    public suspend fun parameters(`value`: List<DdrInstanceParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("kkckbjxbskcnksmx")
    public suspend fun parameters(argument: List<suspend DdrInstanceParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DdrInstanceParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("cykptrwbpwcrtifh")
    public suspend fun parameters(vararg argument: suspend DdrInstanceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DdrInstanceParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("rbnundmpiqyaluis")
    public suspend fun parameters(argument: suspend DdrInstanceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DdrInstanceParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("wngkgeiupcvdhktj")
    public suspend fun parameters(vararg values: DdrInstanceParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Valid values are `Subscription`, `PayAsYouGo`, Default to `PayAsYouGo`.
     */
    @JvmName("gfjkguabmcyavlqp")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration that you will buy DB instance (in month). It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("incqmrmdqmwqiwke")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("cpgypbsnprqoalgr")
    public suspend fun pgHbaConfs(`value`: List<DdrInstancePgHbaConfArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pgHbaConfs = mapped
    }

    /**
     * @param argument The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("iwmcdktbiqvcdtde")
    public suspend fun pgHbaConfs(argument: List<suspend DdrInstancePgHbaConfArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DdrInstancePgHbaConfArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pgHbaConfs = mapped
    }

    /**
     * @param argument The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("bqdjhpkrgqkcsvsk")
    public suspend fun pgHbaConfs(vararg argument: suspend DdrInstancePgHbaConfArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DdrInstancePgHbaConfArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pgHbaConfs = mapped
    }

    /**
     * @param argument The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("qfrqbhwvsgmfeymp")
    public suspend fun pgHbaConfs(argument: suspend DdrInstancePgHbaConfArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DdrInstancePgHbaConfArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.pgHbaConfs = mapped
    }

    /**
     * @param values The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("emttyslfenfnodcm")
    public suspend fun pgHbaConfs(vararg values: DdrInstancePgHbaConfArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pgHbaConfs = mapped
    }

    /**
     * @param value The private port of the database service. If you want to update public port, please use resource alicloud.rds.Connection port.
     */
    @JvmName("qqeehwbmjrkodmpe")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
     */
    @JvmName("oohajpsjslgxfbmh")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
     * - None: No archived backup files are retained.
     * - Lastest: Only the last archived backup file is retained.
     * - All: All the archived backup files are retained.
     * > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
     */
    @JvmName("jwreagavhghyxccn")
    public suspend fun releasedKeepPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releasedKeepPolicy = mapped
    }

    /**
     * @param value The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - cert
     * - perfer
     * - verify-ca
     * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
     */
    @JvmName("mglvqytrlxxulvxu")
    public suspend fun replicationAcl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationAcl = mapped
    }

    /**
     * @param value The ID of resource group which the DB instance belongs.
     */
    @JvmName("jrmcmqajtgnifjbm")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     */
    @JvmName("fmmsfyvhtocxrhbo")
    public suspend fun restoreTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreTime = mapped
    }

    /**
     * @param value The method that is used to restore data. Valid values:
     * - BackupSet: Data is restored from a backup set. If you use this value, you must also specify the BackupSetID parameter.
     * - BackupTime: restores data to a point in time. You must also specify the RestoreTime, SourceRegion, and SourceDBInstanceName parameters.
     */
    @JvmName("dtvwgvilkrhqtfpy")
    public suspend fun restoreType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreType = mapped
    }

    /**
     * @param value ) The list IDs to join ECS Security Group. At most supports three security groups.
     */
    @JvmName("xpkbgbokabbevtuy")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values ) The list IDs to join ECS Security Group. At most supports three security groups.
     */
    @JvmName("qrgtoikqwtwwygnr")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
     */
    @JvmName("aariydwrumwwpuay")
    public suspend fun securityIpMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpMode = mapped
    }

    /**
     * @param value The type of IP address in the IP address whitelist.
     */
    @JvmName("teavifwltwafcpnt")
    public suspend fun securityIpType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpType = mapped
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("esjdubiekobxmlud")
    public suspend fun securityIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("imhdtnlqmuwyaapb")
    public suspend fun securityIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param value The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
     */
    @JvmName("erotstlrgvovmmcy")
    public suspend fun serverCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCert = mapped
    }

    /**
     * @param value The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
     */
    @JvmName("hqnvsmgtbwboakcs")
    public suspend fun serverKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverKey = mapped
    }

    /**
     * @param value The ID of the source instance if you want to restore data to a point in time.
     */
    @JvmName("ppwficmiqtxqntut")
    public suspend fun sourceDbInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbInstanceName = mapped
    }

    /**
     * @param value The region ID of the source instance if you want to restore data to a point in time.
     */
    @JvmName("pggfspyswlkpsivd")
    public suspend fun sourceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRegion = mapped
    }

    /**
     * @param value The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
     */
    @JvmName("wboemqadbtfvavjo")
    public suspend fun sqlCollectorConfigValue(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlCollectorConfigValue = mapped
    }

    /**
     * @param value The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
     */
    @JvmName("tlqhsdlulqhsppuf")
    public suspend fun sqlCollectorStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlCollectorStatus = mapped
    }

    /**
     * @param value Actions performed on SSL functions, Valid values: `Open`: turn on SSL encryption; `Close`: turn off SSL encryption; `Update`: update SSL certificate. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
     */
    @JvmName("ranwkxqnajmpjfhd")
    public suspend fun sslAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslAction = mapped
    }

    /**
     * @param value Automatic storage space expansion switch. Valid values:
     * - Enable
     * - Disable
     * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
     */
    @JvmName("liyheojgianqfybr")
    public suspend fun storageAutoScale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAutoScale = mapped
    }

    /**
     * @param value The trigger threshold (percentage) for automatic storage space expansion. Valid values:
     * - 10
     * - 20
     * - 30
     * - 40
     * - 50
     * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
     */
    @JvmName("yivdhyipcvrcygow")
    public suspend fun storageThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageThreshold = mapped
    }

    /**
     * @param value The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
     * > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
     */
    @JvmName("blueigngxnnokweg")
    public suspend fun storageUpperBound(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageUpperBound = mapped
    }

    /**
     * @param value The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
     * > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
     */
    @JvmName("oosvxlgshlppessk")
    public suspend fun switchTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.switchTime = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("yfopkwloyaocsucm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("oypborwykatxjuiw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
     * - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
     * - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
     * - rds: The instance runs RDS Basic or High-availability Edition.
     * - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
     * - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
     * - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
     * > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
     */
    @JvmName("jecglcdubwmiyrqs")
    public suspend fun targetMinorVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetMinorVersion = mapped
    }

    /**
     * @param value The availability check method of the instance. Valid values:
     * - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
     * - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
     */
    @JvmName("nkadkfknvybagygg")
    public suspend fun tcpConnectionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpConnectionType = mapped
    }

    /**
     * @param value The TDE(Transparent Data Encryption) status. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
     */
    @JvmName("mfkolqebppyutvwx")
    public suspend fun tdeStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tdeStatus = mapped
    }

    /**
     * @param value Whether to upgrade a minor version of the kernel. Valid values:
     * - true: upgrade
     * - false: not to upgrade
     */
    @JvmName("ktjunslyyhtgarxm")
    public suspend fun upgradeDbInstanceKernelVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeDbInstanceKernelVersion = mapped
    }

    /**
     * @param value The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
     * - Immediate: The minor engine version is immediately updated.
     * - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
     * - SpecifyTime: The minor engine version is updated at the point in time you specify.
     */
    @JvmName("lbnxwjbexrjlafad")
    public suspend fun upgradeTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeTime = mapped
    }

    /**
     * @param value The VPC ID of the instance.
     * > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
     */
    @JvmName("yyhblrupmobqxcwh")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
     */
    @JvmName("ytuhtgjouaiophce")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The network type of the IP address whitelist. Default value: MIX. Valid values:
     * - Classic: classic network in enhanced whitelist mode
     * - VPC: virtual private cloud (VPC) in enhanced whitelist mode
     * - MIX: standard whitelist mode
     * > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
     */
    @JvmName("hfgqaaojtvnvemwh")
    public suspend fun whitelistNetworkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.whitelistNetworkType = mapped
    }

    /**
     * @param value The Zone to launch the DB instance. It supports multiple zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
     * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
     */
    @JvmName("uhgrmwwborfdawhf")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DdrInstanceArgs = DdrInstanceArgs(
        acl = acl,
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        backupSetId = backupSetId,
        caType = caType,
        clientCaCert = clientCaCert,
        clientCaEnabled = clientCaEnabled,
        clientCertRevocationList = clientCertRevocationList,
        clientCrlEnabled = clientCrlEnabled,
        connectionStringPrefix = connectionStringPrefix,
        dbInstanceIpArrayAttribute = dbInstanceIpArrayAttribute,
        dbInstanceIpArrayName = dbInstanceIpArrayName,
        dbInstanceStorageType = dbInstanceStorageType,
        deletionProtection = deletionProtection,
        effectiveTime = effectiveTime,
        encryptionKey = encryptionKey,
        engine = engine,
        engineVersion = engineVersion,
        forceRestart = forceRestart,
        freshWhiteListReadins = freshWhiteListReadins,
        haConfig = haConfig,
        instanceName = instanceName,
        instanceStorage = instanceStorage,
        instanceType = instanceType,
        maintainTime = maintainTime,
        manualHaTime = manualHaTime,
        modifyMode = modifyMode,
        monitoringPeriod = monitoringPeriod,
        parameters = parameters,
        paymentType = paymentType,
        period = period,
        pgHbaConfs = pgHbaConfs,
        port = port,
        privateIpAddress = privateIpAddress,
        releasedKeepPolicy = releasedKeepPolicy,
        replicationAcl = replicationAcl,
        resourceGroupId = resourceGroupId,
        restoreTime = restoreTime,
        restoreType = restoreType,
        securityGroupIds = securityGroupIds,
        securityIpMode = securityIpMode,
        securityIpType = securityIpType,
        securityIps = securityIps,
        serverCert = serverCert,
        serverKey = serverKey,
        sourceDbInstanceName = sourceDbInstanceName,
        sourceRegion = sourceRegion,
        sqlCollectorConfigValue = sqlCollectorConfigValue,
        sqlCollectorStatus = sqlCollectorStatus,
        sslAction = sslAction,
        storageAutoScale = storageAutoScale,
        storageThreshold = storageThreshold,
        storageUpperBound = storageUpperBound,
        switchTime = switchTime,
        tags = tags,
        targetMinorVersion = targetMinorVersion,
        tcpConnectionType = tcpConnectionType,
        tdeStatus = tdeStatus,
        upgradeDbInstanceKernelVersion = upgradeDbInstanceKernelVersion,
        upgradeTime = upgradeTime,
        vpcId = vpcId,
        vswitchId = vswitchId,
        whitelistNetworkType = whitelistNetworkType,
        zoneId = zoneId,
    )
}
