@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.kotlin.outputs.InstanceBabelfishConfig
import com.pulumi.alicloud.rds.kotlin.outputs.InstanceParameter
import com.pulumi.alicloud.rds.kotlin.outputs.InstancePgHbaConf
import com.pulumi.alicloud.rds.kotlin.outputs.InstanceServerlessConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.rds.kotlin.outputs.InstanceBabelfishConfig.Companion.toKotlin as instanceBabelfishConfigToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.InstanceParameter.Companion.toKotlin as instanceParameterToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.InstancePgHbaConf.Companion.toKotlin as instancePgHbaConfToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.InstanceServerlessConfig.Companion.toKotlin as instanceServerlessConfigToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.rds.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * RDS instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/instance:Instance example rm-abc12345678
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.rds.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - cert
     * - perfer
     * - verify-ca
     * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
     */
    public val acl: Output<String>
        get() = javaResource.acl().applyValue({ args0 -> args0 })

    /**
     * Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The upgrade method to use. Valid values:
     * - Auto: Instances are automatically upgraded to a higher minor version.
     * - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
     * See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
     */
    public val autoUpgradeMinorVersion: Output<String>
        get() = javaResource.autoUpgradeMinorVersion().applyValue({ args0 -> args0 })

    /**
     * The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
     * > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    public val babelfishConfigs: Output<List<InstanceBabelfishConfig>>
        get() = javaResource.babelfishConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceBabelfishConfigToKotlin(args0) })
            })
        })

    /**
     * The TDS port of the instance for which Babelfish is enabled.
     * > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    public val babelfishPort: Output<String>
        get() = javaResource.babelfishPort().applyValue({ args0 -> args0 })

    /**
     * The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
     * - aliyun: a cloud certificate
     * - custom: a custom certificate
     */
    public val caType: Output<String>
        get() = javaResource.caType().applyValue({ args0 -> args0 })

    /**
     * The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
     * * **Basic**: Basic Edition.
     * * **HighAvailability**: High-availability Edition.
     * * **AlwaysOn**: Cluster Edition.
     * * **Finance**: Enterprise Edition.
     * * **cluster**: MySQL Cluster Edition. (Available since 1.202.0)
     * * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since 1.200.0)
     * * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since 1.204.0)
     * * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since 1.204.0)
     * > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
     */
    public val clientCaCert: Output<String>?
        get() = javaResource.clientCaCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
     * - 1: enables the public key
     * - 0: disables the public key
     */
    public val clientCaEnabled: Output<Int>?
        get() = javaResource.clientCaEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
     */
    public val clientCertRevocationList: Output<String>?
        get() = javaResource.clientCertRevocationList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - 1: enables the CRL
     * - 0: disables the CRL
     */
    public val clientCrlEnabled: Output<Int>?
        get() = javaResource.clientCrlEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * RDS database connection string.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * The private connection string prefix. If you want to update public connection string prefix, please use resource alicloud.rds.Connection connection_prefix.
     * > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\|{};:'",<>/?
     */
    public val connectionStringPrefix: Output<String>
        get() = javaResource.connectionStringPrefix().applyValue({ args0 -> args0 })

    /**
     * (Available since 1.204.1) The creation time of db instance.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The attribute of the IP address whitelist. By default, this parameter is empty.
     * > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
     */
    public val dbInstanceIpArrayAttribute: Output<String>?
        get() = javaResource.dbInstanceIpArrayAttribute().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the IP address whitelist. Default value: Default.
     * > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
     */
    public val dbInstanceIpArrayName: Output<String>?
        get() = javaResource.dbInstanceIpArrayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
     * - local_ssd: specifies to use local SSDs. This value is recommended.
     * - cloud_ssd: specifies to use standard SSDs.
     * - cloud_essd: specifies to use enhanced SSDs (ESSDs).
     * - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
     * - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
     * - general_essd: general essd.
     */
    public val dbInstanceStorageType: Output<String>
        get() = javaResource.dbInstanceStorageType().applyValue({ args0 -> args0 })

    /**
     * (Available since 1.197.0) The type of db instance.
     */
    public val dbInstanceType: Output<String>
        get() = javaResource.dbInstanceType().applyValue({ args0 -> args0 })

    /**
     * Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
     */
    public val dbIsIgnoreCase: Output<Boolean>
        get() = javaResource.dbIsIgnoreCase().applyValue({ args0 -> args0 })

    /**
     * Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
     */
    public val dbParamGroupId: Output<String>?
        get() = javaResource.dbParamGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
     * - If you set the `Engine` parameter to MySQL.
     * - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
     * - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
     * - If you set the `Engine` parameter to PostgreSQL.
     * - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
     * - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.
     * > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
     */
    public val dbTimeZone: Output<String>
        get() = javaResource.dbTimeZone().applyValue({ args0 -> args0 })

    /**
     * The switch of delete protection. Valid values:
     * - true: delete protect.
     * - false: no delete protect.
     * > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
     */
    public val direction: Output<String>?
        get() = javaResource.direction().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The method to update the engine version and change.  Default value: Immediate. Valid values:
     * - Immediate: The change immediately takes effect.
     * - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
     */
    public val effectiveTime: Output<String>?
        get() = javaResource.effectiveTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
     */
    public val encryptionKey: Output<String>?
        get() = javaResource.encryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
     * > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
     * - MySQL: [ 5&#46;5、5&#46;6、5&#46;7、8&#46;0 ]
     * - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
     * - PostgreSQL: [ 10&#46;0、11&#46;0、12&#46;0、13&#46;0、14&#46;0、15&#46;0 ]
     * - MariaDB: [ 10&#46;3 ]
     * - Serverless
     * > - MySQL: [ 5&#46;7、8&#46;0 ]
     * > - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
     * > - PostgreSQL: [ 14&#46;0 ]
     * > - MariaDB does not support creating serverless instances.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable forcible switching. Valid values:
     * - Yes
     * - No
     */
    public val force: Output<String>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Set it to true to make some parameter efficient when modifying them. Default to false.
     */
    public val forceRestart: Output<Boolean>?
        get() = javaResource.forceRestart().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The read-only instances to which you want to synchronize the IP address whitelist.
     * * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
     * * If the instance is not attached with a read-only instance, this parameter is empty.
     */
    public val freshWhiteListReadins: Output<String>?
        get() = javaResource.freshWhiteListReadins().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
     * - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
     * - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
     * > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
     */
    public val haConfig: Output<String>
        get() = javaResource.haConfig().applyValue({ args0 -> args0 })

    /**
     * Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
     */
    public val instanceChargeType: Output<String>?
        get() = javaResource.instanceChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of DB instance. It a string of 2 to 256 characters.
     */
    public val instanceName: Output<String>?
        get() = javaResource.instanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User-defined DB instance storage space. Value range:
     * - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
     * - [20,1000] for MySQL 5.7 basic single node edition;
     * - [10, 2000] for SQL Server 2008R2;
     * - [20,2000] for SQL Server 2012 basic single node edition
     * Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
     * Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
     */
    public val instanceStorage: Output<Int>
        get() = javaResource.instanceStorage().applyValue({ args0 -> args0 })

    /**
     * DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
     * - To create a serverless instance, please pass the following values:
     * - MySQL basic: mysql.n2.serverless.1c
     * - MySQL high availability: mysql.n2.serverless.2c
     * - SQLServer high availability: mssql.mem2.serverless.s2
     * - PostgreSQL basic: pg.n2.serverless.1c
     * > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    public val maintainTime: Output<String>
        get() = javaResource.maintainTime().applyValue({ args0 -> args0 })

    /**
     * The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     * > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
     */
    public val manualHaTime: Output<String>?
        get() = javaResource.manualHaTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
     * - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
     * - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
     * - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
     */
    public val modifyMode: Output<String>?
        get() = javaResource.modifyMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
     */
    public val monitoringPeriod: Output<Int>
        get() = javaResource.monitoringPeriod().applyValue({ args0 -> args0 })

    /**
     * The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
     */
    public val nodeId: Output<String>
        get() = javaResource.nodeId().applyValue({ args0 -> args0 })

    /**
     * Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    public val parameters: Output<List<InstanceParameter>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instanceParameterToKotlin(args0)
                })
            })
        })

    /**
     * The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    public val pgHbaConfs: Output<List<InstancePgHbaConf>>
        get() = javaResource.pgHbaConfs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instancePgHbaConfToKotlin(args0)
                })
            })
        })

    /**
     * The private port of the database service. If you want to update public port, please use resource alicloud.rds.Connection port.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
     */
    public val privateIpAddress: Output<String>
        get() = javaResource.privateIpAddress().applyValue({ args0 -> args0 })

    /**
     * The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
     * - None: No archived backup files are retained.
     * - Lastest: Only the last archived backup file is retained.
     * - All: All the archived backup files are retained.
     * > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
     */
    public val releasedKeepPolicy: Output<String>?
        get() = javaResource.releasedKeepPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - cert
     * - perfer
     * - verify-ca
     * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
     */
    public val replicationAcl: Output<String>
        get() = javaResource.replicationAcl().applyValue({ args0 -> args0 })

    /**
     * The ID of resource group which the DB instance belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The Alibaba Cloud Resource Name (ARN) of the RAM role.
     * > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
     * You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from 1.69.0 and use `security_group_ids` instead.
     */
    @Deprecated(
        message = """
  Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids`
      instead.
  """,
    )
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * , Available since 1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
     */
    public val securityIpMode: Output<String>?
        get() = javaResource.securityIpMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of IP address in the IP address whitelist.
     */
    public val securityIpType: Output<String>?
        get() = javaResource.securityIpType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    public val securityIps: Output<List<String>>
        get() = javaResource.securityIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
     */
    public val serverCert: Output<String>
        get() = javaResource.serverCert().applyValue({ args0 -> args0 })

    /**
     * The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
     */
    public val serverKey: Output<String>
        get() = javaResource.serverKey().applyValue({ args0 -> args0 })

    /**
     * The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
     */
    public val serverlessConfigs: Output<List<InstanceServerlessConfig>>?
        get() = javaResource.serverlessConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        instanceServerlessConfigToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
     */
    public val sqlCollectorConfigValue: Output<Int>?
        get() = javaResource.sqlCollectorConfigValue().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
     */
    public val sqlCollectorStatus: Output<String>
        get() = javaResource.sqlCollectorStatus().applyValue({ args0 -> args0 })

    /**
     * Actions performed on SSL functions. Valid values:
     * `Open`: turn on SSL encryption;
     * `Close`: turn off SSL encryption;
     * `Update`: update SSL certificate.
     * See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
     * > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
     */
    public val sslAction: Output<String>
        get() = javaResource.sslAction().applyValue({ args0 -> args0 })

    /**
     * The internal or public endpoint for which the server certificate needs to be created or updated.
     */
    public val sslConnectionString: Output<String>
        get() = javaResource.sslConnectionString().applyValue({ args0 -> args0 })

    /**
     * Status of the SSL feature. `Yes`: SSL is turned on; `No`: SSL is turned off.
     */
    public val sslStatus: Output<String>
        get() = javaResource.sslStatus().applyValue({ args0 -> args0 })

    /**
     * (Available since 1.204.1) The status of db instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Automatic storage space expansion switch. Valid values:
     * - Enable
     * - Disable
     * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
     */
    public val storageAutoScale: Output<String>?
        get() = javaResource.storageAutoScale().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
     * Valid values: [10, 20, 30, 40, 50].
     * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
     */
    public val storageThreshold: Output<Int>?
        get() = javaResource.storageThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
     * > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
     */
    public val storageUpperBound: Output<Int>?
        get() = javaResource.storageUpperBound().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.
     * > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
     */
    public val switchTime: Output<String>?
        get() = javaResource.switchTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
     * - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
     * - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
     * - rds: The instance runs RDS Basic or High-availability Edition.
     * - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
     * - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
     * - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
     * > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
     */
    public val targetMinorVersion: Output<String>
        get() = javaResource.targetMinorVersion().applyValue({ args0 -> args0 })

    /**
     * The availability check method of the instance. Valid values:
     * - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
     * - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
     */
    public val tcpConnectionType: Output<String>
        get() = javaResource.tcpConnectionType().applyValue({ args0 -> args0 })

    /**
     * The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
     */
    public val tdeStatus: Output<String>
        get() = javaResource.tdeStatus().applyValue({ args0 -> args0 })

    /**
     * Whether to upgrade a minor version of the kernel. Valid values:
     * - true: upgrade
     * - false: not to upgrade
     */
    @Deprecated(
        message = """
  Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use
      `target_minor_version` instead.
  """,
    )
    public val upgradeDbInstanceKernelVersion: Output<Boolean>?
        get() = javaResource.upgradeDbInstanceKernelVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
     * - Immediate: The minor engine version is immediately updated.
     * - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
     * - SpecifyTime: The minor engine version is updated at the point in time you specify.
     */
    public val upgradeTime: Output<String>?
        get() = javaResource.upgradeTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The VPC ID of the instance.
     * > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The network type of the IP address whitelist. Default value: MIX. Valid values:
     * - Classic: classic network in enhanced whitelist mode
     * - VPC: virtual private cloud (VPC) in enhanced whitelist mode
     * - MIX: standard whitelist mode
     * > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
     */
    public val whitelistNetworkType: Output<String>?
        get() = javaResource.whitelistNetworkType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
     * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })

    /**
     * The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
     */
    public val zoneIdSlaveA: Output<String>
        get() = javaResource.zoneIdSlaveA().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rds.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.rds.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
