@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.InstanceArgs.builder
import com.pulumi.alicloud.rds.kotlin.inputs.InstanceBabelfishConfigArgs
import com.pulumi.alicloud.rds.kotlin.inputs.InstanceBabelfishConfigArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.InstanceParameterArgs
import com.pulumi.alicloud.rds.kotlin.inputs.InstanceParameterArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.InstancePgHbaConfArgs
import com.pulumi.alicloud.rds.kotlin.inputs.InstancePgHbaConfArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.InstanceServerlessConfigArgs
import com.pulumi.alicloud.rds.kotlin.inputs.InstanceServerlessConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * RDS instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/instance:Instance example rm-abc12345678
 * ```
 * @property acl The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
 * - cert
 * - perfer
 * - verify-ca
 * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
 * @property autoRenew Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
 * @property autoRenewPeriod Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
 * @property autoUpgradeMinorVersion The upgrade method to use. Valid values:
 * - Auto: Instances are automatically upgraded to a higher minor version.
 * - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
 * See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
 * @property babelfishConfigs The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
 * > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
 * @property babelfishPort The TDS port of the instance for which Babelfish is enabled.
 * > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
 * @property caType The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
 * - aliyun: a cloud certificate
 * - custom: a custom certificate
 * @property category The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
 * * **Basic**: Basic Edition.
 * * **HighAvailability**: High-availability Edition.
 * * **AlwaysOn**: Cluster Edition.
 * * **Finance**: Enterprise Edition.
 * * **cluster**: MySQL Cluster Edition. (Available since 1.202.0)
 * * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since 1.200.0)
 * * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since 1.204.0)
 * * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since 1.204.0)
 * > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
 * @property clientCaCert The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
 * @property clientCaEnabled Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
 * - 1: enables the public key
 * - 0: disables the public key
 * @property clientCertRevocationList The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
 * @property clientCrlEnabled Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
 * - 1: enables the CRL
 * - 0: disables the CRL
 * @property connectionStringPrefix The private connection string prefix. If you want to update public connection string prefix, please use resource alicloud.rds.Connection connection_prefix.
 * > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\|{};:'",<>/?
 * @property dbInstanceIpArrayAttribute The attribute of the IP address whitelist. By default, this parameter is empty.
 * > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
 * @property dbInstanceIpArrayName The name of the IP address whitelist. Default value: Default.
 * > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
 * @property dbInstanceStorageType The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
 * - local_ssd: specifies to use local SSDs. This value is recommended.
 * - cloud_ssd: specifies to use standard SSDs.
 * - cloud_essd: specifies to use enhanced SSDs (ESSDs).
 * - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
 * - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
 * - general_essd: general essd.
 * @property dbIsIgnoreCase Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
 * @property dbParamGroupId Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
 * @property dbTimeZone The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
 * - If you set the `Engine` parameter to MySQL.
 * - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
 * - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
 * - If you set the `Engine` parameter to PostgreSQL.
 * - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
 * - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.
 * > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
 * @property deletionProtection The switch of delete protection. Valid values:
 * - true: delete protect.
 * - false: no delete protect.
 * > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
 * @property direction The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
 * @property effectiveTime The method to update the engine version and change.  Default value: Immediate. Valid values:
 * - Immediate: The change immediately takes effect.
 * - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
 * @property encryptionKey The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
 * @property engine Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
 * > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
 * @property engineVersion Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
 * - MySQL: [ 5&#46;5、5&#46;6、5&#46;7、8&#46;0 ]
 * - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
 * - PostgreSQL: [ 10&#46;0、11&#46;0、12&#46;0、13&#46;0、14&#46;0、15&#46;0 ]
 * - MariaDB: [ 10&#46;3 ]
 * - Serverless
 * > - MySQL: [ 5&#46;7、8&#46;0 ]
 * > - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
 * > - PostgreSQL: [ 14&#46;0 ]
 * > - MariaDB does not support creating serverless instances.
 * @property force Specifies whether to enable forcible switching. Valid values:
 * - Yes
 * - No
 * @property forceRestart Set it to true to make some parameter efficient when modifying them. Default to false.
 * @property freshWhiteListReadins The read-only instances to which you want to synchronize the IP address whitelist.
 * * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
 * * If the instance is not attached with a read-only instance, this parameter is empty.
 * @property haConfig The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
 * - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
 * - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
 * > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
 * @property instanceChargeType Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
 * @property instanceName The name of DB instance. It a string of 2 to 256 characters.
 * @property instanceStorage User-defined DB instance storage space. Value range:
 * - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
 * - [20,1000] for MySQL 5.7 basic single node edition;
 * - [10, 2000] for SQL Server 2008R2;
 * - [20,2000] for SQL Server 2012 basic single node edition
 * Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
 * Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
 * @property instanceType DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
 * - To create a serverless instance, please pass the following values:
 * - MySQL basic: mysql.n2.serverless.1c
 * - MySQL high availability: mysql.n2.serverless.2c
 * - SQLServer high availability: mssql.mem2.serverless.s2
 * - PostgreSQL basic: pg.n2.serverless.1c
 * > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
 * @property maintainTime Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
 * @property manualHaTime The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
 * > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
 * @property modifyMode The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
 * - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
 * - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
 * - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
 * @property monitoringPeriod The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
 * @property nodeId The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
 * @property parameters Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
 * @property period The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 * @property pgHbaConfs The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
 * @property port The private port of the database service. If you want to update public port, please use resource alicloud.rds.Connection port.
 * @property privateIpAddress The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
 * @property releasedKeepPolicy The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
 * - None: No archived backup files are retained.
 * - Lastest: Only the last archived backup file is retained.
 * - All: All the archived backup files are retained.
 * > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
 * @property replicationAcl The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
 * - cert
 * - perfer
 * - verify-ca
 * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
 * @property resourceGroupId The ID of resource group which the DB instance belongs.
 * @property roleArn The Alibaba Cloud Resource Name (ARN) of the RAM role.
 * > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
 * You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
 * @property securityGroupId It has been deprecated from 1.69.0 and use `security_group_ids` instead.
 * @property securityGroupIds , Available since 1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
 * @property securityIpMode Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
 * @property securityIpType The type of IP address in the IP address whitelist.
 * @property securityIps List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
 * @property serverCert The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
 * @property serverKey The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
 * @property serverlessConfigs The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
 * @property sqlCollectorConfigValue The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
 * @property sqlCollectorStatus The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
 * @property sslAction Actions performed on SSL functions. Valid values:
 * `Open`: turn on SSL encryption;
 * `Close`: turn off SSL encryption;
 * `Update`: update SSL certificate.
 * See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
 * > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
 * @property sslConnectionString The internal or public endpoint for which the server certificate needs to be created or updated.
 * @property storageAutoScale Automatic storage space expansion switch. Valid values:
 * - Enable
 * - Disable
 * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
 * @property storageThreshold The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
 * Valid values: [10, 20, 30, 40, 50].
 * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
 * @property storageUpperBound The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
 * > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
 * @property switchTime The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.
 * > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
 * @property targetMinorVersion The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
 * - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
 * - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
 * - rds: The instance runs RDS Basic or High-availability Edition.
 * - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
 * - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
 * - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
 * > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
 * @property tcpConnectionType The availability check method of the instance. Valid values:
 * - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
 * - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
 * @property tdeStatus The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
 * @property upgradeDbInstanceKernelVersion Whether to upgrade a minor version of the kernel. Valid values:
 * - true: upgrade
 * - false: not to upgrade
 * @property upgradeTime The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
 * - Immediate: The minor engine version is immediately updated.
 * - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
 * - SpecifyTime: The minor engine version is updated at the point in time you specify.
 * @property vpcId The VPC ID of the instance.
 * > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
 * @property vswitchId The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
 * @property whitelistNetworkType The network type of the IP address whitelist. Default value: MIX. Valid values:
 * - Classic: classic network in enhanced whitelist mode
 * - VPC: virtual private cloud (VPC) in enhanced whitelist mode
 * - MIX: standard whitelist mode
 * > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
 * @property zoneId The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
 * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
 * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
 * @property zoneIdSlaveA The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
 */
public data class InstanceArgs(
    public val acl: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val autoUpgradeMinorVersion: Output<String>? = null,
    public val babelfishConfigs: Output<List<InstanceBabelfishConfigArgs>>? = null,
    public val babelfishPort: Output<String>? = null,
    public val caType: Output<String>? = null,
    public val category: Output<String>? = null,
    public val clientCaCert: Output<String>? = null,
    public val clientCaEnabled: Output<Int>? = null,
    public val clientCertRevocationList: Output<String>? = null,
    public val clientCrlEnabled: Output<Int>? = null,
    public val connectionStringPrefix: Output<String>? = null,
    public val dbInstanceIpArrayAttribute: Output<String>? = null,
    public val dbInstanceIpArrayName: Output<String>? = null,
    public val dbInstanceStorageType: Output<String>? = null,
    public val dbIsIgnoreCase: Output<Boolean>? = null,
    public val dbParamGroupId: Output<String>? = null,
    public val dbTimeZone: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val direction: Output<String>? = null,
    public val effectiveTime: Output<String>? = null,
    public val encryptionKey: Output<String>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val force: Output<String>? = null,
    public val forceRestart: Output<Boolean>? = null,
    public val freshWhiteListReadins: Output<String>? = null,
    public val haConfig: Output<String>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceStorage: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    public val maintainTime: Output<String>? = null,
    public val manualHaTime: Output<String>? = null,
    public val modifyMode: Output<String>? = null,
    public val monitoringPeriod: Output<Int>? = null,
    public val nodeId: Output<String>? = null,
    public val parameters: Output<List<InstanceParameterArgs>>? = null,
    public val period: Output<Int>? = null,
    public val pgHbaConfs: Output<List<InstancePgHbaConfArgs>>? = null,
    public val port: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val releasedKeepPolicy: Output<String>? = null,
    public val replicationAcl: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    @Deprecated(
        message = """
  Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids`
      instead.
  """,
    )
    public val securityGroupId: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val securityIpMode: Output<String>? = null,
    public val securityIpType: Output<String>? = null,
    public val securityIps: Output<List<String>>? = null,
    public val serverCert: Output<String>? = null,
    public val serverKey: Output<String>? = null,
    public val serverlessConfigs: Output<List<InstanceServerlessConfigArgs>>? = null,
    public val sqlCollectorConfigValue: Output<Int>? = null,
    public val sqlCollectorStatus: Output<String>? = null,
    public val sslAction: Output<String>? = null,
    public val sslConnectionString: Output<String>? = null,
    public val storageAutoScale: Output<String>? = null,
    public val storageThreshold: Output<Int>? = null,
    public val storageUpperBound: Output<Int>? = null,
    public val switchTime: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetMinorVersion: Output<String>? = null,
    public val tcpConnectionType: Output<String>? = null,
    public val tdeStatus: Output<String>? = null,
    @Deprecated(
        message = """
  Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use
      `target_minor_version` instead.
  """,
    )
    public val upgradeDbInstanceKernelVersion: Output<Boolean>? = null,
    public val upgradeTime: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val whitelistNetworkType: Output<String>? = null,
    public val zoneId: Output<String>? = null,
    public val zoneIdSlaveA: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.InstanceArgs =
        com.pulumi.alicloud.rds.InstanceArgs.builder()
            .acl(acl?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .babelfishConfigs(
                babelfishConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .babelfishPort(babelfishPort?.applyValue({ args0 -> args0 }))
            .caType(caType?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .clientCaCert(clientCaCert?.applyValue({ args0 -> args0 }))
            .clientCaEnabled(clientCaEnabled?.applyValue({ args0 -> args0 }))
            .clientCertRevocationList(clientCertRevocationList?.applyValue({ args0 -> args0 }))
            .clientCrlEnabled(clientCrlEnabled?.applyValue({ args0 -> args0 }))
            .connectionStringPrefix(connectionStringPrefix?.applyValue({ args0 -> args0 }))
            .dbInstanceIpArrayAttribute(dbInstanceIpArrayAttribute?.applyValue({ args0 -> args0 }))
            .dbInstanceIpArrayName(dbInstanceIpArrayName?.applyValue({ args0 -> args0 }))
            .dbInstanceStorageType(dbInstanceStorageType?.applyValue({ args0 -> args0 }))
            .dbIsIgnoreCase(dbIsIgnoreCase?.applyValue({ args0 -> args0 }))
            .dbParamGroupId(dbParamGroupId?.applyValue({ args0 -> args0 }))
            .dbTimeZone(dbTimeZone?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .direction(direction?.applyValue({ args0 -> args0 }))
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .forceRestart(forceRestart?.applyValue({ args0 -> args0 }))
            .freshWhiteListReadins(freshWhiteListReadins?.applyValue({ args0 -> args0 }))
            .haConfig(haConfig?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceStorage(instanceStorage?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .maintainTime(maintainTime?.applyValue({ args0 -> args0 }))
            .manualHaTime(manualHaTime?.applyValue({ args0 -> args0 }))
            .modifyMode(modifyMode?.applyValue({ args0 -> args0 }))
            .monitoringPeriod(monitoringPeriod?.applyValue({ args0 -> args0 }))
            .nodeId(nodeId?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .period(period?.applyValue({ args0 -> args0 }))
            .pgHbaConfs(
                pgHbaConfs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .releasedKeepPolicy(releasedKeepPolicy?.applyValue({ args0 -> args0 }))
            .replicationAcl(replicationAcl?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityIpMode(securityIpMode?.applyValue({ args0 -> args0 }))
            .securityIpType(securityIpType?.applyValue({ args0 -> args0 }))
            .securityIps(securityIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serverCert(serverCert?.applyValue({ args0 -> args0 }))
            .serverKey(serverKey?.applyValue({ args0 -> args0 }))
            .serverlessConfigs(
                serverlessConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sqlCollectorConfigValue(sqlCollectorConfigValue?.applyValue({ args0 -> args0 }))
            .sqlCollectorStatus(sqlCollectorStatus?.applyValue({ args0 -> args0 }))
            .sslAction(sslAction?.applyValue({ args0 -> args0 }))
            .sslConnectionString(sslConnectionString?.applyValue({ args0 -> args0 }))
            .storageAutoScale(storageAutoScale?.applyValue({ args0 -> args0 }))
            .storageThreshold(storageThreshold?.applyValue({ args0 -> args0 }))
            .storageUpperBound(storageUpperBound?.applyValue({ args0 -> args0 }))
            .switchTime(switchTime?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetMinorVersion(targetMinorVersion?.applyValue({ args0 -> args0 }))
            .tcpConnectionType(tcpConnectionType?.applyValue({ args0 -> args0 }))
            .tdeStatus(tdeStatus?.applyValue({ args0 -> args0 }))
            .upgradeDbInstanceKernelVersion(upgradeDbInstanceKernelVersion?.applyValue({ args0 -> args0 }))
            .upgradeTime(upgradeTime?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .whitelistNetworkType(whitelistNetworkType?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 }))
            .zoneIdSlaveA(zoneIdSlaveA?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var acl: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var autoUpgradeMinorVersion: Output<String>? = null

    private var babelfishConfigs: Output<List<InstanceBabelfishConfigArgs>>? = null

    private var babelfishPort: Output<String>? = null

    private var caType: Output<String>? = null

    private var category: Output<String>? = null

    private var clientCaCert: Output<String>? = null

    private var clientCaEnabled: Output<Int>? = null

    private var clientCertRevocationList: Output<String>? = null

    private var clientCrlEnabled: Output<Int>? = null

    private var connectionStringPrefix: Output<String>? = null

    private var dbInstanceIpArrayAttribute: Output<String>? = null

    private var dbInstanceIpArrayName: Output<String>? = null

    private var dbInstanceStorageType: Output<String>? = null

    private var dbIsIgnoreCase: Output<Boolean>? = null

    private var dbParamGroupId: Output<String>? = null

    private var dbTimeZone: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var direction: Output<String>? = null

    private var effectiveTime: Output<String>? = null

    private var encryptionKey: Output<String>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var force: Output<String>? = null

    private var forceRestart: Output<Boolean>? = null

    private var freshWhiteListReadins: Output<String>? = null

    private var haConfig: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceStorage: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var maintainTime: Output<String>? = null

    private var manualHaTime: Output<String>? = null

    private var modifyMode: Output<String>? = null

    private var monitoringPeriod: Output<Int>? = null

    private var nodeId: Output<String>? = null

    private var parameters: Output<List<InstanceParameterArgs>>? = null

    private var period: Output<Int>? = null

    private var pgHbaConfs: Output<List<InstancePgHbaConfArgs>>? = null

    private var port: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var releasedKeepPolicy: Output<String>? = null

    private var replicationAcl: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var securityIpMode: Output<String>? = null

    private var securityIpType: Output<String>? = null

    private var securityIps: Output<List<String>>? = null

    private var serverCert: Output<String>? = null

    private var serverKey: Output<String>? = null

    private var serverlessConfigs: Output<List<InstanceServerlessConfigArgs>>? = null

    private var sqlCollectorConfigValue: Output<Int>? = null

    private var sqlCollectorStatus: Output<String>? = null

    private var sslAction: Output<String>? = null

    private var sslConnectionString: Output<String>? = null

    private var storageAutoScale: Output<String>? = null

    private var storageThreshold: Output<Int>? = null

    private var storageUpperBound: Output<Int>? = null

    private var switchTime: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetMinorVersion: Output<String>? = null

    private var tcpConnectionType: Output<String>? = null

    private var tdeStatus: Output<String>? = null

    private var upgradeDbInstanceKernelVersion: Output<Boolean>? = null

    private var upgradeTime: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var whitelistNetworkType: Output<String>? = null

    private var zoneId: Output<String>? = null

    private var zoneIdSlaveA: Output<String>? = null

    /**
     * @param value The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - cert
     * - perfer
     * - verify-ca
     * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
     */
    @JvmName("nepivxrpworqfxft")
    public suspend fun acl(`value`: Output<String>) {
        this.acl = value
    }

    /**
     * @param value Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
     */
    @JvmName("riicpphmeftwmoow")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
     */
    @JvmName("phyetkfwjrfdxrvd")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The upgrade method to use. Valid values:
     * - Auto: Instances are automatically upgraded to a higher minor version.
     * - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
     * See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
     */
    @JvmName("inyvghcqcjplqdbc")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<String>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
     * > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    @JvmName("ythlwkuuoaqvjsgj")
    public suspend fun babelfishConfigs(`value`: Output<List<InstanceBabelfishConfigArgs>>) {
        this.babelfishConfigs = value
    }

    @JvmName("ewffysqfsyhasqpr")
    public suspend fun babelfishConfigs(vararg values: Output<InstanceBabelfishConfigArgs>) {
        this.babelfishConfigs = Output.all(values.asList())
    }

    /**
     * @param values The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
     * > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    @JvmName("vxftwesjxhmryouo")
    public suspend fun babelfishConfigs(values: List<Output<InstanceBabelfishConfigArgs>>) {
        this.babelfishConfigs = Output.all(values)
    }

    /**
     * @param value The TDS port of the instance for which Babelfish is enabled.
     * > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    @JvmName("jtgcgrmdgsusfhus")
    public suspend fun babelfishPort(`value`: Output<String>) {
        this.babelfishPort = value
    }

    /**
     * @param value The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
     * - aliyun: a cloud certificate
     * - custom: a custom certificate
     */
    @JvmName("akwborivdwxjqrwn")
    public suspend fun caType(`value`: Output<String>) {
        this.caType = value
    }

    /**
     * @param value The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
     * * **Basic**: Basic Edition.
     * * **HighAvailability**: High-availability Edition.
     * * **AlwaysOn**: Cluster Edition.
     * * **Finance**: Enterprise Edition.
     * * **cluster**: MySQL Cluster Edition. (Available since 1.202.0)
     * * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since 1.200.0)
     * * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since 1.204.0)
     * * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since 1.204.0)
     * > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
     */
    @JvmName("pfbeqeihsorvkxgy")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
     */
    @JvmName("wlhwfxjcboyvamva")
    public suspend fun clientCaCert(`value`: Output<String>) {
        this.clientCaCert = value
    }

    /**
     * @param value Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
     * - 1: enables the public key
     * - 0: disables the public key
     */
    @JvmName("eauhjcagnihwvjmo")
    public suspend fun clientCaEnabled(`value`: Output<Int>) {
        this.clientCaEnabled = value
    }

    /**
     * @param value The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
     */
    @JvmName("achbktnfoxfmjxwk")
    public suspend fun clientCertRevocationList(`value`: Output<String>) {
        this.clientCertRevocationList = value
    }

    /**
     * @param value Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - 1: enables the CRL
     * - 0: disables the CRL
     */
    @JvmName("vwwwkrugrhxoehfr")
    public suspend fun clientCrlEnabled(`value`: Output<Int>) {
        this.clientCrlEnabled = value
    }

    /**
     * @param value The private connection string prefix. If you want to update public connection string prefix, please use resource alicloud.rds.Connection connection_prefix.
     * > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\|{};:'",<>/?
     */
    @JvmName("teckqfqxuqiqihcw")
    public suspend fun connectionStringPrefix(`value`: Output<String>) {
        this.connectionStringPrefix = value
    }

    /**
     * @param value The attribute of the IP address whitelist. By default, this parameter is empty.
     * > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
     */
    @JvmName("rtcdbgghebyrtark")
    public suspend fun dbInstanceIpArrayAttribute(`value`: Output<String>) {
        this.dbInstanceIpArrayAttribute = value
    }

    /**
     * @param value The name of the IP address whitelist. Default value: Default.
     * > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
     */
    @JvmName("xsuepjtpxdmjwflg")
    public suspend fun dbInstanceIpArrayName(`value`: Output<String>) {
        this.dbInstanceIpArrayName = value
    }

    /**
     * @param value The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
     * - local_ssd: specifies to use local SSDs. This value is recommended.
     * - cloud_ssd: specifies to use standard SSDs.
     * - cloud_essd: specifies to use enhanced SSDs (ESSDs).
     * - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
     * - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
     * - general_essd: general essd.
     */
    @JvmName("wdvprqvfhglgsbsp")
    public suspend fun dbInstanceStorageType(`value`: Output<String>) {
        this.dbInstanceStorageType = value
    }

    /**
     * @param value Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
     */
    @JvmName("bguaffnfbyhxanuw")
    public suspend fun dbIsIgnoreCase(`value`: Output<Boolean>) {
        this.dbIsIgnoreCase = value
    }

    /**
     * @param value Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
     */
    @JvmName("gwvheoeqmbxwwcdm")
    public suspend fun dbParamGroupId(`value`: Output<String>) {
        this.dbParamGroupId = value
    }

    /**
     * @param value The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
     * - If you set the `Engine` parameter to MySQL.
     * - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
     * - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
     * - If you set the `Engine` parameter to PostgreSQL.
     * - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
     * - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.
     * > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
     */
    @JvmName("waaxjqrjvufbeoxp")
    public suspend fun dbTimeZone(`value`: Output<String>) {
        this.dbTimeZone = value
    }

    /**
     * @param value The switch of delete protection. Valid values:
     * - true: delete protect.
     * - false: no delete protect.
     * > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
     */
    @JvmName("prxtnmfyxgjfpffs")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
     */
    @JvmName("yhrtffvksiymskgw")
    public suspend fun direction(`value`: Output<String>) {
        this.direction = value
    }

    /**
     * @param value The method to update the engine version and change.  Default value: Immediate. Valid values:
     * - Immediate: The change immediately takes effect.
     * - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
     */
    @JvmName("msnamaecqijxjebt")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
     */
    @JvmName("gbepbmckxpjuykaw")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
     * > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
     */
    @JvmName("nrprqqwowpefvjpl")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
     * - MySQL: [ 5&#46;5、5&#46;6、5&#46;7、8&#46;0 ]
     * - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
     * - PostgreSQL: [ 10&#46;0、11&#46;0、12&#46;0、13&#46;0、14&#46;0、15&#46;0 ]
     * - MariaDB: [ 10&#46;3 ]
     * - Serverless
     * > - MySQL: [ 5&#46;7、8&#46;0 ]
     * > - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
     * > - PostgreSQL: [ 14&#46;0 ]
     * > - MariaDB does not support creating serverless instances.
     */
    @JvmName("vrvajhywxopbyrqf")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Specifies whether to enable forcible switching. Valid values:
     * - Yes
     * - No
     */
    @JvmName("dpftmnwpcgdgqtco")
    public suspend fun force(`value`: Output<String>) {
        this.force = value
    }

    /**
     * @param value Set it to true to make some parameter efficient when modifying them. Default to false.
     */
    @JvmName("ipqxeogibfuawcna")
    public suspend fun forceRestart(`value`: Output<Boolean>) {
        this.forceRestart = value
    }

    /**
     * @param value The read-only instances to which you want to synchronize the IP address whitelist.
     * * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
     * * If the instance is not attached with a read-only instance, this parameter is empty.
     */
    @JvmName("mrcgjxvfyvguxblc")
    public suspend fun freshWhiteListReadins(`value`: Output<String>) {
        this.freshWhiteListReadins = value
    }

    /**
     * @param value The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
     * - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
     * - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
     * > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
     */
    @JvmName("napjafoucebelrtq")
    public suspend fun haConfig(`value`: Output<String>) {
        this.haConfig = value
    }

    /**
     * @param value Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
     */
    @JvmName("xgpskbgiutltcqpu")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value The name of DB instance. It a string of 2 to 256 characters.
     */
    @JvmName("crexgsutelgvvdmh")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value User-defined DB instance storage space. Value range:
     * - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
     * - [20,1000] for MySQL 5.7 basic single node edition;
     * - [10, 2000] for SQL Server 2008R2;
     * - [20,2000] for SQL Server 2012 basic single node edition
     * Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
     * Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
     */
    @JvmName("ebfgjgmnxxfxpwcj")
    public suspend fun instanceStorage(`value`: Output<Int>) {
        this.instanceStorage = value
    }

    /**
     * @param value DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
     * - To create a serverless instance, please pass the following values:
     * - MySQL basic: mysql.n2.serverless.1c
     * - MySQL high availability: mysql.n2.serverless.2c
     * - SQLServer high availability: mssql.mem2.serverless.s2
     * - PostgreSQL basic: pg.n2.serverless.1c
     * > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
     */
    @JvmName("bvdacrpdnicrxuqm")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    @JvmName("pywweffowjetbxaq")
    public suspend fun maintainTime(`value`: Output<String>) {
        this.maintainTime = value
    }

    /**
     * @param value The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     * > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
     */
    @JvmName("gbychrtpdagblqfs")
    public suspend fun manualHaTime(`value`: Output<String>) {
        this.manualHaTime = value
    }

    /**
     * @param value The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
     * - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
     * - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
     * - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
     */
    @JvmName("iijvhrbseppplyqx")
    public suspend fun modifyMode(`value`: Output<String>) {
        this.modifyMode = value
    }

    /**
     * @param value The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
     */
    @JvmName("mcffuqqugexdyrww")
    public suspend fun monitoringPeriod(`value`: Output<Int>) {
        this.monitoringPeriod = value
    }

    /**
     * @param value The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
     */
    @JvmName("ddvvgsagfuydlqls")
    public suspend fun nodeId(`value`: Output<String>) {
        this.nodeId = value
    }

    /**
     * @param value Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("ukksnibedgnbmtkg")
    public suspend fun parameters(`value`: Output<List<InstanceParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("myiagmerslqmaadn")
    public suspend fun parameters(vararg values: Output<InstanceParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("xdmxauvdgdudpump")
    public suspend fun parameters(values: List<Output<InstanceParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("brunjcusfblgqdex")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("gwhqiybqedjblvle")
    public suspend fun pgHbaConfs(`value`: Output<List<InstancePgHbaConfArgs>>) {
        this.pgHbaConfs = value
    }

    @JvmName("vhnaqkyksijwdemb")
    public suspend fun pgHbaConfs(vararg values: Output<InstancePgHbaConfArgs>) {
        this.pgHbaConfs = Output.all(values.asList())
    }

    /**
     * @param values The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("rcfbyfsgkkdotmly")
    public suspend fun pgHbaConfs(values: List<Output<InstancePgHbaConfArgs>>) {
        this.pgHbaConfs = Output.all(values)
    }

    /**
     * @param value The private port of the database service. If you want to update public port, please use resource alicloud.rds.Connection port.
     */
    @JvmName("iogyilgseufkirkj")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
     */
    @JvmName("lyxtfbbniblaxdyi")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
     * - None: No archived backup files are retained.
     * - Lastest: Only the last archived backup file is retained.
     * - All: All the archived backup files are retained.
     * > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
     */
    @JvmName("vopblkjurjfntnys")
    public suspend fun releasedKeepPolicy(`value`: Output<String>) {
        this.releasedKeepPolicy = value
    }

    /**
     * @param value The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - cert
     * - perfer
     * - verify-ca
     * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
     */
    @JvmName("hgmfbngslctjxojb")
    public suspend fun replicationAcl(`value`: Output<String>) {
        this.replicationAcl = value
    }

    /**
     * @param value The ID of resource group which the DB instance belongs.
     */
    @JvmName("cqbaajqcenjklyeg")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the RAM role.
     * > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
     * You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
     */
    @JvmName("yahinicytxdpdsil")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value It has been deprecated from 1.69.0 and use `security_group_ids` instead.
     */
    @Deprecated(
        message = """
  Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids`
      instead.
  """,
    )
    @JvmName("ldwnrpjjiwxyvqrf")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value , Available since 1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
     */
    @JvmName("thvxngdupcxjdmdb")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("qsodcehsjyxmitcr")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values , Available since 1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
     */
    @JvmName("mchdbslycbhkmona")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
     */
    @JvmName("kvynmojwqnckatix")
    public suspend fun securityIpMode(`value`: Output<String>) {
        this.securityIpMode = value
    }

    /**
     * @param value The type of IP address in the IP address whitelist.
     */
    @JvmName("aoortbjwxahnlfmn")
    public suspend fun securityIpType(`value`: Output<String>) {
        this.securityIpType = value
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("ohefmcuclqoncgdx")
    public suspend fun securityIps(`value`: Output<List<String>>) {
        this.securityIps = value
    }

    @JvmName("cvwmarfccosrcyyc")
    public suspend fun securityIps(vararg values: Output<String>) {
        this.securityIps = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("nnaokmssclqmcttw")
    public suspend fun securityIps(values: List<Output<String>>) {
        this.securityIps = Output.all(values)
    }

    /**
     * @param value The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
     */
    @JvmName("tkuevpxmcepoiocu")
    public suspend fun serverCert(`value`: Output<String>) {
        this.serverCert = value
    }

    /**
     * @param value The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
     */
    @JvmName("avrvfpjncbccflxx")
    public suspend fun serverKey(`value`: Output<String>) {
        this.serverKey = value
    }

    /**
     * @param value The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
     */
    @JvmName("ejmdiwjhbtttdafy")
    public suspend fun serverlessConfigs(`value`: Output<List<InstanceServerlessConfigArgs>>) {
        this.serverlessConfigs = value
    }

    @JvmName("hwlgpvwnrlqkibwo")
    public suspend fun serverlessConfigs(vararg values: Output<InstanceServerlessConfigArgs>) {
        this.serverlessConfigs = Output.all(values.asList())
    }

    /**
     * @param values The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
     */
    @JvmName("npyrfsfmmycvfqsj")
    public suspend fun serverlessConfigs(values: List<Output<InstanceServerlessConfigArgs>>) {
        this.serverlessConfigs = Output.all(values)
    }

    /**
     * @param value The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
     */
    @JvmName("lsifptguvbcdomck")
    public suspend fun sqlCollectorConfigValue(`value`: Output<Int>) {
        this.sqlCollectorConfigValue = value
    }

    /**
     * @param value The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
     */
    @JvmName("rojtherqjgxwithj")
    public suspend fun sqlCollectorStatus(`value`: Output<String>) {
        this.sqlCollectorStatus = value
    }

    /**
     * @param value Actions performed on SSL functions. Valid values:
     * `Open`: turn on SSL encryption;
     * `Close`: turn off SSL encryption;
     * `Update`: update SSL certificate.
     * See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
     * > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
     */
    @JvmName("nlbiijnlddpqdlaj")
    public suspend fun sslAction(`value`: Output<String>) {
        this.sslAction = value
    }

    /**
     * @param value The internal or public endpoint for which the server certificate needs to be created or updated.
     */
    @JvmName("dreuepjegiyfaokp")
    public suspend fun sslConnectionString(`value`: Output<String>) {
        this.sslConnectionString = value
    }

    /**
     * @param value Automatic storage space expansion switch. Valid values:
     * - Enable
     * - Disable
     * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
     */
    @JvmName("nvegstwgasasjfcq")
    public suspend fun storageAutoScale(`value`: Output<String>) {
        this.storageAutoScale = value
    }

    /**
     * @param value The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
     * Valid values: [10, 20, 30, 40, 50].
     * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
     */
    @JvmName("xossdnlywietknrl")
    public suspend fun storageThreshold(`value`: Output<Int>) {
        this.storageThreshold = value
    }

    /**
     * @param value The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
     * > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
     */
    @JvmName("lkdokurpefmegglv")
    public suspend fun storageUpperBound(`value`: Output<Int>) {
        this.storageUpperBound = value
    }

    /**
     * @param value The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.
     * > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
     */
    @JvmName("plephydgywcjkjdv")
    public suspend fun switchTime(`value`: Output<String>) {
        this.switchTime = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
     */
    @JvmName("kljisujxqpjpvcot")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
     * - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
     * - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
     * - rds: The instance runs RDS Basic or High-availability Edition.
     * - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
     * - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
     * - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
     * > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
     */
    @JvmName("qaqebjtqxqrjptpc")
    public suspend fun targetMinorVersion(`value`: Output<String>) {
        this.targetMinorVersion = value
    }

    /**
     * @param value The availability check method of the instance. Valid values:
     * - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
     * - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
     */
    @JvmName("ppyfjanjsldxqhjq")
    public suspend fun tcpConnectionType(`value`: Output<String>) {
        this.tcpConnectionType = value
    }

    /**
     * @param value The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
     */
    @JvmName("oxlpvjigagyfxywh")
    public suspend fun tdeStatus(`value`: Output<String>) {
        this.tdeStatus = value
    }

    /**
     * @param value Whether to upgrade a minor version of the kernel. Valid values:
     * - true: upgrade
     * - false: not to upgrade
     */
    @Deprecated(
        message = """
  Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use
      `target_minor_version` instead.
  """,
    )
    @JvmName("aittcpsflnwoolgf")
    public suspend fun upgradeDbInstanceKernelVersion(`value`: Output<Boolean>) {
        this.upgradeDbInstanceKernelVersion = value
    }

    /**
     * @param value The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
     * - Immediate: The minor engine version is immediately updated.
     * - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
     * - SpecifyTime: The minor engine version is updated at the point in time you specify.
     */
    @JvmName("lqgpxqiamwfejqtu")
    public suspend fun upgradeTime(`value`: Output<String>) {
        this.upgradeTime = value
    }

    /**
     * @param value The VPC ID of the instance.
     * > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
     */
    @JvmName("jbhxscnlooyeyart")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
     */
    @JvmName("silohhquxrrgqwah")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The network type of the IP address whitelist. Default value: MIX. Valid values:
     * - Classic: classic network in enhanced whitelist mode
     * - VPC: virtual private cloud (VPC) in enhanced whitelist mode
     * - MIX: standard whitelist mode
     * > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
     */
    @JvmName("wvopdyufntukmccd")
    public suspend fun whitelistNetworkType(`value`: Output<String>) {
        this.whitelistNetworkType = value
    }

    /**
     * @param value The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
     * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
     */
    @JvmName("okniparwynjuymga")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
     */
    @JvmName("evfpqjdaoctihehb")
    public suspend fun zoneIdSlaveA(`value`: Output<String>) {
        this.zoneIdSlaveA = value
    }

    /**
     * @param value The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - cert
     * - perfer
     * - verify-ca
     * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
     */
    @JvmName("ubqvthqsblntsvcq")
    public suspend fun acl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
     */
    @JvmName("pogxkirvauiutuuy")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
     */
    @JvmName("qmgkmgmftkaorvhc")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The upgrade method to use. Valid values:
     * - Auto: Instances are automatically upgraded to a higher minor version.
     * - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
     * See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
     */
    @JvmName("paogxeucvedvoqtj")
    public suspend fun autoUpgradeMinorVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
     * > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    @JvmName("ldvdinjwldfafpss")
    public suspend fun babelfishConfigs(`value`: List<InstanceBabelfishConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.babelfishConfigs = mapped
    }

    /**
     * @param argument The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
     * > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    @JvmName("ymhcmrksoywluwic")
    public suspend fun babelfishConfigs(argument: List<suspend InstanceBabelfishConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceBabelfishConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.babelfishConfigs = mapped
    }

    /**
     * @param argument The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
     * > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    @JvmName("qunsploddbytqnuo")
    public suspend fun babelfishConfigs(vararg argument: suspend InstanceBabelfishConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceBabelfishConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.babelfishConfigs = mapped
    }

    /**
     * @param argument The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
     * > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    @JvmName("cfloalpdceseansl")
    public suspend fun babelfishConfigs(argument: suspend InstanceBabelfishConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceBabelfishConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.babelfishConfigs = mapped
    }

    /**
     * @param values The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
     * > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    @JvmName("iwpytutxhrxwroym")
    public suspend fun babelfishConfigs(vararg values: InstanceBabelfishConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.babelfishConfigs = mapped
    }

    /**
     * @param value The TDS port of the instance for which Babelfish is enabled.
     * > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
     */
    @JvmName("mefkhguhmntwnbym")
    public suspend fun babelfishPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.babelfishPort = mapped
    }

    /**
     * @param value The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
     * - aliyun: a cloud certificate
     * - custom: a custom certificate
     */
    @JvmName("arvbvkyafablastn")
    public suspend fun caType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caType = mapped
    }

    /**
     * @param value The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
     * * **Basic**: Basic Edition.
     * * **HighAvailability**: High-availability Edition.
     * * **AlwaysOn**: Cluster Edition.
     * * **Finance**: Enterprise Edition.
     * * **cluster**: MySQL Cluster Edition. (Available since 1.202.0)
     * * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since 1.200.0)
     * * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since 1.204.0)
     * * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since 1.204.0)
     * > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
     */
    @JvmName("tvsnotjceqxgllug")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
     */
    @JvmName("esxewdhqhkcvfvws")
    public suspend fun clientCaCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCaCert = mapped
    }

    /**
     * @param value Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
     * - 1: enables the public key
     * - 0: disables the public key
     */
    @JvmName("tdiwipudtlwyuwjc")
    public suspend fun clientCaEnabled(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCaEnabled = mapped
    }

    /**
     * @param value The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
     */
    @JvmName("gyeyihqucproypsl")
    public suspend fun clientCertRevocationList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertRevocationList = mapped
    }

    /**
     * @param value Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - 1: enables the CRL
     * - 0: disables the CRL
     */
    @JvmName("fwmunsstqfacbvhn")
    public suspend fun clientCrlEnabled(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCrlEnabled = mapped
    }

    /**
     * @param value The private connection string prefix. If you want to update public connection string prefix, please use resource alicloud.rds.Connection connection_prefix.
     * > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\|{};:'",<>/?
     */
    @JvmName("yhqrxjgtiyltmntk")
    public suspend fun connectionStringPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStringPrefix = mapped
    }

    /**
     * @param value The attribute of the IP address whitelist. By default, this parameter is empty.
     * > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
     */
    @JvmName("rjxpcohjdqqwlxse")
    public suspend fun dbInstanceIpArrayAttribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIpArrayAttribute = mapped
    }

    /**
     * @param value The name of the IP address whitelist. Default value: Default.
     * > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
     */
    @JvmName("sqjswygwhtlmjpir")
    public suspend fun dbInstanceIpArrayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIpArrayName = mapped
    }

    /**
     * @param value The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
     * - local_ssd: specifies to use local SSDs. This value is recommended.
     * - cloud_ssd: specifies to use standard SSDs.
     * - cloud_essd: specifies to use enhanced SSDs (ESSDs).
     * - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
     * - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
     * - general_essd: general essd.
     */
    @JvmName("wtpkaccfyhmdslut")
    public suspend fun dbInstanceStorageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceStorageType = mapped
    }

    /**
     * @param value Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
     */
    @JvmName("ehhekndeuocaeijg")
    public suspend fun dbIsIgnoreCase(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbIsIgnoreCase = mapped
    }

    /**
     * @param value Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
     */
    @JvmName("sbdangkliigvyynq")
    public suspend fun dbParamGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbParamGroupId = mapped
    }

    /**
     * @param value The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
     * - If you set the `Engine` parameter to MySQL.
     * - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
     * - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
     * - If you set the `Engine` parameter to PostgreSQL.
     * - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
     * - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.
     * > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
     */
    @JvmName("mtirbhrtslujvshh")
    public suspend fun dbTimeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbTimeZone = mapped
    }

    /**
     * @param value The switch of delete protection. Valid values:
     * - true: delete protect.
     * - false: no delete protect.
     * > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
     */
    @JvmName("ufyqjdagpsastkwp")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
     */
    @JvmName("uxjyfmdtrydaouij")
    public suspend fun direction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The method to update the engine version and change.  Default value: Immediate. Valid values:
     * - Immediate: The change immediately takes effect.
     * - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
     */
    @JvmName("dwfrodhvtbyohsxw")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
     */
    @JvmName("ywyagxolwsirlkgd")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
     * > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
     */
    @JvmName("nwuvysilkxamadwq")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
     * - MySQL: [ 5&#46;5、5&#46;6、5&#46;7、8&#46;0 ]
     * - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
     * - PostgreSQL: [ 10&#46;0、11&#46;0、12&#46;0、13&#46;0、14&#46;0、15&#46;0 ]
     * - MariaDB: [ 10&#46;3 ]
     * - Serverless
     * > - MySQL: [ 5&#46;7、8&#46;0 ]
     * > - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
     * > - PostgreSQL: [ 14&#46;0 ]
     * > - MariaDB does not support creating serverless instances.
     */
    @JvmName("dewuqjoxjprpkndp")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Specifies whether to enable forcible switching. Valid values:
     * - Yes
     * - No
     */
    @JvmName("kvfppdhjpktexhmc")
    public suspend fun force(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value Set it to true to make some parameter efficient when modifying them. Default to false.
     */
    @JvmName("ohdiislnsvwcecpf")
    public suspend fun forceRestart(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceRestart = mapped
    }

    /**
     * @param value The read-only instances to which you want to synchronize the IP address whitelist.
     * * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
     * * If the instance is not attached with a read-only instance, this parameter is empty.
     */
    @JvmName("nihtckljkjcaedxk")
    public suspend fun freshWhiteListReadins(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.freshWhiteListReadins = mapped
    }

    /**
     * @param value The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
     * - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
     * - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
     * > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
     */
    @JvmName("alyuuhmxcmswdpah")
    public suspend fun haConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.haConfig = mapped
    }

    /**
     * @param value Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
     */
    @JvmName("nhnxpxejwfbuaeqn")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The name of DB instance. It a string of 2 to 256 characters.
     */
    @JvmName("tovqwuhshahmhwec")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value User-defined DB instance storage space. Value range:
     * - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
     * - [20,1000] for MySQL 5.7 basic single node edition;
     * - [10, 2000] for SQL Server 2008R2;
     * - [20,2000] for SQL Server 2012 basic single node edition
     * Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
     * Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
     */
    @JvmName("hupvaggavkncocqh")
    public suspend fun instanceStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceStorage = mapped
    }

    /**
     * @param value DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
     * - To create a serverless instance, please pass the following values:
     * - MySQL basic: mysql.n2.serverless.1c
     * - MySQL high availability: mysql.n2.serverless.2c
     * - SQLServer high availability: mssql.mem2.serverless.s2
     * - PostgreSQL basic: pg.n2.serverless.1c
     * > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
     */
    @JvmName("comjxdlbxlojqxre")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    @JvmName("qhjdqfjlticxjasm")
    public suspend fun maintainTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainTime = mapped
    }

    /**
     * @param value The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     * > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
     */
    @JvmName("ujljlofduhxrgmpt")
    public suspend fun manualHaTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manualHaTime = mapped
    }

    /**
     * @param value The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
     * - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
     * - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
     * - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
     */
    @JvmName("whkuxsewkgbujxip")
    public suspend fun modifyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyMode = mapped
    }

    /**
     * @param value The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
     */
    @JvmName("sduslijgyhiglhvj")
    public suspend fun monitoringPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringPeriod = mapped
    }

    /**
     * @param value The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
     */
    @JvmName("savvosshitwvpbqx")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeId = mapped
    }

    /**
     * @param value Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("ouitgiqqtjusicxj")
    public suspend fun parameters(`value`: List<InstanceParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("ajxtiorchrvecsgg")
    public suspend fun parameters(argument: List<suspend InstanceParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("ufcuwfppdsswtvvx")
    public suspend fun parameters(vararg argument: suspend InstanceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("jpbmgjyuxymuijyx")
    public suspend fun parameters(argument: suspend InstanceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
     */
    @JvmName("tmcdmdmupkleoosr")
    public suspend fun parameters(vararg values: InstanceParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("einugohashoikbwa")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("ofyyomidqhmqfwnn")
    public suspend fun pgHbaConfs(`value`: List<InstancePgHbaConfArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pgHbaConfs = mapped
    }

    /**
     * @param argument The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("aassgwfmsnwucphv")
    public suspend fun pgHbaConfs(argument: List<suspend InstancePgHbaConfArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstancePgHbaConfArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pgHbaConfs = mapped
    }

    /**
     * @param argument The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("cceciwhrqrjeyhiq")
    public suspend fun pgHbaConfs(vararg argument: suspend InstancePgHbaConfArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstancePgHbaConfArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pgHbaConfs = mapped
    }

    /**
     * @param argument The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("dkqrmjhxeysqjpbp")
    public suspend fun pgHbaConfs(argument: suspend InstancePgHbaConfArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstancePgHbaConfArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.pgHbaConfs = mapped
    }

    /**
     * @param values The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
     */
    @JvmName("mtimqayollulumki")
    public suspend fun pgHbaConfs(vararg values: InstancePgHbaConfArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pgHbaConfs = mapped
    }

    /**
     * @param value The private port of the database service. If you want to update public port, please use resource alicloud.rds.Connection port.
     */
    @JvmName("nyavgncshvmyvheg")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
     */
    @JvmName("dndywddwhogtpxbs")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
     * - None: No archived backup files are retained.
     * - Lastest: Only the last archived backup file is retained.
     * - All: All the archived backup files are retained.
     * > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
     */
    @JvmName("evvmmoxohjksonwh")
    public suspend fun releasedKeepPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releasedKeepPolicy = mapped
    }

    /**
     * @param value The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
     * - cert
     * - perfer
     * - verify-ca
     * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
     */
    @JvmName("shqtwpicpdeucktk")
    public suspend fun replicationAcl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationAcl = mapped
    }

    /**
     * @param value The ID of resource group which the DB instance belongs.
     */
    @JvmName("uoqgfxymhgtnimif")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the RAM role.
     * > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
     * You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
     */
    @JvmName("dgktjxahketcxdia")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value It has been deprecated from 1.69.0 and use `security_group_ids` instead.
     */
    @Deprecated(
        message = """
  Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids`
      instead.
  """,
    )
    @JvmName("fxscvkedsqayrxud")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value , Available since 1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
     */
    @JvmName("dkuivgpuohbdmsag")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values , Available since 1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
     */
    @JvmName("gwmjkdbhatbjsphq")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
     */
    @JvmName("rqydsxskxqscljcr")
    public suspend fun securityIpMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpMode = mapped
    }

    /**
     * @param value The type of IP address in the IP address whitelist.
     */
    @JvmName("dklefmejlmoopvwu")
    public suspend fun securityIpType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpType = mapped
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("akekonlchrvdtuht")
    public suspend fun securityIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("tknsxypnvyydxkft")
    public suspend fun securityIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param value The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
     */
    @JvmName("hpeqjmjrxsnirofn")
    public suspend fun serverCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCert = mapped
    }

    /**
     * @param value The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
     */
    @JvmName("jlxrsyhijaavabfr")
    public suspend fun serverKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverKey = mapped
    }

    /**
     * @param value The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
     */
    @JvmName("wpleyrvghoryodmf")
    public suspend fun serverlessConfigs(`value`: List<InstanceServerlessConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessConfigs = mapped
    }

    /**
     * @param argument The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
     */
    @JvmName("owrplbfxftoirhge")
    public suspend fun serverlessConfigs(argument: List<suspend InstanceServerlessConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceServerlessConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serverlessConfigs = mapped
    }

    /**
     * @param argument The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
     */
    @JvmName("peexapxtqwcajimg")
    public suspend fun serverlessConfigs(vararg argument: suspend InstanceServerlessConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceServerlessConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serverlessConfigs = mapped
    }

    /**
     * @param argument The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
     */
    @JvmName("iwumurpxduyogoet")
    public suspend fun serverlessConfigs(argument: suspend InstanceServerlessConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceServerlessConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serverlessConfigs = mapped
    }

    /**
     * @param values The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
     */
    @JvmName("ddvaauylpbwogiro")
    public suspend fun serverlessConfigs(vararg values: InstanceServerlessConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverlessConfigs = mapped
    }

    /**
     * @param value The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
     */
    @JvmName("bpkcquumccrfkvuv")
    public suspend fun sqlCollectorConfigValue(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlCollectorConfigValue = mapped
    }

    /**
     * @param value The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
     */
    @JvmName("fvrpibkdlamwwfvp")
    public suspend fun sqlCollectorStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlCollectorStatus = mapped
    }

    /**
     * @param value Actions performed on SSL functions. Valid values:
     * `Open`: turn on SSL encryption;
     * `Close`: turn off SSL encryption;
     * `Update`: update SSL certificate.
     * See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
     * > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
     */
    @JvmName("oajcfskrsivykqfw")
    public suspend fun sslAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslAction = mapped
    }

    /**
     * @param value The internal or public endpoint for which the server certificate needs to be created or updated.
     */
    @JvmName("cfkhfsiwesbytmap")
    public suspend fun sslConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslConnectionString = mapped
    }

    /**
     * @param value Automatic storage space expansion switch. Valid values:
     * - Enable
     * - Disable
     * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
     */
    @JvmName("yhkvyinfvleajuru")
    public suspend fun storageAutoScale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAutoScale = mapped
    }

    /**
     * @param value The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
     * Valid values: [10, 20, 30, 40, 50].
     * > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
     */
    @JvmName("enggfclhredxqsnp")
    public suspend fun storageThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageThreshold = mapped
    }

    /**
     * @param value The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
     * > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
     */
    @JvmName("qbrkckqakhqwqtfo")
    public suspend fun storageUpperBound(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageUpperBound = mapped
    }

    /**
     * @param value The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.
     * > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
     */
    @JvmName("jdkkuaicohedwtoo")
    public suspend fun switchTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.switchTime = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
     */
    @JvmName("ossohexaiapgesyv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
     */
    @JvmName("uwjagiwwfsevrnxj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
     * - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
     * - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
     * - rds: The instance runs RDS Basic or High-availability Edition.
     * - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
     * - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
     * - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
     * > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
     */
    @JvmName("ocetreicglsgbktl")
    public suspend fun targetMinorVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetMinorVersion = mapped
    }

    /**
     * @param value The availability check method of the instance. Valid values:
     * - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
     * - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
     */
    @JvmName("goyqkdrajrctmehh")
    public suspend fun tcpConnectionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpConnectionType = mapped
    }

    /**
     * @param value The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
     */
    @JvmName("ehccdiascvvlokyw")
    public suspend fun tdeStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tdeStatus = mapped
    }

    /**
     * @param value Whether to upgrade a minor version of the kernel. Valid values:
     * - true: upgrade
     * - false: not to upgrade
     */
    @Deprecated(
        message = """
  Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use
      `target_minor_version` instead.
  """,
    )
    @JvmName("jjssypkcccgjgmwl")
    public suspend fun upgradeDbInstanceKernelVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeDbInstanceKernelVersion = mapped
    }

    /**
     * @param value The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
     * - Immediate: The minor engine version is immediately updated.
     * - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
     * - SpecifyTime: The minor engine version is updated at the point in time you specify.
     */
    @JvmName("yiamapxfhsenjtcw")
    public suspend fun upgradeTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeTime = mapped
    }

    /**
     * @param value The VPC ID of the instance.
     * > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
     */
    @JvmName("nliddrqqlqchivub")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
     */
    @JvmName("nrtplxofmpqkmlsq")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The network type of the IP address whitelist. Default value: MIX. Valid values:
     * - Classic: classic network in enhanced whitelist mode
     * - VPC: virtual private cloud (VPC) in enhanced whitelist mode
     * - MIX: standard whitelist mode
     * > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
     */
    @JvmName("tmvqgrwafsfwighb")
    public suspend fun whitelistNetworkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.whitelistNetworkType = mapped
    }

    /**
     * @param value The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
     * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
     */
    @JvmName("yfneddlswkluscpv")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    /**
     * @param value The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
     */
    @JvmName("dylbngrquyqvwlae")
    public suspend fun zoneIdSlaveA(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneIdSlaveA = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        acl = acl,
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        babelfishConfigs = babelfishConfigs,
        babelfishPort = babelfishPort,
        caType = caType,
        category = category,
        clientCaCert = clientCaCert,
        clientCaEnabled = clientCaEnabled,
        clientCertRevocationList = clientCertRevocationList,
        clientCrlEnabled = clientCrlEnabled,
        connectionStringPrefix = connectionStringPrefix,
        dbInstanceIpArrayAttribute = dbInstanceIpArrayAttribute,
        dbInstanceIpArrayName = dbInstanceIpArrayName,
        dbInstanceStorageType = dbInstanceStorageType,
        dbIsIgnoreCase = dbIsIgnoreCase,
        dbParamGroupId = dbParamGroupId,
        dbTimeZone = dbTimeZone,
        deletionProtection = deletionProtection,
        direction = direction,
        effectiveTime = effectiveTime,
        encryptionKey = encryptionKey,
        engine = engine,
        engineVersion = engineVersion,
        force = force,
        forceRestart = forceRestart,
        freshWhiteListReadins = freshWhiteListReadins,
        haConfig = haConfig,
        instanceChargeType = instanceChargeType,
        instanceName = instanceName,
        instanceStorage = instanceStorage,
        instanceType = instanceType,
        maintainTime = maintainTime,
        manualHaTime = manualHaTime,
        modifyMode = modifyMode,
        monitoringPeriod = monitoringPeriod,
        nodeId = nodeId,
        parameters = parameters,
        period = period,
        pgHbaConfs = pgHbaConfs,
        port = port,
        privateIpAddress = privateIpAddress,
        releasedKeepPolicy = releasedKeepPolicy,
        replicationAcl = replicationAcl,
        resourceGroupId = resourceGroupId,
        roleArn = roleArn,
        securityGroupId = securityGroupId,
        securityGroupIds = securityGroupIds,
        securityIpMode = securityIpMode,
        securityIpType = securityIpType,
        securityIps = securityIps,
        serverCert = serverCert,
        serverKey = serverKey,
        serverlessConfigs = serverlessConfigs,
        sqlCollectorConfigValue = sqlCollectorConfigValue,
        sqlCollectorStatus = sqlCollectorStatus,
        sslAction = sslAction,
        sslConnectionString = sslConnectionString,
        storageAutoScale = storageAutoScale,
        storageThreshold = storageThreshold,
        storageUpperBound = storageUpperBound,
        switchTime = switchTime,
        tags = tags,
        targetMinorVersion = targetMinorVersion,
        tcpConnectionType = tcpConnectionType,
        tdeStatus = tdeStatus,
        upgradeDbInstanceKernelVersion = upgradeDbInstanceKernelVersion,
        upgradeTime = upgradeTime,
        vpcId = vpcId,
        vswitchId = vswitchId,
        whitelistNetworkType = whitelistNetworkType,
        zoneId = zoneId,
        zoneIdSlaveA = zoneIdSlaveA,
    )
}
