@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [RdsAccount].
 */
@PulumiTagMarker
public class RdsAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RdsAccountArgs = RdsAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RdsAccountArgsBuilder.() -> Unit) {
        val builder = RdsAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RdsAccount {
        val builtJavaResource = com.pulumi.alicloud.rds.RdsAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RdsAccount(builtJavaResource)
    }
}

/**
 * Provides a RDS Account resource.
 * For information about RDS Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-createaccount).
 * > **NOTE:** Available since v1.120.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.rds.getZones({
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 * });
 * const defaultGetInstanceClasses = _default.then(_default => alicloud.rds.getInstanceClasses({
 *     zoneId: _default.ids?.[0],
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.ids?.[0]),
 *     vswitchName: name,
 * });
 * const defaultInstance = new alicloud.rds.Instance("default", {
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 *     instanceType: defaultGetInstanceClasses.then(defaultGetInstanceClasses => defaultGetInstanceClasses.instanceClasses?.[1]?.instanceClass),
 *     instanceStorage: 10,
 *     vswitchId: defaultSwitch.id,
 *     instanceName: name,
 * });
 * const defaultRdsAccount = new alicloud.rds.RdsAccount("default", {
 *     dbInstanceId: defaultInstance.id,
 *     accountName: name,
 *     accountPassword: "Example1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.rds.get_zones(engine="MySQL",
 *     engine_version="5.6")
 * default_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=default.ids[0],
 *     engine="MySQL",
 *     engine_version="5.6")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.ids[0],
 *     vswitch_name=name)
 * default_instance = alicloud.rds.Instance("default",
 *     engine="MySQL",
 *     engine_version="5.6",
 *     instance_type=default_get_instance_classes.instance_classes[1].instance_class,
 *     instance_storage=10,
 *     vswitch_id=default_switch.id,
 *     instance_name=name)
 * default_rds_account = alicloud.rds.RdsAccount("default",
 *     db_instance_id=default_instance.id,
 *     account_name=name,
 *     account_password="Example1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.Rds.GetZones.Invoke(new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *     });
 *     var defaultGetInstanceClasses = AliCloud.Rds.GetInstanceClasses.Invoke(new()
 *     {
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[0]),
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids[0])),
 *         VswitchName = name,
 *     });
 *     var defaultInstance = new AliCloud.Rds.Instance("default", new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *         InstanceType = defaultGetInstanceClasses.Apply(getInstanceClassesResult => getInstanceClassesResult.InstanceClasses[1]?.InstanceClass),
 *         InstanceStorage = 10,
 *         VswitchId = defaultSwitch.Id,
 *         InstanceName = name,
 *     });
 *     var defaultRdsAccount = new AliCloud.Rds.RdsAccount("default", new()
 *     {
 *         DbInstanceId = defaultInstance.Id,
 *         AccountName = name,
 *         AccountPassword = "Example1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := rds.GetZones(ctx, &rds.GetZonesArgs{
 * 			Engine:        pulumi.StringRef("MySQL"),
 * 			EngineVersion: pulumi.StringRef("5.6"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceClasses, err := rds.GetInstanceClasses(ctx, &rds.GetInstanceClassesArgs{
 * 			ZoneId:        pulumi.StringRef(_default.Ids[0]),
 * 			Engine:        pulumi.StringRef("MySQL"),
 * 			EngineVersion: pulumi.StringRef("5.6"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Ids[0]),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := rds.NewInstance(ctx, "default", &rds.InstanceArgs{
 * 			Engine:          pulumi.String("MySQL"),
 * 			EngineVersion:   pulumi.String("5.6"),
 * 			InstanceType:    pulumi.String(defaultGetInstanceClasses.InstanceClasses[1].InstanceClass),
 * 			InstanceStorage: pulumi.Int(10),
 * 			VswitchId:       defaultSwitch.ID(),
 * 			InstanceName:    pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewRdsAccount(ctx, "default", &rds.RdsAccountArgs{
 * 			DbInstanceId:    defaultInstance.ID(),
 * 			AccountName:     pulumi.String(name),
 * 			AccountPassword: pulumi.String("Example1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.RdsFunctions;
 * import com.pulumi.alicloud.rds.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.rds.inputs.GetInstanceClassesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.rds.Instance;
 * import com.pulumi.alicloud.rds.InstanceArgs;
 * import com.pulumi.alicloud.rds.RdsAccount;
 * import com.pulumi.alicloud.rds.RdsAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = RdsFunctions.getZones(GetZonesArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .build());
 *         final var defaultGetInstanceClasses = RdsFunctions.getInstanceClasses(GetInstanceClassesArgs.builder()
 *             .zoneId(default_.ids()[0])
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.ids()[0])
 *             .vswitchName(name)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .instanceType(defaultGetInstanceClasses.applyValue(getInstanceClassesResult -> getInstanceClassesResult.instanceClasses()[1].instanceClass()))
 *             .instanceStorage("10")
 *             .vswitchId(defaultSwitch.id())
 *             .instanceName(name)
 *             .build());
 *         var defaultRdsAccount = new RdsAccount("defaultRdsAccount", RdsAccountArgs.builder()
 *             .dbInstanceId(defaultInstance.id())
 *             .accountName(name)
 *             .accountPassword("Example1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.ids[0]}
 *       vswitchName: ${name}
 *   defaultInstance:
 *     type: alicloud:rds:Instance
 *     name: default
 *     properties:
 *       engine: MySQL
 *       engineVersion: '5.6'
 *       instanceType: ${defaultGetInstanceClasses.instanceClasses[1].instanceClass}
 *       instanceStorage: '10'
 *       vswitchId: ${defaultSwitch.id}
 *       instanceName: ${name}
 *   defaultRdsAccount:
 *     type: alicloud:rds:RdsAccount
 *     name: default
 *     properties:
 *       dbInstanceId: ${defaultInstance.id}
 *       accountName: ${name}
 *       accountPassword: Example1234
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:rds:getZones
 *       Arguments:
 *         engine: MySQL
 *         engineVersion: '5.6'
 *   defaultGetInstanceClasses:
 *     fn::invoke:
 *       Function: alicloud:rds:getInstanceClasses
 *       Arguments:
 *         zoneId: ${default.ids[0]}
 *         engine: MySQL
 *         engineVersion: '5.6'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/rdsAccount:RdsAccount example <db_instance_id>:<account_name>
 * ```
 */
public class RdsAccount internal constructor(
    override val javaResource: com.pulumi.alicloud.rds.RdsAccount,
) : KotlinCustomResource(javaResource, RdsAccountMapper) {
    /**
     * The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.
     * > **NOTE:** The name cannot start with http:// or https://.
     */
    public val accountDescription: Output<String>
        get() = javaResource.accountDescription().applyValue({ args0 -> args0 })

    /**
     * The name of the database account.
     * * The name must be unique.
     * * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
     * * The name must start with a letter and end with a letter or digit.
     * * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
     * * The length of the value must meet the following requirements:
     * * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
     * * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
     * * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
     * * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
     * * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
     * * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
     * * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
     */
    public val accountName: Output<String>
        get() = javaResource.accountName().applyValue({ args0 -> args0 })

    /**
     * The password of the account.
     * * The value must be 8 to 32 characters in length.
     * * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
     * * Special characters include ! @ # $ % ^ & * ( ) _ + - =
     */
    public val accountPassword: Output<String>
        get() = javaResource.accountPassword().applyValue({ args0 -> args0 })

    /**
     * The account type. Valid values:
     * * Normal: standard account (default).
     * * Super: privileged account.
     * * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.
     * > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
     */
    public val accountType: Output<String>
        get() = javaResource.accountType().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance.
     */
    public val dbInstanceId: Output<String>
        get() = javaResource.dbInstanceId().applyValue({ args0 -> args0 })

    /**
     * The attribute has been deprecated from 1.120.0 and using `account_description` instead.
     */
    @Deprecated(
        message = """
  Field 'description' has been deprecated from provider version 1.120.0. New field
      'account_description' instead.
  """,
    )
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
     */
    @Deprecated(
        message = """
  Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id'
      instead.
  """,
    )
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The attribute has been deprecated from 1.120.0 and using `account_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The attribute has been deprecated from 1.120.0 and using `account_password` instead.
     */
    @Deprecated(
        message = """
  Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password'
      instead.
  """,
    )
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
     */
    public val resetPermissionFlag: Output<Boolean>?
        get() = javaResource.resetPermissionFlag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource. Valid values: `Available`, `Unavailable`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The attribute has been deprecated from 1.120.0 and using `account_type` instead.
     * > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.
  """,
    )
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RdsAccountMapper : ResourceMapper<RdsAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rds.RdsAccount::class == javaResource::class

    override fun map(javaResource: Resource): RdsAccount = RdsAccount(
        javaResource as
            com.pulumi.alicloud.rds.RdsAccount,
    )
}

/**
 * @see [RdsAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RdsAccount].
 */
public suspend fun rdsAccount(name: String, block: suspend RdsAccountResourceBuilder.() -> Unit): RdsAccount {
    val builder = RdsAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RdsAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rdsAccount(name: String): RdsAccount {
    val builder = RdsAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
