@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.RdsAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a RDS Account resource.
 * For information about RDS Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-createaccount).
 * > **NOTE:** Available since v1.120.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.rds.getZones({
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 * });
 * const defaultGetInstanceClasses = _default.then(_default => alicloud.rds.getInstanceClasses({
 *     zoneId: _default.ids?.[0],
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.ids?.[0]),
 *     vswitchName: name,
 * });
 * const defaultInstance = new alicloud.rds.Instance("default", {
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 *     instanceType: defaultGetInstanceClasses.then(defaultGetInstanceClasses => defaultGetInstanceClasses.instanceClasses?.[1]?.instanceClass),
 *     instanceStorage: 10,
 *     vswitchId: defaultSwitch.id,
 *     instanceName: name,
 * });
 * const defaultRdsAccount = new alicloud.rds.RdsAccount("default", {
 *     dbInstanceId: defaultInstance.id,
 *     accountName: name,
 *     accountPassword: "Example1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.rds.get_zones(engine="MySQL",
 *     engine_version="5.6")
 * default_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=default.ids[0],
 *     engine="MySQL",
 *     engine_version="5.6")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.ids[0],
 *     vswitch_name=name)
 * default_instance = alicloud.rds.Instance("default",
 *     engine="MySQL",
 *     engine_version="5.6",
 *     instance_type=default_get_instance_classes.instance_classes[1].instance_class,
 *     instance_storage=10,
 *     vswitch_id=default_switch.id,
 *     instance_name=name)
 * default_rds_account = alicloud.rds.RdsAccount("default",
 *     db_instance_id=default_instance.id,
 *     account_name=name,
 *     account_password="Example1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.Rds.GetZones.Invoke(new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *     });
 *     var defaultGetInstanceClasses = AliCloud.Rds.GetInstanceClasses.Invoke(new()
 *     {
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[0]),
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids[0])),
 *         VswitchName = name,
 *     });
 *     var defaultInstance = new AliCloud.Rds.Instance("default", new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *         InstanceType = defaultGetInstanceClasses.Apply(getInstanceClassesResult => getInstanceClassesResult.InstanceClasses[1]?.InstanceClass),
 *         InstanceStorage = 10,
 *         VswitchId = defaultSwitch.Id,
 *         InstanceName = name,
 *     });
 *     var defaultRdsAccount = new AliCloud.Rds.RdsAccount("default", new()
 *     {
 *         DbInstanceId = defaultInstance.Id,
 *         AccountName = name,
 *         AccountPassword = "Example1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := rds.GetZones(ctx, &rds.GetZonesArgs{
 * 			Engine:        pulumi.StringRef("MySQL"),
 * 			EngineVersion: pulumi.StringRef("5.6"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceClasses, err := rds.GetInstanceClasses(ctx, &rds.GetInstanceClassesArgs{
 * 			ZoneId:        pulumi.StringRef(_default.Ids[0]),
 * 			Engine:        pulumi.StringRef("MySQL"),
 * 			EngineVersion: pulumi.StringRef("5.6"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Ids[0]),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := rds.NewInstance(ctx, "default", &rds.InstanceArgs{
 * 			Engine:          pulumi.String("MySQL"),
 * 			EngineVersion:   pulumi.String("5.6"),
 * 			InstanceType:    pulumi.String(defaultGetInstanceClasses.InstanceClasses[1].InstanceClass),
 * 			InstanceStorage: pulumi.Int(10),
 * 			VswitchId:       defaultSwitch.ID(),
 * 			InstanceName:    pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewRdsAccount(ctx, "default", &rds.RdsAccountArgs{
 * 			DbInstanceId:    defaultInstance.ID(),
 * 			AccountName:     pulumi.String(name),
 * 			AccountPassword: pulumi.String("Example1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.RdsFunctions;
 * import com.pulumi.alicloud.rds.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.rds.inputs.GetInstanceClassesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.rds.Instance;
 * import com.pulumi.alicloud.rds.InstanceArgs;
 * import com.pulumi.alicloud.rds.RdsAccount;
 * import com.pulumi.alicloud.rds.RdsAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = RdsFunctions.getZones(GetZonesArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .build());
 *         final var defaultGetInstanceClasses = RdsFunctions.getInstanceClasses(GetInstanceClassesArgs.builder()
 *             .zoneId(default_.ids()[0])
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.ids()[0])
 *             .vswitchName(name)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .instanceType(defaultGetInstanceClasses.applyValue(getInstanceClassesResult -> getInstanceClassesResult.instanceClasses()[1].instanceClass()))
 *             .instanceStorage("10")
 *             .vswitchId(defaultSwitch.id())
 *             .instanceName(name)
 *             .build());
 *         var defaultRdsAccount = new RdsAccount("defaultRdsAccount", RdsAccountArgs.builder()
 *             .dbInstanceId(defaultInstance.id())
 *             .accountName(name)
 *             .accountPassword("Example1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.ids[0]}
 *       vswitchName: ${name}
 *   defaultInstance:
 *     type: alicloud:rds:Instance
 *     name: default
 *     properties:
 *       engine: MySQL
 *       engineVersion: '5.6'
 *       instanceType: ${defaultGetInstanceClasses.instanceClasses[1].instanceClass}
 *       instanceStorage: '10'
 *       vswitchId: ${defaultSwitch.id}
 *       instanceName: ${name}
 *   defaultRdsAccount:
 *     type: alicloud:rds:RdsAccount
 *     name: default
 *     properties:
 *       dbInstanceId: ${defaultInstance.id}
 *       accountName: ${name}
 *       accountPassword: Example1234
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:rds:getZones
 *       Arguments:
 *         engine: MySQL
 *         engineVersion: '5.6'
 *   defaultGetInstanceClasses:
 *     fn::invoke:
 *       Function: alicloud:rds:getInstanceClasses
 *       Arguments:
 *         zoneId: ${default.ids[0]}
 *         engine: MySQL
 *         engineVersion: '5.6'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/rdsAccount:RdsAccount example <db_instance_id>:<account_name>
 * ```
 * @property accountDescription The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.
 * > **NOTE:** The name cannot start with http:// or https://.
 * @property accountName The name of the database account.
 * * The name must be unique.
 * * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
 * * The name must start with a letter and end with a letter or digit.
 * * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
 * * The length of the value must meet the following requirements:
 * * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
 * * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
 * * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
 * * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
 * * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
 * * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
 * * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
 * @property accountPassword The password of the account.
 * * The value must be 8 to 32 characters in length.
 * * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
 * * Special characters include ! @ # $ % ^ & * ( ) _ + - =
 * @property accountType The account type. Valid values:
 * * Normal: standard account (default).
 * * Super: privileged account.
 * * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.
 * > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
 * @property dbInstanceId The ID of the instance.
 * @property description The attribute has been deprecated from 1.120.0 and using `account_description` instead.
 * @property instanceId The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
 * @property kmsEncryptedPassword An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 * @property name The attribute has been deprecated from 1.120.0 and using `account_name` instead.
 * @property password The attribute has been deprecated from 1.120.0 and using `account_password` instead.
 * @property resetPermissionFlag Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
 * @property type The attribute has been deprecated from 1.120.0 and using `account_type` instead.
 * > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
 */
public data class RdsAccountArgs(
    public val accountDescription: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val accountPassword: Output<String>? = null,
    public val accountType: Output<String>? = null,
    public val dbInstanceId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'description' has been deprecated from provider version 1.120.0. New field
      'account_description' instead.
  """,
    )
    public val description: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id'
      instead.
  """,
    )
    public val instanceId: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password'
      instead.
  """,
    )
    public val password: Output<String>? = null,
    public val resetPermissionFlag: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.
  """,
    )
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.RdsAccountArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.RdsAccountArgs =
        com.pulumi.alicloud.rds.RdsAccountArgs.builder()
            .accountDescription(accountDescription?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .accountPassword(accountPassword?.applyValue({ args0 -> args0 }))
            .accountType(accountType?.applyValue({ args0 -> args0 }))
            .dbInstanceId(dbInstanceId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resetPermissionFlag(resetPermissionFlag?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsAccountArgs].
 */
@PulumiTagMarker
public class RdsAccountArgsBuilder internal constructor() {
    private var accountDescription: Output<String>? = null

    private var accountName: Output<String>? = null

    private var accountPassword: Output<String>? = null

    private var accountType: Output<String>? = null

    private var dbInstanceId: Output<String>? = null

    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var resetPermissionFlag: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.
     * > **NOTE:** The name cannot start with http:// or https://.
     */
    @JvmName("fauxcvmbgfdsolfg")
    public suspend fun accountDescription(`value`: Output<String>) {
        this.accountDescription = value
    }

    /**
     * @param value The name of the database account.
     * * The name must be unique.
     * * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
     * * The name must start with a letter and end with a letter or digit.
     * * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
     * * The length of the value must meet the following requirements:
     * * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
     * * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
     * * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
     * * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
     * * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
     * * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
     * * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
     */
    @JvmName("qsgeyxqcdslycyww")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The password of the account.
     * * The value must be 8 to 32 characters in length.
     * * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
     * * Special characters include ! @ # $ % ^ & * ( ) _ + - =
     */
    @JvmName("gceltdhgbptackjq")
    public suspend fun accountPassword(`value`: Output<String>) {
        this.accountPassword = value
    }

    /**
     * @param value The account type. Valid values:
     * * Normal: standard account (default).
     * * Super: privileged account.
     * * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.
     * > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
     */
    @JvmName("mssgxluvgwoyqehr")
    public suspend fun accountType(`value`: Output<String>) {
        this.accountType = value
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("ybmpmdnwjumhjout")
    public suspend fun dbInstanceId(`value`: Output<String>) {
        this.dbInstanceId = value
    }

    /**
     * @param value The attribute has been deprecated from 1.120.0 and using `account_description` instead.
     */
    @Deprecated(
        message = """
  Field 'description' has been deprecated from provider version 1.120.0. New field
      'account_description' instead.
  """,
    )
    @JvmName("spnhrahsaptxgedr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
     */
    @Deprecated(
        message = """
  Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id'
      instead.
  """,
    )
    @JvmName("colkenqodvuavjjb")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
     */
    @JvmName("gywbrvjgibohcoup")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("ngcegutnwctqgoaw")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value The attribute has been deprecated from 1.120.0 and using `account_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.
  """,
    )
    @JvmName("umeonvosbglgdadj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The attribute has been deprecated from 1.120.0 and using `account_password` instead.
     */
    @Deprecated(
        message = """
  Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password'
      instead.
  """,
    )
    @JvmName("thgpqpcnuojbkdma")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
     */
    @JvmName("smdsyansresyklpv")
    public suspend fun resetPermissionFlag(`value`: Output<Boolean>) {
        this.resetPermissionFlag = value
    }

    /**
     * @param value The attribute has been deprecated from 1.120.0 and using `account_type` instead.
     * > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.
  """,
    )
    @JvmName("apxgxusftgfbhsds")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.
     * > **NOTE:** The name cannot start with http:// or https://.
     */
    @JvmName("rcdqexhrpgxxdxht")
    public suspend fun accountDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountDescription = mapped
    }

    /**
     * @param value The name of the database account.
     * * The name must be unique.
     * * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
     * * The name must start with a letter and end with a letter or digit.
     * * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
     * * The length of the value must meet the following requirements:
     * * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
     * * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
     * * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
     * * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
     * * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
     * * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
     * * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
     */
    @JvmName("licvhyahnrjwxdxr")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The password of the account.
     * * The value must be 8 to 32 characters in length.
     * * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
     * * Special characters include ! @ # $ % ^ & * ( ) _ + - =
     */
    @JvmName("cycpddvqsvtevpqb")
    public suspend fun accountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPassword = mapped
    }

    /**
     * @param value The account type. Valid values:
     * * Normal: standard account (default).
     * * Super: privileged account.
     * * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.
     * > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
     */
    @JvmName("reorrrtftyogqmhh")
    public suspend fun accountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("eoqyrkijggvnfwoa")
    public suspend fun dbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceId = mapped
    }

    /**
     * @param value The attribute has been deprecated from 1.120.0 and using `account_description` instead.
     */
    @Deprecated(
        message = """
  Field 'description' has been deprecated from provider version 1.120.0. New field
      'account_description' instead.
  """,
    )
    @JvmName("kykjygarfucffhpv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
     */
    @Deprecated(
        message = """
  Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id'
      instead.
  """,
    )
    @JvmName("rxgrvsdynmujavox")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
     */
    @JvmName("sqfacxdkrddtqwuc")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("venmnxnyabbggcyu")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("dsrshdeegexcgyns")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value The attribute has been deprecated from 1.120.0 and using `account_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.
  """,
    )
    @JvmName("psjkwafikjjupomg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The attribute has been deprecated from 1.120.0 and using `account_password` instead.
     */
    @Deprecated(
        message = """
  Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password'
      instead.
  """,
    )
    @JvmName("yymksqsrrgdqbqpb")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
     */
    @JvmName("hiadobsviqclqbvr")
    public suspend fun resetPermissionFlag(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resetPermissionFlag = mapped
    }

    /**
     * @param value The attribute has been deprecated from 1.120.0 and using `account_type` instead.
     * > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.
  """,
    )
    @JvmName("pdkqlyclewanbnxe")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RdsAccountArgs = RdsAccountArgs(
        accountDescription = accountDescription,
        accountName = accountName,
        accountPassword = accountPassword,
        accountType = accountType,
        dbInstanceId = dbInstanceId,
        description = description,
        instanceId = instanceId,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        name = name,
        password = password,
        resetPermissionFlag = resetPermissionFlag,
        type = type,
    )
}
