@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RdsBackup].
 */
@PulumiTagMarker
public class RdsBackupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RdsBackupArgs = RdsBackupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RdsBackupArgsBuilder.() -> Unit) {
        val builder = RdsBackupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RdsBackup {
        val builtJavaResource = com.pulumi.alicloud.rds.RdsBackup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RdsBackup(builtJavaResource)
    }
}

/**
 * Provides a RDS Backup resource.
 * For information about RDS Backup and how to use it, see [What is Backup](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-createbackup).
 * > **NOTE:** Available since v1.149.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.rds.Instance("example", {
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 *     instanceType: "rds.mysql.t1.small",
 *     instanceStorage: 30,
 *     instanceChargeType: "Postpaid",
 *     dbInstanceStorageType: "local_ssd",
 * });
 * const exampleRdsBackup = new alicloud.rds.RdsBackup("example", {dbInstanceId: example.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.rds.Instance("example",
 *     engine="MySQL",
 *     engine_version="5.6",
 *     instance_type="rds.mysql.t1.small",
 *     instance_storage=30,
 *     instance_charge_type="Postpaid",
 *     db_instance_storage_type="local_ssd")
 * example_rds_backup = alicloud.rds.RdsBackup("example", db_instance_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Rds.Instance("example", new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *         InstanceType = "rds.mysql.t1.small",
 *         InstanceStorage = 30,
 *         InstanceChargeType = "Postpaid",
 *         DbInstanceStorageType = "local_ssd",
 *     });
 *     var exampleRdsBackup = new AliCloud.Rds.RdsBackup("example", new()
 *     {
 *         DbInstanceId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.NewInstance(ctx, "example", &rds.InstanceArgs{
 * 			Engine:                pulumi.String("MySQL"),
 * 			EngineVersion:         pulumi.String("5.6"),
 * 			InstanceType:          pulumi.String("rds.mysql.t1.small"),
 * 			InstanceStorage:       pulumi.Int(30),
 * 			InstanceChargeType:    pulumi.String("Postpaid"),
 * 			DbInstanceStorageType: pulumi.String("local_ssd"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewRdsBackup(ctx, "example", &rds.RdsBackupArgs{
 * 			DbInstanceId: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.Instance;
 * import com.pulumi.alicloud.rds.InstanceArgs;
 * import com.pulumi.alicloud.rds.RdsBackup;
 * import com.pulumi.alicloud.rds.RdsBackupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .instanceType("rds.mysql.t1.small")
 *             .instanceStorage("30")
 *             .instanceChargeType("Postpaid")
 *             .dbInstanceStorageType("local_ssd")
 *             .build());
 *         var exampleRdsBackup = new RdsBackup("exampleRdsBackup", RdsBackupArgs.builder()
 *             .dbInstanceId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:rds:Instance
 *     properties:
 *       engine: MySQL
 *       engineVersion: '5.6'
 *       instanceType: rds.mysql.t1.small
 *       instanceStorage: '30'
 *       instanceChargeType: Postpaid
 *       dbInstanceStorageType: local_ssd
 *   exampleRdsBackup:
 *     type: alicloud:rds:RdsBackup
 *     name: example
 *     properties:
 *       dbInstanceId: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS Backup can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/rdsBackup:RdsBackup example <db_instance_id>:<backup_id>
 * ```
 */
public class RdsBackup internal constructor(
    override val javaResource: com.pulumi.alicloud.rds.RdsBackup,
) : KotlinCustomResource(javaResource, RdsBackupMapper) {
    /**
     * The backup id.
     */
    public val backupId: Output<String>
        get() = javaResource.backupId().applyValue({ args0 -> args0 })

    /**
     * The type of backup that you want to perform. Default value: `Physical`. Valid values: `Logical`, `Physical` and `Snapshot`.
     */
    public val backupMethod: Output<String>
        get() = javaResource.backupMethod().applyValue({ args0 -> args0 })

    /**
     * The policy that you want to use for the backup task. Valid values:
     * * **db**: specifies to perform a database-level backup.
     * * **instance**: specifies to perform an instance-level backup.
     */
    public val backupStrategy: Output<String>?
        get() = javaResource.backupStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The method that you want to use for the backup task. Default value: `Auto`. Valid values:
     * * **Auto**: specifies to automatically perform a full or incremental backup.
     * * **FullBackup**: specifies to perform a full backup.
     */
    public val backupType: Output<String>
        get() = javaResource.backupType().applyValue({ args0 -> args0 })

    /**
     * The db instance id.
     */
    public val dbInstanceId: Output<String>
        get() = javaResource.dbInstanceId().applyValue({ args0 -> args0 })

    /**
     * The names of the databases whose data you want to back up. Separate the names of the databases with commas (,).
     */
    public val dbName: Output<String>?
        get() = javaResource.dbName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Remove form state when resource cannot be deleted. Valid values: `true` and `false`.
     */
    public val removeFromState: Output<Boolean>?
        get() = javaResource.removeFromState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the data backup file can be deleted. Valid values: `Enabled` and `Disabled`.
     */
    public val storeStatus: Output<String>
        get() = javaResource.storeStatus().applyValue({ args0 -> args0 })
}

public object RdsBackupMapper : ResourceMapper<RdsBackup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rds.RdsBackup::class == javaResource::class

    override fun map(javaResource: Resource): RdsBackup = RdsBackup(
        javaResource as
            com.pulumi.alicloud.rds.RdsBackup,
    )
}

/**
 * @see [RdsBackup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RdsBackup].
 */
public suspend fun rdsBackup(name: String, block: suspend RdsBackupResourceBuilder.() -> Unit): RdsBackup {
    val builder = RdsBackupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RdsBackup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rdsBackup(name: String): RdsBackup {
    val builder = RdsBackupResourceBuilder()
    builder.name(name)
    return builder.build()
}
