@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.RdsBackupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RDS Backup resource.
 * For information about RDS Backup and how to use it, see [What is Backup](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-createbackup).
 * > **NOTE:** Available since v1.149.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.rds.Instance("example", {
 *     engine: "MySQL",
 *     engineVersion: "5.6",
 *     instanceType: "rds.mysql.t1.small",
 *     instanceStorage: 30,
 *     instanceChargeType: "Postpaid",
 *     dbInstanceStorageType: "local_ssd",
 * });
 * const exampleRdsBackup = new alicloud.rds.RdsBackup("example", {dbInstanceId: example.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.rds.Instance("example",
 *     engine="MySQL",
 *     engine_version="5.6",
 *     instance_type="rds.mysql.t1.small",
 *     instance_storage=30,
 *     instance_charge_type="Postpaid",
 *     db_instance_storage_type="local_ssd")
 * example_rds_backup = alicloud.rds.RdsBackup("example", db_instance_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Rds.Instance("example", new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "5.6",
 *         InstanceType = "rds.mysql.t1.small",
 *         InstanceStorage = 30,
 *         InstanceChargeType = "Postpaid",
 *         DbInstanceStorageType = "local_ssd",
 *     });
 *     var exampleRdsBackup = new AliCloud.Rds.RdsBackup("example", new()
 *     {
 *         DbInstanceId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.NewInstance(ctx, "example", &rds.InstanceArgs{
 * 			Engine:                pulumi.String("MySQL"),
 * 			EngineVersion:         pulumi.String("5.6"),
 * 			InstanceType:          pulumi.String("rds.mysql.t1.small"),
 * 			InstanceStorage:       pulumi.Int(30),
 * 			InstanceChargeType:    pulumi.String("Postpaid"),
 * 			DbInstanceStorageType: pulumi.String("local_ssd"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewRdsBackup(ctx, "example", &rds.RdsBackupArgs{
 * 			DbInstanceId: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.Instance;
 * import com.pulumi.alicloud.rds.InstanceArgs;
 * import com.pulumi.alicloud.rds.RdsBackup;
 * import com.pulumi.alicloud.rds.RdsBackupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("5.6")
 *             .instanceType("rds.mysql.t1.small")
 *             .instanceStorage("30")
 *             .instanceChargeType("Postpaid")
 *             .dbInstanceStorageType("local_ssd")
 *             .build());
 *         var exampleRdsBackup = new RdsBackup("exampleRdsBackup", RdsBackupArgs.builder()
 *             .dbInstanceId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:rds:Instance
 *     properties:
 *       engine: MySQL
 *       engineVersion: '5.6'
 *       instanceType: rds.mysql.t1.small
 *       instanceStorage: '30'
 *       instanceChargeType: Postpaid
 *       dbInstanceStorageType: local_ssd
 *   exampleRdsBackup:
 *     type: alicloud:rds:RdsBackup
 *     name: example
 *     properties:
 *       dbInstanceId: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS Backup can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/rdsBackup:RdsBackup example <db_instance_id>:<backup_id>
 * ```
 * @property backupMethod The type of backup that you want to perform. Default value: `Physical`. Valid values: `Logical`, `Physical` and `Snapshot`.
 * @property backupStrategy The policy that you want to use for the backup task. Valid values:
 * * **db**: specifies to perform a database-level backup.
 * * **instance**: specifies to perform an instance-level backup.
 * @property backupType The method that you want to use for the backup task. Default value: `Auto`. Valid values:
 * * **Auto**: specifies to automatically perform a full or incremental backup.
 * * **FullBackup**: specifies to perform a full backup.
 * @property dbInstanceId The db instance id.
 * @property dbName The names of the databases whose data you want to back up. Separate the names of the databases with commas (,).
 * @property removeFromState Remove form state when resource cannot be deleted. Valid values: `true` and `false`.
 */
public data class RdsBackupArgs(
    public val backupMethod: Output<String>? = null,
    public val backupStrategy: Output<String>? = null,
    public val backupType: Output<String>? = null,
    public val dbInstanceId: Output<String>? = null,
    public val dbName: Output<String>? = null,
    public val removeFromState: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.RdsBackupArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.RdsBackupArgs =
        com.pulumi.alicloud.rds.RdsBackupArgs.builder()
            .backupMethod(backupMethod?.applyValue({ args0 -> args0 }))
            .backupStrategy(backupStrategy?.applyValue({ args0 -> args0 }))
            .backupType(backupType?.applyValue({ args0 -> args0 }))
            .dbInstanceId(dbInstanceId?.applyValue({ args0 -> args0 }))
            .dbName(dbName?.applyValue({ args0 -> args0 }))
            .removeFromState(removeFromState?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsBackupArgs].
 */
@PulumiTagMarker
public class RdsBackupArgsBuilder internal constructor() {
    private var backupMethod: Output<String>? = null

    private var backupStrategy: Output<String>? = null

    private var backupType: Output<String>? = null

    private var dbInstanceId: Output<String>? = null

    private var dbName: Output<String>? = null

    private var removeFromState: Output<Boolean>? = null

    /**
     * @param value The type of backup that you want to perform. Default value: `Physical`. Valid values: `Logical`, `Physical` and `Snapshot`.
     */
    @JvmName("edkcjbpaecoectxg")
    public suspend fun backupMethod(`value`: Output<String>) {
        this.backupMethod = value
    }

    /**
     * @param value The policy that you want to use for the backup task. Valid values:
     * * **db**: specifies to perform a database-level backup.
     * * **instance**: specifies to perform an instance-level backup.
     */
    @JvmName("tlgprpiscuflorfb")
    public suspend fun backupStrategy(`value`: Output<String>) {
        this.backupStrategy = value
    }

    /**
     * @param value The method that you want to use for the backup task. Default value: `Auto`. Valid values:
     * * **Auto**: specifies to automatically perform a full or incremental backup.
     * * **FullBackup**: specifies to perform a full backup.
     */
    @JvmName("mhxklxndjtsvkdty")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value The db instance id.
     */
    @JvmName("terugelvkljkgcum")
    public suspend fun dbInstanceId(`value`: Output<String>) {
        this.dbInstanceId = value
    }

    /**
     * @param value The names of the databases whose data you want to back up. Separate the names of the databases with commas (,).
     */
    @JvmName("cbpocctcspvbgrpc")
    public suspend fun dbName(`value`: Output<String>) {
        this.dbName = value
    }

    /**
     * @param value Remove form state when resource cannot be deleted. Valid values: `true` and `false`.
     */
    @JvmName("pgnbyjbllamdyvsm")
    public suspend fun removeFromState(`value`: Output<Boolean>) {
        this.removeFromState = value
    }

    /**
     * @param value The type of backup that you want to perform. Default value: `Physical`. Valid values: `Logical`, `Physical` and `Snapshot`.
     */
    @JvmName("pjhpbjctiqclnaap")
    public suspend fun backupMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupMethod = mapped
    }

    /**
     * @param value The policy that you want to use for the backup task. Valid values:
     * * **db**: specifies to perform a database-level backup.
     * * **instance**: specifies to perform an instance-level backup.
     */
    @JvmName("mrtndokdlubgacvg")
    public suspend fun backupStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupStrategy = mapped
    }

    /**
     * @param value The method that you want to use for the backup task. Default value: `Auto`. Valid values:
     * * **Auto**: specifies to automatically perform a full or incremental backup.
     * * **FullBackup**: specifies to perform a full backup.
     */
    @JvmName("fetpvqsommxjvgve")
    public suspend fun backupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value The db instance id.
     */
    @JvmName("dlmqkvcavavlqnnf")
    public suspend fun dbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceId = mapped
    }

    /**
     * @param value The names of the databases whose data you want to back up. Separate the names of the databases with commas (,).
     */
    @JvmName("esoloksasfvnckhh")
    public suspend fun dbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbName = mapped
    }

    /**
     * @param value Remove form state when resource cannot be deleted. Valid values: `true` and `false`.
     */
    @JvmName("stvfdppgqudatdiw")
    public suspend fun removeFromState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.removeFromState = mapped
    }

    internal fun build(): RdsBackupArgs = RdsBackupArgs(
        backupMethod = backupMethod,
        backupStrategy = backupStrategy,
        backupType = backupType,
        dbInstanceId = dbInstanceId,
        dbName = dbName,
        removeFromState = removeFromState,
    )
}
