@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.RdsCloneDbInstanceArgs.builder
import com.pulumi.alicloud.rds.kotlin.inputs.RdsCloneDbInstanceParameterArgs
import com.pulumi.alicloud.rds.kotlin.inputs.RdsCloneDbInstanceParameterArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.RdsCloneDbInstancePgHbaConfArgs
import com.pulumi.alicloud.rds.kotlin.inputs.RdsCloneDbInstancePgHbaConfArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.RdsCloneDbInstanceServerlessConfigArgs
import com.pulumi.alicloud.rds.kotlin.inputs.RdsCloneDbInstanceServerlessConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an RDS Clone DB Instance resource.
 * For information about RDS Clone DB Instance and how to use it, see [What is ApsaraDB for RDS](https://www.alibabacloud.com/help/en/rds/product-overview/what-is-apsaradb-rds).
 * > **NOTE:** Available since v1.149.0+.
 * ## Example Usage
 * ### Create an RDS MySQL clone instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.rds.getZones({
 *     engine: "PostgreSQL",
 *     engineVersion: "13.0",
 *     instanceChargeType: "PostPaid",
 *     category: "HighAvailability",
 *     dbInstanceStorageType: "cloud_essd",
 * });
 * const exampleGetInstanceClasses = example.then(example => alicloud.rds.getInstanceClasses({
 *     zoneId: example.zones?.[0]?.id,
 *     engine: "PostgreSQL",
 *     engineVersion: "13.0",
 *     category: "HighAvailability",
 *     dbInstanceStorageType: "cloud_essd",
 *     instanceChargeType: "PostPaid",
 * }));
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vpcId: exampleNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: example.then(example => example.zones?.[0]?.id),
 *     vswitchName: "terraform-example",
 * });
 * const exampleInstance = new alicloud.rds.Instance("example", {
 *     engine: "PostgreSQL",
 *     engineVersion: "13.0",
 *     instanceType: exampleGetInstanceClasses.then(exampleGetInstanceClasses => exampleGetInstanceClasses.instanceClasses?.[0]?.instanceClass),
 *     instanceStorage: exampleGetInstanceClasses.then(exampleGetInstanceClasses => exampleGetInstanceClasses.instanceClasses?.[0]?.storageRange?.min),
 *     instanceChargeType: "Postpaid",
 *     instanceName: "terraform-example",
 *     vswitchId: exampleSwitch.id,
 *     monitoringPeriod: 60,
 * });
 * const exampleRdsBackup = new alicloud.rds.RdsBackup("example", {
 *     dbInstanceId: exampleInstance.id,
 *     removeFromState: true,
 * });
 * const exampleRdsCloneDbInstance = new alicloud.rds.RdsCloneDbInstance("example", {
 *     sourceDbInstanceId: exampleInstance.id,
 *     dbInstanceStorageType: "cloud_essd",
 *     paymentType: "PayAsYouGo",
 *     backupId: exampleRdsBackup.backupId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.rds.get_zones(engine="PostgreSQL",
 *     engine_version="13.0",
 *     instance_charge_type="PostPaid",
 *     category="HighAvailability",
 *     db_instance_storage_type="cloud_essd")
 * example_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=example.zones[0].id,
 *     engine="PostgreSQL",
 *     engine_version="13.0",
 *     category="HighAvailability",
 *     db_instance_storage_type="cloud_essd",
 *     instance_charge_type="PostPaid")
 * example_network = alicloud.vpc.Network("example",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/16")
 * example_switch = alicloud.vpc.Switch("example",
 *     vpc_id=example_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=example.zones[0].id,
 *     vswitch_name="terraform-example")
 * example_instance = alicloud.rds.Instance("example",
 *     engine="PostgreSQL",
 *     engine_version="13.0",
 *     instance_type=example_get_instance_classes.instance_classes[0].instance_class,
 *     instance_storage=example_get_instance_classes.instance_classes[0].storage_range.min,
 *     instance_charge_type="Postpaid",
 *     instance_name="terraform-example",
 *     vswitch_id=example_switch.id,
 *     monitoring_period=60)
 * example_rds_backup = alicloud.rds.RdsBackup("example",
 *     db_instance_id=example_instance.id,
 *     remove_from_state=True)
 * example_rds_clone_db_instance = alicloud.rds.RdsCloneDbInstance("example",
 *     source_db_instance_id=example_instance.id,
 *     db_instance_storage_type="cloud_essd",
 *     payment_type="PayAsYouGo",
 *     backup_id=example_rds_backup.backup_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.Rds.GetZones.Invoke(new()
 *     {
 *         Engine = "PostgreSQL",
 *         EngineVersion = "13.0",
 *         InstanceChargeType = "PostPaid",
 *         Category = "HighAvailability",
 *         DbInstanceStorageType = "cloud_essd",
 *     });
 *     var exampleGetInstanceClasses = AliCloud.Rds.GetInstanceClasses.Invoke(new()
 *     {
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         Engine = "PostgreSQL",
 *         EngineVersion = "13.0",
 *         Category = "HighAvailability",
 *         DbInstanceStorageType = "cloud_essd",
 *         InstanceChargeType = "PostPaid",
 *     });
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VpcId = exampleNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         VswitchName = "terraform-example",
 *     });
 *     var exampleInstance = new AliCloud.Rds.Instance("example", new()
 *     {
 *         Engine = "PostgreSQL",
 *         EngineVersion = "13.0",
 *         InstanceType = exampleGetInstanceClasses.Apply(getInstanceClassesResult => getInstanceClassesResult.InstanceClasses[0]?.InstanceClass),
 *         InstanceStorage = exampleGetInstanceClasses.Apply(getInstanceClassesResult => getInstanceClassesResult.InstanceClasses[0]?.StorageRange?.Min),
 *         InstanceChargeType = "Postpaid",
 *         InstanceName = "terraform-example",
 *         VswitchId = exampleSwitch.Id,
 *         MonitoringPeriod = 60,
 *     });
 *     var exampleRdsBackup = new AliCloud.Rds.RdsBackup("example", new()
 *     {
 *         DbInstanceId = exampleInstance.Id,
 *         RemoveFromState = true,
 *     });
 *     var exampleRdsCloneDbInstance = new AliCloud.Rds.RdsCloneDbInstance("example", new()
 *     {
 *         SourceDbInstanceId = exampleInstance.Id,
 *         DbInstanceStorageType = "cloud_essd",
 *         PaymentType = "PayAsYouGo",
 *         BackupId = exampleRdsBackup.BackupId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.GetZones(ctx, &rds.GetZonesArgs{
 * 			Engine:                pulumi.StringRef("PostgreSQL"),
 * 			EngineVersion:         pulumi.StringRef("13.0"),
 * 			InstanceChargeType:    pulumi.StringRef("PostPaid"),
 * 			Category:              pulumi.StringRef("HighAvailability"),
 * 			DbInstanceStorageType: pulumi.StringRef("cloud_essd"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetInstanceClasses, err := rds.GetInstanceClasses(ctx, &rds.GetInstanceClassesArgs{
 * 			ZoneId:                pulumi.StringRef(example.Zones[0].Id),
 * 			Engine:                pulumi.StringRef("PostgreSQL"),
 * 			EngineVersion:         pulumi.StringRef("13.0"),
 * 			Category:              pulumi.StringRef("HighAvailability"),
 * 			DbInstanceStorageType: pulumi.StringRef("cloud_essd"),
 * 			InstanceChargeType:    pulumi.StringRef("PostPaid"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VpcId:       exampleNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(example.Zones[0].Id),
 * 			VswitchName: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := rds.NewInstance(ctx, "example", &rds.InstanceArgs{
 * 			Engine:             pulumi.String("PostgreSQL"),
 * 			EngineVersion:      pulumi.String("13.0"),
 * 			InstanceType:       pulumi.String(exampleGetInstanceClasses.InstanceClasses[0].InstanceClass),
 * 			InstanceStorage:    pulumi.String(exampleGetInstanceClasses.InstanceClasses[0].StorageRange.Min),
 * 			InstanceChargeType: pulumi.String("Postpaid"),
 * 			InstanceName:       pulumi.String("terraform-example"),
 * 			VswitchId:          exampleSwitch.ID(),
 * 			MonitoringPeriod:   pulumi.Int(60),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRdsBackup, err := rds.NewRdsBackup(ctx, "example", &rds.RdsBackupArgs{
 * 			DbInstanceId:    exampleInstance.ID(),
 * 			RemoveFromState: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewRdsCloneDbInstance(ctx, "example", &rds.RdsCloneDbInstanceArgs{
 * 			SourceDbInstanceId:    exampleInstance.ID(),
 * 			DbInstanceStorageType: pulumi.String("cloud_essd"),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 			BackupId:              exampleRdsBackup.BackupId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.RdsFunctions;
 * import com.pulumi.alicloud.rds.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.rds.inputs.GetInstanceClassesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.rds.Instance;
 * import com.pulumi.alicloud.rds.InstanceArgs;
 * import com.pulumi.alicloud.rds.RdsBackup;
 * import com.pulumi.alicloud.rds.RdsBackupArgs;
 * import com.pulumi.alicloud.rds.RdsCloneDbInstance;
 * import com.pulumi.alicloud.rds.RdsCloneDbInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = RdsFunctions.getZones(GetZonesArgs.builder()
 *             .engine("PostgreSQL")
 *             .engineVersion("13.0")
 *             .instanceChargeType("PostPaid")
 *             .category("HighAvailability")
 *             .dbInstanceStorageType("cloud_essd")
 *             .build());
 *         final var exampleGetInstanceClasses = RdsFunctions.getInstanceClasses(GetInstanceClassesArgs.builder()
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .engine("PostgreSQL")
 *             .engineVersion("13.0")
 *             .category("HighAvailability")
 *             .dbInstanceStorageType("cloud_essd")
 *             .instanceChargeType("PostPaid")
 *             .build());
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vpcId(exampleNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .vswitchName("terraform-example")
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .engine("PostgreSQL")
 *             .engineVersion("13.0")
 *             .instanceType(exampleGetInstanceClasses.applyValue(getInstanceClassesResult -> getInstanceClassesResult.instanceClasses()[0].instanceClass()))
 *             .instanceStorage(exampleGetInstanceClasses.applyValue(getInstanceClassesResult -> getInstanceClassesResult.instanceClasses()[0].storageRange().min()))
 *             .instanceChargeType("Postpaid")
 *             .instanceName("terraform-example")
 *             .vswitchId(exampleSwitch.id())
 *             .monitoringPeriod("60")
 *             .build());
 *         var exampleRdsBackup = new RdsBackup("exampleRdsBackup", RdsBackupArgs.builder()
 *             .dbInstanceId(exampleInstance.id())
 *             .removeFromState("true")
 *             .build());
 *         var exampleRdsCloneDbInstance = new RdsCloneDbInstance("exampleRdsCloneDbInstance", RdsCloneDbInstanceArgs.builder()
 *             .sourceDbInstanceId(exampleInstance.id())
 *             .dbInstanceStorageType("cloud_essd")
 *             .paymentType("PayAsYouGo")
 *             .backupId(exampleRdsBackup.backupId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/16
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vpcId: ${exampleNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${example.zones[0].id}
 *       vswitchName: terraform-example
 *   exampleInstance:
 *     type: alicloud:rds:Instance
 *     name: example
 *     properties:
 *       engine: PostgreSQL
 *       engineVersion: '13.0'
 *       instanceType: ${exampleGetInstanceClasses.instanceClasses[0].instanceClass}
 *       instanceStorage: ${exampleGetInstanceClasses.instanceClasses[0].storageRange.min}
 *       instanceChargeType: Postpaid
 *       instanceName: terraform-example
 *       vswitchId: ${exampleSwitch.id}
 *       monitoringPeriod: '60'
 *   exampleRdsBackup:
 *     type: alicloud:rds:RdsBackup
 *     name: example
 *     properties:
 *       dbInstanceId: ${exampleInstance.id}
 *       removeFromState: 'true'
 *   exampleRdsCloneDbInstance:
 *     type: alicloud:rds:RdsCloneDbInstance
 *     name: example
 *     properties:
 *       sourceDbInstanceId: ${exampleInstance.id}
 *       dbInstanceStorageType: cloud_essd
 *       paymentType: PayAsYouGo
 *       backupId: ${exampleRdsBackup.backupId}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:rds:getZones
 *       Arguments:
 *         engine: PostgreSQL
 *         engineVersion: '13.0'
 *         instanceChargeType: PostPaid
 *         category: HighAvailability
 *         dbInstanceStorageType: cloud_essd
 *   exampleGetInstanceClasses:
 *     fn::invoke:
 *       Function: alicloud:rds:getInstanceClasses
 *       Arguments:
 *         zoneId: ${example.zones[0].id}
 *         engine: PostgreSQL
 *         engineVersion: '13.0'
 *         category: HighAvailability
 *         dbInstanceStorageType: cloud_essd
 *         instanceChargeType: PostPaid
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS Clone DB Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/rdsCloneDbInstance:RdsCloneDbInstance example <id>
 * ```
 * @property acl This parameter is only supported by the RDS PostgreSQL cloud disk version. This parameter indicates the authentication method. It is allowed only when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
 * @property autoUpgradeMinorVersion How to upgrade the minor version of the instance. Valid values:
 * * **Auto**: automatically upgrade the minor version.
 * * **Manual**: It is not automatically upgraded. It is only mandatory when the current version is offline.
 * @property backupId The ID of the data backup file you want to use. You can call the DescribeBackups operation to query the most recent data backup file list.
 * > **NOTE:** You must specify at least one of the BackupId and RestoreTime parameters. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
 * @property backupType The type of backup that is used to restore the data of the original instance. Valid values:
 * * **FullBackup**: full backup
 * * **IncrementalBackup**: incremental backup
 * @property caType This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the certificate type. When the value of ssl_action is Open, the default value of this parameter is aliyun. Value range:
 * * **aliyun**: using cloud certificates
 * * **custom**: use a custom certificate. Valid values: `aliyun`, `custom`.
 * @property category Instance series. Valid values:
 * * **Basic**: Basic Edition
 * * **HighAvailability**: High availability
 * * **AlwaysOn**: Cluster Edition
 * * **Finance**: Three-node Enterprise Edition.
 * * **serverless_basic**: Serverless Basic Edition. (Available in 1.200.0+)
 * * **serverless_standard**: MySQL Serverless High Availability Edition. (Available in 1.207.0+)
 * * **serverless_ha**: SQLServer Serverless High Availability Edition. (Available in 1.207.0+)
 * * **cluster**: MySQL Cluster Edition. (Available in 1.207.0+)
 * @property certificate The file that contains the certificate used for TDE.
 * @property clientCaCert This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the public key of the client certification authority. If the value of client_ca_enabled is 1, this parameter must be configured.
 * @property clientCaEnabled The client ca enabled.
 * @property clientCertRevocationList This parameter is only supported by the RDS PostgreSQL cloud disk version, which indicates that the client revokes the certificate file. If the value of client_crl_enabled is 1, this parameter must be configured.
 * @property clientCrlEnabled The client crl enabled.
 * @property connectionStringPrefix The connection string prefix.
 * @property dbInstanceClass The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
 * @property dbInstanceDescription The db instance description.
 * @property dbInstanceStorage The storage capacity of the new instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
 * > **NOTE:** The default value of this parameter is the storage capacity of the original instance.
 * @property dbInstanceStorageType The type of storage media that is used for the new instance. Valid values:
 * * **local_ssd**: local SSDs
 * * **cloud_ssd**: standard SSDs
 * * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1)
 * * **cloud_essd2**: ESSDs of PL2
 * * **cloud_essd3**: ESSDs of PL3
 * @property dbName The name of the database for which you want to enable TDE. Up to 50 names can be entered in a single request. If you specify multiple names, separate these names with commas (,).
 * > **NOTE:** This parameter is available and must be specified only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
 * @property dbNames The names of the databases that you want to create on the new instance.
 * @property dedicatedHostGroupId The ID of the dedicated cluster to which the new instance belongs. This parameter takes effect only when you create the new instance in a dedicated cluster.
 * @property deletionProtection The switch of delete protection. Valid values:
 * - true: delete protect.
 * - false: no delete protect.
 * > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
 * @property direction The direction. Valid values: `Auto`, `Down`, `TempUpgrade`, `Up`.
 * @property effectiveTime The effective time.
 * @property encryptionKey The ID of the private key.
 * > **NOTE:** This parameter is available only when the instance runs MySQL.
 * @property engine Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
 * @property engineVersion Database version. Value:
 * * MySQL:**5.5/5.6/5.7/8.0**
 * * SQL Server:**2008r2/08r2_ent_ha/2012/2012_ent_ha/2012_std_ha/2012_web/2014_std_ha/2016_ent_ha/2016_std_ha/2016_web/2017_std_ha/2017_ent/2019_std_ha/2019_ent**
 * * PostgreSQL:**9.4/10.0/11.0/12.0/13.0**
 * * MariaDB:**10.3**.
 * @property forceRestart Set it to true to make some parameter efficient when modifying them. Default to false.
 * @property haMode The high availability mode. Valid values:
 * * **RPO**: Data persistence is preferred. The instance preferentially ensures data reliability to minimize data loss. Use this mode if you have higher requirements on data consistency.
 * * **RTO**: Instance availability is preferred. The instance restores services as soon as possible to ensure availability. Use this mode if you have higher requirements on service availability.
 * @property instanceNetworkType The network type of the instance. Valid values:
 * * **Classic**: Classic Network
 * * **VPC**: VPC.
 * @property maintainTime The maintainable time period of the instance. Format: <I> HH:mm</I> Z-<I> HH:mm</I> Z(UTC time).
 * @property parameters Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm).See `parameters` below.
 * @property password The password of the certificate.
 * > **NOTE:** This parameter is available only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
 * @property paymentType The billing method of the new instance. Valid values: `PayAsYouGo` and `Subscription` and `Serverless`.
 * @property period The period. Valid values: `Month`, `Year`.
 * > **NOTE:** If you set the payment_type parameter to Subscription, you must specify the period parameter.
 * @property pgHbaConfs The details of the AD domain.See `pg_hba_conf` below.
 * @property port The port.
 * @property privateIpAddress The intranet IP address of the new instance must be within the specified vSwitch IP address range. By default, the system automatically allocates by using **VPCId** and **VSwitchId**.
 * @property privateKey The file that contains the private key used for TDE.
 * @property releasedKeepPolicy The released keep policy.
 * @property replicationAcl This parameter is only supported by the RDS PostgreSQL cloud disk version, indicating the authentication method of the replication permission. It is only allowed when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
 * @property resourceGroupId The resource group id.
 * @property restoreTable Specifies whether to restore only the databases and tables that you specify. The value 1 specifies to restore only the specified databases and tables. If you do not want to restore only the specified databases or tables, you can choose not to specify this parameter.
 * @property restoreTime The point in time to which you want to restore the data of the original instance. The point in time must fall within the specified log backup retention period. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
 * @property roleArn The Alibaba Cloud Resource Name (ARN) of a RAM role. A RAM role is a virtual RAM identity that you can create within your Alibaba Cloud account.
 * > **NOTE:** This parameter is available only when the instance runs MySQL.
 * @property securityIps The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
 * * IP address form, for example: 10.23.12.24.
 * * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).
 * > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
 * @property serverCert This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the content of the server certificate. If the CAType value is custom, this parameter must be configured.
 * @property serverKey This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the private key of the server certificate. If the value of CAType is custom, this parameter must be configured.
 * @property serverlessConfigs The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for MySQL instance.See `serverless_config` below.
 * @property sourceBiz The source biz.
 * @property sourceDbInstanceId The source db instance id.
 * @property sslEnabled Enable or disable SSL. Valid values: `0` and `1`.
 * @property switchTime The time at which you want to apply the specification changes. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
 * @property syncMode [The data replication mode](https://www.alibabacloud.com/help/doc-detail/96055.htm). Valid values:
 * * **Sync**: strong synchronization
 * * **Semi-sync**: Semi-synchronous
 * * **Async**: asynchronous
 * > **NOTE:** SQL Server 2017 cluster version is currently not supported.
 * @property tableMeta The information about the databases and tables that you want to restore. Format:
 * [{"type":"db","name":"The original name of Database 1","newname":"The new name of Database 1","tables":[{"type":"table","name":"The original name of Table 1 in Database 1","newname":"The new name of Table 1 in Database 1"},{"type":"table","name":"The original name of Table 2 in Database 1","newname":"The new name of Table 2 in Database 1"}]},{"type":"db","name":"The original name of Database 2","newname":"The new name of Database 2","tables":[{"type":"table","name":"The original name of Table 1 in Database 2","newname":"The new name of Table 1 in Database 2"},{"type":"table","name":"The original name of Table 2 in Database 2","newname":"The new name of Table 2 in Database 2"}]}]
 * @property tcpConnectionType The availability check method of the instance. Valid values:
 * - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
 * - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
 * @property tdeStatus Specifies whether to enable TDE. Valid values:
 * * Enabled
 * * Disabled
 * @property usedTime The subscription period of the new instance. This parameter takes effect only when you select the subscription billing method for the new instance. Valid values:
 * * If you set the `Period` parameter to Year, the value of the UsedTime parameter ranges from 1 to 3.
 * * If you set the `Period` parameter to Month, the value of the UsedTime parameter ranges from 1 to 9.
 * > **NOTE:** If you set the payment_type parameter to Subscription, you must specify the used_time parameter.
 * @property vpcId The ID of the VPC to which the new instance belongs.
 * > **NOTE:** Make sure that the VPC resides in the specified region.
 * @property vswitchId The ID of the vSwitch associated with the specified VPC. If there are multiple vswitches, separate them with commas. The first vswitch is a primary zone switch and the query only returns that vswitch. If there are multiple vswitches, do not perform `vswitch_id` check.
 * > **NOTE:** Make sure that the vSwitch belongs to the specified VPC and region.
 * @property zoneId The ID of the zone to which the new instance belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query the most recent region list.
 * @property zoneIdSlaveA The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
 * @property zoneIdSlaveB The region ID of the log instance if you create a log instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
 * > **NOTE:** The default value of this parameter is the ID of the zone to which the original instance belongs.
 */
public data class RdsCloneDbInstanceArgs(
    public val acl: Output<String>? = null,
    public val autoUpgradeMinorVersion: Output<String>? = null,
    public val backupId: Output<String>? = null,
    public val backupType: Output<String>? = null,
    public val caType: Output<String>? = null,
    public val category: Output<String>? = null,
    public val certificate: Output<String>? = null,
    public val clientCaCert: Output<String>? = null,
    public val clientCaEnabled: Output<Int>? = null,
    public val clientCertRevocationList: Output<String>? = null,
    public val clientCrlEnabled: Output<Int>? = null,
    public val connectionStringPrefix: Output<String>? = null,
    public val dbInstanceClass: Output<String>? = null,
    public val dbInstanceDescription: Output<String>? = null,
    public val dbInstanceStorage: Output<Int>? = null,
    public val dbInstanceStorageType: Output<String>? = null,
    public val dbName: Output<String>? = null,
    public val dbNames: Output<String>? = null,
    public val dedicatedHostGroupId: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val direction: Output<String>? = null,
    public val effectiveTime: Output<String>? = null,
    public val encryptionKey: Output<String>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val forceRestart: Output<Boolean>? = null,
    public val haMode: Output<String>? = null,
    public val instanceNetworkType: Output<String>? = null,
    public val maintainTime: Output<String>? = null,
    public val parameters: Output<List<RdsCloneDbInstanceParameterArgs>>? = null,
    public val password: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<String>? = null,
    public val pgHbaConfs: Output<List<RdsCloneDbInstancePgHbaConfArgs>>? = null,
    public val port: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val privateKey: Output<String>? = null,
    public val releasedKeepPolicy: Output<String>? = null,
    public val replicationAcl: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val restoreTable: Output<String>? = null,
    public val restoreTime: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val securityIps: Output<List<String>>? = null,
    public val serverCert: Output<String>? = null,
    public val serverKey: Output<String>? = null,
    public val serverlessConfigs: Output<List<RdsCloneDbInstanceServerlessConfigArgs>>? = null,
    public val sourceBiz: Output<String>? = null,
    public val sourceDbInstanceId: Output<String>? = null,
    public val sslEnabled: Output<Int>? = null,
    public val switchTime: Output<String>? = null,
    public val syncMode: Output<String>? = null,
    public val tableMeta: Output<String>? = null,
    public val tcpConnectionType: Output<String>? = null,
    public val tdeStatus: Output<String>? = null,
    public val usedTime: Output<Int>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
    public val zoneIdSlaveA: Output<String>? = null,
    public val zoneIdSlaveB: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.RdsCloneDbInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.RdsCloneDbInstanceArgs =
        com.pulumi.alicloud.rds.RdsCloneDbInstanceArgs.builder()
            .acl(acl?.applyValue({ args0 -> args0 }))
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .backupId(backupId?.applyValue({ args0 -> args0 }))
            .backupType(backupType?.applyValue({ args0 -> args0 }))
            .caType(caType?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .clientCaCert(clientCaCert?.applyValue({ args0 -> args0 }))
            .clientCaEnabled(clientCaEnabled?.applyValue({ args0 -> args0 }))
            .clientCertRevocationList(clientCertRevocationList?.applyValue({ args0 -> args0 }))
            .clientCrlEnabled(clientCrlEnabled?.applyValue({ args0 -> args0 }))
            .connectionStringPrefix(connectionStringPrefix?.applyValue({ args0 -> args0 }))
            .dbInstanceClass(dbInstanceClass?.applyValue({ args0 -> args0 }))
            .dbInstanceDescription(dbInstanceDescription?.applyValue({ args0 -> args0 }))
            .dbInstanceStorage(dbInstanceStorage?.applyValue({ args0 -> args0 }))
            .dbInstanceStorageType(dbInstanceStorageType?.applyValue({ args0 -> args0 }))
            .dbName(dbName?.applyValue({ args0 -> args0 }))
            .dbNames(dbNames?.applyValue({ args0 -> args0 }))
            .dedicatedHostGroupId(dedicatedHostGroupId?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .direction(direction?.applyValue({ args0 -> args0 }))
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .forceRestart(forceRestart?.applyValue({ args0 -> args0 }))
            .haMode(haMode?.applyValue({ args0 -> args0 }))
            .instanceNetworkType(instanceNetworkType?.applyValue({ args0 -> args0 }))
            .maintainTime(maintainTime?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .password(password?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .pgHbaConfs(
                pgHbaConfs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 }))
            .releasedKeepPolicy(releasedKeepPolicy?.applyValue({ args0 -> args0 }))
            .replicationAcl(replicationAcl?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .restoreTable(restoreTable?.applyValue({ args0 -> args0 }))
            .restoreTime(restoreTime?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .securityIps(securityIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serverCert(serverCert?.applyValue({ args0 -> args0 }))
            .serverKey(serverKey?.applyValue({ args0 -> args0 }))
            .serverlessConfigs(
                serverlessConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceBiz(sourceBiz?.applyValue({ args0 -> args0 }))
            .sourceDbInstanceId(sourceDbInstanceId?.applyValue({ args0 -> args0 }))
            .sslEnabled(sslEnabled?.applyValue({ args0 -> args0 }))
            .switchTime(switchTime?.applyValue({ args0 -> args0 }))
            .syncMode(syncMode?.applyValue({ args0 -> args0 }))
            .tableMeta(tableMeta?.applyValue({ args0 -> args0 }))
            .tcpConnectionType(tcpConnectionType?.applyValue({ args0 -> args0 }))
            .tdeStatus(tdeStatus?.applyValue({ args0 -> args0 }))
            .usedTime(usedTime?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 }))
            .zoneIdSlaveA(zoneIdSlaveA?.applyValue({ args0 -> args0 }))
            .zoneIdSlaveB(zoneIdSlaveB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsCloneDbInstanceArgs].
 */
@PulumiTagMarker
public class RdsCloneDbInstanceArgsBuilder internal constructor() {
    private var acl: Output<String>? = null

    private var autoUpgradeMinorVersion: Output<String>? = null

    private var backupId: Output<String>? = null

    private var backupType: Output<String>? = null

    private var caType: Output<String>? = null

    private var category: Output<String>? = null

    private var certificate: Output<String>? = null

    private var clientCaCert: Output<String>? = null

    private var clientCaEnabled: Output<Int>? = null

    private var clientCertRevocationList: Output<String>? = null

    private var clientCrlEnabled: Output<Int>? = null

    private var connectionStringPrefix: Output<String>? = null

    private var dbInstanceClass: Output<String>? = null

    private var dbInstanceDescription: Output<String>? = null

    private var dbInstanceStorage: Output<Int>? = null

    private var dbInstanceStorageType: Output<String>? = null

    private var dbName: Output<String>? = null

    private var dbNames: Output<String>? = null

    private var dedicatedHostGroupId: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var direction: Output<String>? = null

    private var effectiveTime: Output<String>? = null

    private var encryptionKey: Output<String>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var forceRestart: Output<Boolean>? = null

    private var haMode: Output<String>? = null

    private var instanceNetworkType: Output<String>? = null

    private var maintainTime: Output<String>? = null

    private var parameters: Output<List<RdsCloneDbInstanceParameterArgs>>? = null

    private var password: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<String>? = null

    private var pgHbaConfs: Output<List<RdsCloneDbInstancePgHbaConfArgs>>? = null

    private var port: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var privateKey: Output<String>? = null

    private var releasedKeepPolicy: Output<String>? = null

    private var replicationAcl: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var restoreTable: Output<String>? = null

    private var restoreTime: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var securityIps: Output<List<String>>? = null

    private var serverCert: Output<String>? = null

    private var serverKey: Output<String>? = null

    private var serverlessConfigs: Output<List<RdsCloneDbInstanceServerlessConfigArgs>>? = null

    private var sourceBiz: Output<String>? = null

    private var sourceDbInstanceId: Output<String>? = null

    private var sslEnabled: Output<Int>? = null

    private var switchTime: Output<String>? = null

    private var syncMode: Output<String>? = null

    private var tableMeta: Output<String>? = null

    private var tcpConnectionType: Output<String>? = null

    private var tdeStatus: Output<String>? = null

    private var usedTime: Output<Int>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    private var zoneIdSlaveA: Output<String>? = null

    private var zoneIdSlaveB: Output<String>? = null

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version. This parameter indicates the authentication method. It is allowed only when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
     */
    @JvmName("sujdvaoocojjvmvq")
    public suspend fun acl(`value`: Output<String>) {
        this.acl = value
    }

    /**
     * @param value How to upgrade the minor version of the instance. Valid values:
     * * **Auto**: automatically upgrade the minor version.
     * * **Manual**: It is not automatically upgraded. It is only mandatory when the current version is offline.
     */
    @JvmName("qrepxytwvjudjoiv")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<String>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value The ID of the data backup file you want to use. You can call the DescribeBackups operation to query the most recent data backup file list.
     * > **NOTE:** You must specify at least one of the BackupId and RestoreTime parameters. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
     */
    @JvmName("jkcrqbrfxdaxkxbs")
    public suspend fun backupId(`value`: Output<String>) {
        this.backupId = value
    }

    /**
     * @param value The type of backup that is used to restore the data of the original instance. Valid values:
     * * **FullBackup**: full backup
     * * **IncrementalBackup**: incremental backup
     */
    @JvmName("wihuredjhmbrpowd")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the certificate type. When the value of ssl_action is Open, the default value of this parameter is aliyun. Value range:
     * * **aliyun**: using cloud certificates
     * * **custom**: use a custom certificate. Valid values: `aliyun`, `custom`.
     */
    @JvmName("pqqqrhvggfwmeisj")
    public suspend fun caType(`value`: Output<String>) {
        this.caType = value
    }

    /**
     * @param value Instance series. Valid values:
     * * **Basic**: Basic Edition
     * * **HighAvailability**: High availability
     * * **AlwaysOn**: Cluster Edition
     * * **Finance**: Three-node Enterprise Edition.
     * * **serverless_basic**: Serverless Basic Edition. (Available in 1.200.0+)
     * * **serverless_standard**: MySQL Serverless High Availability Edition. (Available in 1.207.0+)
     * * **serverless_ha**: SQLServer Serverless High Availability Edition. (Available in 1.207.0+)
     * * **cluster**: MySQL Cluster Edition. (Available in 1.207.0+)
     */
    @JvmName("fsmsytmxuabedqll")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The file that contains the certificate used for TDE.
     */
    @JvmName("jsfhmbsmolrpfxwr")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the public key of the client certification authority. If the value of client_ca_enabled is 1, this parameter must be configured.
     */
    @JvmName("rdujdmumspbrswex")
    public suspend fun clientCaCert(`value`: Output<String>) {
        this.clientCaCert = value
    }

    /**
     * @param value The client ca enabled.
     */
    @JvmName("vjldqqvjxnemvyqu")
    public suspend fun clientCaEnabled(`value`: Output<Int>) {
        this.clientCaEnabled = value
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version, which indicates that the client revokes the certificate file. If the value of client_crl_enabled is 1, this parameter must be configured.
     */
    @JvmName("uginmsixoebsiseq")
    public suspend fun clientCertRevocationList(`value`: Output<String>) {
        this.clientCertRevocationList = value
    }

    /**
     * @param value The client crl enabled.
     */
    @JvmName("ymsthvvtprkaieuo")
    public suspend fun clientCrlEnabled(`value`: Output<Int>) {
        this.clientCrlEnabled = value
    }

    /**
     * @param value The connection string prefix.
     */
    @JvmName("mluvehwuvtfdkyfd")
    public suspend fun connectionStringPrefix(`value`: Output<String>) {
        this.connectionStringPrefix = value
    }

    /**
     * @param value The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
     */
    @JvmName("appeqmrmtlofeyql")
    public suspend fun dbInstanceClass(`value`: Output<String>) {
        this.dbInstanceClass = value
    }

    /**
     * @param value The db instance description.
     */
    @JvmName("aotkhgmofjdkdgmy")
    public suspend fun dbInstanceDescription(`value`: Output<String>) {
        this.dbInstanceDescription = value
    }

    /**
     * @param value The storage capacity of the new instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
     * > **NOTE:** The default value of this parameter is the storage capacity of the original instance.
     */
    @JvmName("ixjphmuglviwxmll")
    public suspend fun dbInstanceStorage(`value`: Output<Int>) {
        this.dbInstanceStorage = value
    }

    /**
     * @param value The type of storage media that is used for the new instance. Valid values:
     * * **local_ssd**: local SSDs
     * * **cloud_ssd**: standard SSDs
     * * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1)
     * * **cloud_essd2**: ESSDs of PL2
     * * **cloud_essd3**: ESSDs of PL3
     */
    @JvmName("timwpoyebfucoqnb")
    public suspend fun dbInstanceStorageType(`value`: Output<String>) {
        this.dbInstanceStorageType = value
    }

    /**
     * @param value The name of the database for which you want to enable TDE. Up to 50 names can be entered in a single request. If you specify multiple names, separate these names with commas (,).
     * > **NOTE:** This parameter is available and must be specified only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
     */
    @JvmName("atokppwqsrkkpwfv")
    public suspend fun dbName(`value`: Output<String>) {
        this.dbName = value
    }

    /**
     * @param value The names of the databases that you want to create on the new instance.
     */
    @JvmName("ibwfaesvtttqypmq")
    public suspend fun dbNames(`value`: Output<String>) {
        this.dbNames = value
    }

    /**
     * @param value The ID of the dedicated cluster to which the new instance belongs. This parameter takes effect only when you create the new instance in a dedicated cluster.
     */
    @JvmName("qssvbssudahtgxjp")
    public suspend fun dedicatedHostGroupId(`value`: Output<String>) {
        this.dedicatedHostGroupId = value
    }

    /**
     * @param value The switch of delete protection. Valid values:
     * - true: delete protect.
     * - false: no delete protect.
     * > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
     */
    @JvmName("vscoyxlqlrhmomaq")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value The direction. Valid values: `Auto`, `Down`, `TempUpgrade`, `Up`.
     */
    @JvmName("xnwrccmjvhnwbelh")
    public suspend fun direction(`value`: Output<String>) {
        this.direction = value
    }

    /**
     * @param value The effective time.
     */
    @JvmName("qlrnxmsleualhaea")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value The ID of the private key.
     * > **NOTE:** This parameter is available only when the instance runs MySQL.
     */
    @JvmName("mksxnuipunhnqngk")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
     */
    @JvmName("itslkdnwlbgurpak")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value Database version. Value:
     * * MySQL:**5.5/5.6/5.7/8.0**
     * * SQL Server:**2008r2/08r2_ent_ha/2012/2012_ent_ha/2012_std_ha/2012_web/2014_std_ha/2016_ent_ha/2016_std_ha/2016_web/2017_std_ha/2017_ent/2019_std_ha/2019_ent**
     * * PostgreSQL:**9.4/10.0/11.0/12.0/13.0**
     * * MariaDB:**10.3**.
     */
    @JvmName("ixpxtrruorkqklpu")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Set it to true to make some parameter efficient when modifying them. Default to false.
     */
    @JvmName("xqxtimihtgwgubud")
    public suspend fun forceRestart(`value`: Output<Boolean>) {
        this.forceRestart = value
    }

    /**
     * @param value The high availability mode. Valid values:
     * * **RPO**: Data persistence is preferred. The instance preferentially ensures data reliability to minimize data loss. Use this mode if you have higher requirements on data consistency.
     * * **RTO**: Instance availability is preferred. The instance restores services as soon as possible to ensure availability. Use this mode if you have higher requirements on service availability.
     */
    @JvmName("ihchyrnsmyumqqdn")
    public suspend fun haMode(`value`: Output<String>) {
        this.haMode = value
    }

    /**
     * @param value The network type of the instance. Valid values:
     * * **Classic**: Classic Network
     * * **VPC**: VPC.
     */
    @JvmName("ietclncssqwawiya")
    public suspend fun instanceNetworkType(`value`: Output<String>) {
        this.instanceNetworkType = value
    }

    /**
     * @param value The maintainable time period of the instance. Format: <I> HH:mm</I> Z-<I> HH:mm</I> Z(UTC time).
     */
    @JvmName("enedfnyrvfbctfum")
    public suspend fun maintainTime(`value`: Output<String>) {
        this.maintainTime = value
    }

    /**
     * @param value Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm).See `parameters` below.
     */
    @JvmName("kfutldedkcksrslq")
    public suspend fun parameters(`value`: Output<List<RdsCloneDbInstanceParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("igdsyfdnvakpksxr")
    public suspend fun parameters(vararg values: Output<RdsCloneDbInstanceParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm).See `parameters` below.
     */
    @JvmName("hihccxfaietghbml")
    public suspend fun parameters(values: List<Output<RdsCloneDbInstanceParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The password of the certificate.
     * > **NOTE:** This parameter is available only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
     */
    @JvmName("ydautyfsspwrwfql")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The billing method of the new instance. Valid values: `PayAsYouGo` and `Subscription` and `Serverless`.
     */
    @JvmName("dwjlbakixsbpcrmi")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The period. Valid values: `Month`, `Year`.
     * > **NOTE:** If you set the payment_type parameter to Subscription, you must specify the period parameter.
     */
    @JvmName("dddcqofabvheuijs")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value The details of the AD domain.See `pg_hba_conf` below.
     */
    @JvmName("mnqxjqilvfbwcfop")
    public suspend fun pgHbaConfs(`value`: Output<List<RdsCloneDbInstancePgHbaConfArgs>>) {
        this.pgHbaConfs = value
    }

    @JvmName("pipbwphqfgfehsej")
    public suspend fun pgHbaConfs(vararg values: Output<RdsCloneDbInstancePgHbaConfArgs>) {
        this.pgHbaConfs = Output.all(values.asList())
    }

    /**
     * @param values The details of the AD domain.See `pg_hba_conf` below.
     */
    @JvmName("esrllooigcxgebcf")
    public suspend fun pgHbaConfs(values: List<Output<RdsCloneDbInstancePgHbaConfArgs>>) {
        this.pgHbaConfs = Output.all(values)
    }

    /**
     * @param value The port.
     */
    @JvmName("axyaygiitiaxmggk")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value The intranet IP address of the new instance must be within the specified vSwitch IP address range. By default, the system automatically allocates by using **VPCId** and **VSwitchId**.
     */
    @JvmName("imswmcqfqpytaahv")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value The file that contains the private key used for TDE.
     */
    @JvmName("fxsrdlhgagduwkfq")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value The released keep policy.
     */
    @JvmName("koiyifhjnovasumq")
    public suspend fun releasedKeepPolicy(`value`: Output<String>) {
        this.releasedKeepPolicy = value
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version, indicating the authentication method of the replication permission. It is only allowed when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
     */
    @JvmName("tepkcchtwjdmyfmu")
    public suspend fun replicationAcl(`value`: Output<String>) {
        this.replicationAcl = value
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("owwcwafqsgbjcmkd")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Specifies whether to restore only the databases and tables that you specify. The value 1 specifies to restore only the specified databases and tables. If you do not want to restore only the specified databases or tables, you can choose not to specify this parameter.
     */
    @JvmName("subfpwsedfiwpelb")
    public suspend fun restoreTable(`value`: Output<String>) {
        this.restoreTable = value
    }

    /**
     * @param value The point in time to which you want to restore the data of the original instance. The point in time must fall within the specified log backup retention period. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     */
    @JvmName("wgwbutqoavcvohra")
    public suspend fun restoreTime(`value`: Output<String>) {
        this.restoreTime = value
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of a RAM role. A RAM role is a virtual RAM identity that you can create within your Alibaba Cloud account.
     * > **NOTE:** This parameter is available only when the instance runs MySQL.
     */
    @JvmName("ecdxnjmklkpuuqlr")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
     * * IP address form, for example: 10.23.12.24.
     * * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).
     * > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
     */
    @JvmName("oadetcyqxotisase")
    public suspend fun securityIps(`value`: Output<List<String>>) {
        this.securityIps = value
    }

    @JvmName("imxgapvwavbjhwsl")
    public suspend fun securityIps(vararg values: Output<String>) {
        this.securityIps = Output.all(values.asList())
    }

    /**
     * @param values The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
     * * IP address form, for example: 10.23.12.24.
     * * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).
     * > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
     */
    @JvmName("odhyoqbtkntkrpqf")
    public suspend fun securityIps(values: List<Output<String>>) {
        this.securityIps = Output.all(values)
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the content of the server certificate. If the CAType value is custom, this parameter must be configured.
     */
    @JvmName("wtagwrvakcosmkjb")
    public suspend fun serverCert(`value`: Output<String>) {
        this.serverCert = value
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the private key of the server certificate. If the value of CAType is custom, this parameter must be configured.
     */
    @JvmName("cckvhtdtefvwuuiw")
    public suspend fun serverKey(`value`: Output<String>) {
        this.serverKey = value
    }

    /**
     * @param value The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for MySQL instance.See `serverless_config` below.
     */
    @JvmName("cpamqrkmmgfhubtx")
    public suspend fun serverlessConfigs(`value`: Output<List<RdsCloneDbInstanceServerlessConfigArgs>>) {
        this.serverlessConfigs = value
    }

    @JvmName("atdcamudahvhsufp")
    public suspend fun serverlessConfigs(vararg values: Output<RdsCloneDbInstanceServerlessConfigArgs>) {
        this.serverlessConfigs = Output.all(values.asList())
    }

    /**
     * @param values The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for MySQL instance.See `serverless_config` below.
     */
    @JvmName("huawrmndantoewjn")
    public suspend fun serverlessConfigs(values: List<Output<RdsCloneDbInstanceServerlessConfigArgs>>) {
        this.serverlessConfigs = Output.all(values)
    }

    /**
     * @param value The source biz.
     */
    @JvmName("ppxnsracllnsxiiy")
    public suspend fun sourceBiz(`value`: Output<String>) {
        this.sourceBiz = value
    }

    /**
     * @param value The source db instance id.
     */
    @JvmName("tcuguqedavbbqctq")
    public suspend fun sourceDbInstanceId(`value`: Output<String>) {
        this.sourceDbInstanceId = value
    }

    /**
     * @param value Enable or disable SSL. Valid values: `0` and `1`.
     */
    @JvmName("uijsfiyvvjntkclo")
    public suspend fun sslEnabled(`value`: Output<Int>) {
        this.sslEnabled = value
    }

    /**
     * @param value The time at which you want to apply the specification changes. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     */
    @JvmName("cslwopjovhwqccrf")
    public suspend fun switchTime(`value`: Output<String>) {
        this.switchTime = value
    }

    /**
     * @param value [The data replication mode](https://www.alibabacloud.com/help/doc-detail/96055.htm). Valid values:
     * * **Sync**: strong synchronization
     * * **Semi-sync**: Semi-synchronous
     * * **Async**: asynchronous
     * > **NOTE:** SQL Server 2017 cluster version is currently not supported.
     */
    @JvmName("bycmqooemikuaytm")
    public suspend fun syncMode(`value`: Output<String>) {
        this.syncMode = value
    }

    /**
     * @param value The information about the databases and tables that you want to restore. Format:
     * [{"type":"db","name":"The original name of Database 1","newname":"The new name of Database 1","tables":[{"type":"table","name":"The original name of Table 1 in Database 1","newname":"The new name of Table 1 in Database 1"},{"type":"table","name":"The original name of Table 2 in Database 1","newname":"The new name of Table 2 in Database 1"}]},{"type":"db","name":"The original name of Database 2","newname":"The new name of Database 2","tables":[{"type":"table","name":"The original name of Table 1 in Database 2","newname":"The new name of Table 1 in Database 2"},{"type":"table","name":"The original name of Table 2 in Database 2","newname":"The new name of Table 2 in Database 2"}]}]
     */
    @JvmName("qitapcdfuptvpkyq")
    public suspend fun tableMeta(`value`: Output<String>) {
        this.tableMeta = value
    }

    /**
     * @param value The availability check method of the instance. Valid values:
     * - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
     * - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
     */
    @JvmName("mthfsilvompogclm")
    public suspend fun tcpConnectionType(`value`: Output<String>) {
        this.tcpConnectionType = value
    }

    /**
     * @param value Specifies whether to enable TDE. Valid values:
     * * Enabled
     * * Disabled
     */
    @JvmName("tuwdsnvtybbqqcbd")
    public suspend fun tdeStatus(`value`: Output<String>) {
        this.tdeStatus = value
    }

    /**
     * @param value The subscription period of the new instance. This parameter takes effect only when you select the subscription billing method for the new instance. Valid values:
     * * If you set the `Period` parameter to Year, the value of the UsedTime parameter ranges from 1 to 3.
     * * If you set the `Period` parameter to Month, the value of the UsedTime parameter ranges from 1 to 9.
     * > **NOTE:** If you set the payment_type parameter to Subscription, you must specify the used_time parameter.
     */
    @JvmName("snoonjruswgpsjyt")
    public suspend fun usedTime(`value`: Output<Int>) {
        this.usedTime = value
    }

    /**
     * @param value The ID of the VPC to which the new instance belongs.
     * > **NOTE:** Make sure that the VPC resides in the specified region.
     */
    @JvmName("xruxmmyamtdegbas")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the vSwitch associated with the specified VPC. If there are multiple vswitches, separate them with commas. The first vswitch is a primary zone switch and the query only returns that vswitch. If there are multiple vswitches, do not perform `vswitch_id` check.
     * > **NOTE:** Make sure that the vSwitch belongs to the specified VPC and region.
     */
    @JvmName("ubdpukjigpqvxkds")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The ID of the zone to which the new instance belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query the most recent region list.
     */
    @JvmName("yqbdclthhlknwfco")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
     */
    @JvmName("slmjoeddgesbifel")
    public suspend fun zoneIdSlaveA(`value`: Output<String>) {
        this.zoneIdSlaveA = value
    }

    /**
     * @param value The region ID of the log instance if you create a log instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
     * > **NOTE:** The default value of this parameter is the ID of the zone to which the original instance belongs.
     */
    @JvmName("ucsobuqniwfmjqqy")
    public suspend fun zoneIdSlaveB(`value`: Output<String>) {
        this.zoneIdSlaveB = value
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version. This parameter indicates the authentication method. It is allowed only when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
     */
    @JvmName("tgfmvgwswaxkyqfq")
    public suspend fun acl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value How to upgrade the minor version of the instance. Valid values:
     * * **Auto**: automatically upgrade the minor version.
     * * **Manual**: It is not automatically upgraded. It is only mandatory when the current version is offline.
     */
    @JvmName("lpmouqytiqnwgjun")
    public suspend fun autoUpgradeMinorVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value The ID of the data backup file you want to use. You can call the DescribeBackups operation to query the most recent data backup file list.
     * > **NOTE:** You must specify at least one of the BackupId and RestoreTime parameters. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
     */
    @JvmName("vcolgialofuglrug")
    public suspend fun backupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupId = mapped
    }

    /**
     * @param value The type of backup that is used to restore the data of the original instance. Valid values:
     * * **FullBackup**: full backup
     * * **IncrementalBackup**: incremental backup
     */
    @JvmName("omdocyxdbpaxdfxg")
    public suspend fun backupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the certificate type. When the value of ssl_action is Open, the default value of this parameter is aliyun. Value range:
     * * **aliyun**: using cloud certificates
     * * **custom**: use a custom certificate. Valid values: `aliyun`, `custom`.
     */
    @JvmName("clfavaanrmdghgee")
    public suspend fun caType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caType = mapped
    }

    /**
     * @param value Instance series. Valid values:
     * * **Basic**: Basic Edition
     * * **HighAvailability**: High availability
     * * **AlwaysOn**: Cluster Edition
     * * **Finance**: Three-node Enterprise Edition.
     * * **serverless_basic**: Serverless Basic Edition. (Available in 1.200.0+)
     * * **serverless_standard**: MySQL Serverless High Availability Edition. (Available in 1.207.0+)
     * * **serverless_ha**: SQLServer Serverless High Availability Edition. (Available in 1.207.0+)
     * * **cluster**: MySQL Cluster Edition. (Available in 1.207.0+)
     */
    @JvmName("sjquhedrmmfawjmc")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The file that contains the certificate used for TDE.
     */
    @JvmName("hxirpvcufamxlgoc")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the public key of the client certification authority. If the value of client_ca_enabled is 1, this parameter must be configured.
     */
    @JvmName("gshqjlfgpbwgpudp")
    public suspend fun clientCaCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCaCert = mapped
    }

    /**
     * @param value The client ca enabled.
     */
    @JvmName("wyjuuvwkbmdahtmm")
    public suspend fun clientCaEnabled(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCaEnabled = mapped
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version, which indicates that the client revokes the certificate file. If the value of client_crl_enabled is 1, this parameter must be configured.
     */
    @JvmName("uteaoungsocdxhaw")
    public suspend fun clientCertRevocationList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertRevocationList = mapped
    }

    /**
     * @param value The client crl enabled.
     */
    @JvmName("pfrmuifuyhpesrrf")
    public suspend fun clientCrlEnabled(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCrlEnabled = mapped
    }

    /**
     * @param value The connection string prefix.
     */
    @JvmName("mrkfghsnqptfgjfb")
    public suspend fun connectionStringPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStringPrefix = mapped
    }

    /**
     * @param value The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
     */
    @JvmName("nddoqpjkuvgjitub")
    public suspend fun dbInstanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceClass = mapped
    }

    /**
     * @param value The db instance description.
     */
    @JvmName("yujumxndkfiqytsm")
    public suspend fun dbInstanceDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceDescription = mapped
    }

    /**
     * @param value The storage capacity of the new instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
     * > **NOTE:** The default value of this parameter is the storage capacity of the original instance.
     */
    @JvmName("kjuhgugvjccxoyfb")
    public suspend fun dbInstanceStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceStorage = mapped
    }

    /**
     * @param value The type of storage media that is used for the new instance. Valid values:
     * * **local_ssd**: local SSDs
     * * **cloud_ssd**: standard SSDs
     * * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1)
     * * **cloud_essd2**: ESSDs of PL2
     * * **cloud_essd3**: ESSDs of PL3
     */
    @JvmName("qujrskndsnqabwvc")
    public suspend fun dbInstanceStorageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceStorageType = mapped
    }

    /**
     * @param value The name of the database for which you want to enable TDE. Up to 50 names can be entered in a single request. If you specify multiple names, separate these names with commas (,).
     * > **NOTE:** This parameter is available and must be specified only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
     */
    @JvmName("sfrteopbfvnahxmo")
    public suspend fun dbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbName = mapped
    }

    /**
     * @param value The names of the databases that you want to create on the new instance.
     */
    @JvmName("ueadrtxfuxoujmgc")
    public suspend fun dbNames(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNames = mapped
    }

    /**
     * @param value The ID of the dedicated cluster to which the new instance belongs. This parameter takes effect only when you create the new instance in a dedicated cluster.
     */
    @JvmName("ousoimxxsdljsqsi")
    public suspend fun dedicatedHostGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostGroupId = mapped
    }

    /**
     * @param value The switch of delete protection. Valid values:
     * - true: delete protect.
     * - false: no delete protect.
     * > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
     */
    @JvmName("awhmlbxaaepbgrqr")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value The direction. Valid values: `Auto`, `Down`, `TempUpgrade`, `Up`.
     */
    @JvmName("daxkyyyrgyhhidpf")
    public suspend fun direction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The effective time.
     */
    @JvmName("cpwompfsaypbwucb")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value The ID of the private key.
     * > **NOTE:** This parameter is available only when the instance runs MySQL.
     */
    @JvmName("ftfvrednuwfluxpe")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
     */
    @JvmName("rfumeprevxfwmtuk")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value Database version. Value:
     * * MySQL:**5.5/5.6/5.7/8.0**
     * * SQL Server:**2008r2/08r2_ent_ha/2012/2012_ent_ha/2012_std_ha/2012_web/2014_std_ha/2016_ent_ha/2016_std_ha/2016_web/2017_std_ha/2017_ent/2019_std_ha/2019_ent**
     * * PostgreSQL:**9.4/10.0/11.0/12.0/13.0**
     * * MariaDB:**10.3**.
     */
    @JvmName("sndnwvljtoctvrer")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Set it to true to make some parameter efficient when modifying them. Default to false.
     */
    @JvmName("dhtntdmverhfjomc")
    public suspend fun forceRestart(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceRestart = mapped
    }

    /**
     * @param value The high availability mode. Valid values:
     * * **RPO**: Data persistence is preferred. The instance preferentially ensures data reliability to minimize data loss. Use this mode if you have higher requirements on data consistency.
     * * **RTO**: Instance availability is preferred. The instance restores services as soon as possible to ensure availability. Use this mode if you have higher requirements on service availability.
     */
    @JvmName("loidxffsrcaacwvj")
    public suspend fun haMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.haMode = mapped
    }

    /**
     * @param value The network type of the instance. Valid values:
     * * **Classic**: Classic Network
     * * **VPC**: VPC.
     */
    @JvmName("mlkmgklnwujpmdyl")
    public suspend fun instanceNetworkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceNetworkType = mapped
    }

    /**
     * @param value The maintainable time period of the instance. Format: <I> HH:mm</I> Z-<I> HH:mm</I> Z(UTC time).
     */
    @JvmName("alcmqcelmhikxmdb")
    public suspend fun maintainTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainTime = mapped
    }

    /**
     * @param value Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm).See `parameters` below.
     */
    @JvmName("hcfnyhixwjuropwh")
    public suspend fun parameters(`value`: List<RdsCloneDbInstanceParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm).See `parameters` below.
     */
    @JvmName("xnbshgpeqaqcpotp")
    public suspend fun parameters(argument: List<suspend RdsCloneDbInstanceParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RdsCloneDbInstanceParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm).See `parameters` below.
     */
    @JvmName("dfturysrbyqprlui")
    public suspend fun parameters(vararg argument: suspend RdsCloneDbInstanceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RdsCloneDbInstanceParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm).See `parameters` below.
     */
    @JvmName("jjnjwwgkruryjliw")
    public suspend fun parameters(argument: suspend RdsCloneDbInstanceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RdsCloneDbInstanceParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm).See `parameters` below.
     */
    @JvmName("oxiprdixqruhrqbu")
    public suspend fun parameters(vararg values: RdsCloneDbInstanceParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password of the certificate.
     * > **NOTE:** This parameter is available only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
     */
    @JvmName("rrkcrbabktcxjsux")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The billing method of the new instance. Valid values: `PayAsYouGo` and `Subscription` and `Serverless`.
     */
    @JvmName("fpmqhgwmwnearldm")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The period. Valid values: `Month`, `Year`.
     * > **NOTE:** If you set the payment_type parameter to Subscription, you must specify the period parameter.
     */
    @JvmName("awanvhjqyodpyvmk")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The details of the AD domain.See `pg_hba_conf` below.
     */
    @JvmName("fjswrndkqismeyyi")
    public suspend fun pgHbaConfs(`value`: List<RdsCloneDbInstancePgHbaConfArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pgHbaConfs = mapped
    }

    /**
     * @param argument The details of the AD domain.See `pg_hba_conf` below.
     */
    @JvmName("byxtmongqrxpyqdu")
    public suspend fun pgHbaConfs(argument: List<suspend RdsCloneDbInstancePgHbaConfArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RdsCloneDbInstancePgHbaConfArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pgHbaConfs = mapped
    }

    /**
     * @param argument The details of the AD domain.See `pg_hba_conf` below.
     */
    @JvmName("vuhseujjfygynnns")
    public suspend fun pgHbaConfs(vararg argument: suspend RdsCloneDbInstancePgHbaConfArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RdsCloneDbInstancePgHbaConfArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pgHbaConfs = mapped
    }

    /**
     * @param argument The details of the AD domain.See `pg_hba_conf` below.
     */
    @JvmName("suyhcpxvnnaaxubd")
    public suspend fun pgHbaConfs(argument: suspend RdsCloneDbInstancePgHbaConfArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RdsCloneDbInstancePgHbaConfArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pgHbaConfs = mapped
    }

    /**
     * @param values The details of the AD domain.See `pg_hba_conf` below.
     */
    @JvmName("cwrglicxnbysvqxh")
    public suspend fun pgHbaConfs(vararg values: RdsCloneDbInstancePgHbaConfArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pgHbaConfs = mapped
    }

    /**
     * @param value The port.
     */
    @JvmName("lllyujstsrfgtixx")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The intranet IP address of the new instance must be within the specified vSwitch IP address range. By default, the system automatically allocates by using **VPCId** and **VSwitchId**.
     */
    @JvmName("acyydontksmtchjl")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value The file that contains the private key used for TDE.
     */
    @JvmName("grlqiqmwedsfrdot")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value The released keep policy.
     */
    @JvmName("yxkcycshcmlhtcxp")
    public suspend fun releasedKeepPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releasedKeepPolicy = mapped
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version, indicating the authentication method of the replication permission. It is only allowed when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
     */
    @JvmName("tnhhrcqwcalequbj")
    public suspend fun replicationAcl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationAcl = mapped
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("tbeuoqnmqtemhcdo")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Specifies whether to restore only the databases and tables that you specify. The value 1 specifies to restore only the specified databases and tables. If you do not want to restore only the specified databases or tables, you can choose not to specify this parameter.
     */
    @JvmName("tnfhpdlpefhpqumu")
    public suspend fun restoreTable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreTable = mapped
    }

    /**
     * @param value The point in time to which you want to restore the data of the original instance. The point in time must fall within the specified log backup retention period. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     */
    @JvmName("yrcoopwbywyyahjn")
    public suspend fun restoreTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreTime = mapped
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of a RAM role. A RAM role is a virtual RAM identity that you can create within your Alibaba Cloud account.
     * > **NOTE:** This parameter is available only when the instance runs MySQL.
     */
    @JvmName("grmltukxoepqhgbu")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
     * * IP address form, for example: 10.23.12.24.
     * * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).
     * > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
     */
    @JvmName("ilfwhcsgpxfhfhta")
    public suspend fun securityIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param values The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
     * * IP address form, for example: 10.23.12.24.
     * * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).
     * > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
     */
    @JvmName("wvtsobruluuuaaju")
    public suspend fun securityIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the content of the server certificate. If the CAType value is custom, this parameter must be configured.
     */
    @JvmName("gphuginqxfaxldgt")
    public suspend fun serverCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCert = mapped
    }

    /**
     * @param value This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the private key of the server certificate. If the value of CAType is custom, this parameter must be configured.
     */
    @JvmName("dpvutrjaheorlqjq")
    public suspend fun serverKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverKey = mapped
    }

    /**
     * @param value The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for MySQL instance.See `serverless_config` below.
     */
    @JvmName("gfhhrpyhmekgurkr")
    public suspend fun serverlessConfigs(`value`: List<RdsCloneDbInstanceServerlessConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessConfigs = mapped
    }

    /**
     * @param argument The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for MySQL instance.See `serverless_config` below.
     */
    @JvmName("esibodvvvmngsgcl")
    public suspend fun serverlessConfigs(argument: List<suspend RdsCloneDbInstanceServerlessConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RdsCloneDbInstanceServerlessConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serverlessConfigs = mapped
    }

    /**
     * @param argument The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for MySQL instance.See `serverless_config` below.
     */
    @JvmName("pglghhanfvnfrsxq")
    public suspend fun serverlessConfigs(vararg argument: suspend RdsCloneDbInstanceServerlessConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RdsCloneDbInstanceServerlessConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serverlessConfigs = mapped
    }

    /**
     * @param argument The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for MySQL instance.See `serverless_config` below.
     */
    @JvmName("deyetklgoithmxfe")
    public suspend fun serverlessConfigs(argument: suspend RdsCloneDbInstanceServerlessConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RdsCloneDbInstanceServerlessConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serverlessConfigs = mapped
    }

    /**
     * @param values The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for MySQL instance.See `serverless_config` below.
     */
    @JvmName("ffvbpcgrlyngbnpw")
    public suspend fun serverlessConfigs(vararg values: RdsCloneDbInstanceServerlessConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverlessConfigs = mapped
    }

    /**
     * @param value The source biz.
     */
    @JvmName("fxxvvgfqepwhaxbl")
    public suspend fun sourceBiz(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceBiz = mapped
    }

    /**
     * @param value The source db instance id.
     */
    @JvmName("ncsotecschbqypfi")
    public suspend fun sourceDbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbInstanceId = mapped
    }

    /**
     * @param value Enable or disable SSL. Valid values: `0` and `1`.
     */
    @JvmName("nlgrbwduhwdtuygk")
    public suspend fun sslEnabled(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslEnabled = mapped
    }

    /**
     * @param value The time at which you want to apply the specification changes. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     */
    @JvmName("pqlesttfverahmok")
    public suspend fun switchTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.switchTime = mapped
    }

    /**
     * @param value [The data replication mode](https://www.alibabacloud.com/help/doc-detail/96055.htm). Valid values:
     * * **Sync**: strong synchronization
     * * **Semi-sync**: Semi-synchronous
     * * **Async**: asynchronous
     * > **NOTE:** SQL Server 2017 cluster version is currently not supported.
     */
    @JvmName("hywunfhfykugqexl")
    public suspend fun syncMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The information about the databases and tables that you want to restore. Format:
     * [{"type":"db","name":"The original name of Database 1","newname":"The new name of Database 1","tables":[{"type":"table","name":"The original name of Table 1 in Database 1","newname":"The new name of Table 1 in Database 1"},{"type":"table","name":"The original name of Table 2 in Database 1","newname":"The new name of Table 2 in Database 1"}]},{"type":"db","name":"The original name of Database 2","newname":"The new name of Database 2","tables":[{"type":"table","name":"The original name of Table 1 in Database 2","newname":"The new name of Table 1 in Database 2"},{"type":"table","name":"The original name of Table 2 in Database 2","newname":"The new name of Table 2 in Database 2"}]}]
     */
    @JvmName("dnjobkwqcieefjvr")
    public suspend fun tableMeta(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableMeta = mapped
    }

    /**
     * @param value The availability check method of the instance. Valid values:
     * - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
     * - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
     */
    @JvmName("jhesbwvxljppgody")
    public suspend fun tcpConnectionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpConnectionType = mapped
    }

    /**
     * @param value Specifies whether to enable TDE. Valid values:
     * * Enabled
     * * Disabled
     */
    @JvmName("vlvfgdotsjcboxsg")
    public suspend fun tdeStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tdeStatus = mapped
    }

    /**
     * @param value The subscription period of the new instance. This parameter takes effect only when you select the subscription billing method for the new instance. Valid values:
     * * If you set the `Period` parameter to Year, the value of the UsedTime parameter ranges from 1 to 3.
     * * If you set the `Period` parameter to Month, the value of the UsedTime parameter ranges from 1 to 9.
     * > **NOTE:** If you set the payment_type parameter to Subscription, you must specify the used_time parameter.
     */
    @JvmName("kxnlkyoqsbokqgfv")
    public suspend fun usedTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usedTime = mapped
    }

    /**
     * @param value The ID of the VPC to which the new instance belongs.
     * > **NOTE:** Make sure that the VPC resides in the specified region.
     */
    @JvmName("gpfawycooolkvxft")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the vSwitch associated with the specified VPC. If there are multiple vswitches, separate them with commas. The first vswitch is a primary zone switch and the query only returns that vswitch. If there are multiple vswitches, do not perform `vswitch_id` check.
     * > **NOTE:** Make sure that the vSwitch belongs to the specified VPC and region.
     */
    @JvmName("nnequrvpwwtjteav")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The ID of the zone to which the new instance belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query the most recent region list.
     */
    @JvmName("rlcvfbbhekdgtpvl")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    /**
     * @param value The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
     */
    @JvmName("xuumqhiuracyrvgx")
    public suspend fun zoneIdSlaveA(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneIdSlaveA = mapped
    }

    /**
     * @param value The region ID of the log instance if you create a log instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
     * > **NOTE:** The default value of this parameter is the ID of the zone to which the original instance belongs.
     */
    @JvmName("ttaxepvbtdisvvxr")
    public suspend fun zoneIdSlaveB(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneIdSlaveB = mapped
    }

    internal fun build(): RdsCloneDbInstanceArgs = RdsCloneDbInstanceArgs(
        acl = acl,
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        backupId = backupId,
        backupType = backupType,
        caType = caType,
        category = category,
        certificate = certificate,
        clientCaCert = clientCaCert,
        clientCaEnabled = clientCaEnabled,
        clientCertRevocationList = clientCertRevocationList,
        clientCrlEnabled = clientCrlEnabled,
        connectionStringPrefix = connectionStringPrefix,
        dbInstanceClass = dbInstanceClass,
        dbInstanceDescription = dbInstanceDescription,
        dbInstanceStorage = dbInstanceStorage,
        dbInstanceStorageType = dbInstanceStorageType,
        dbName = dbName,
        dbNames = dbNames,
        dedicatedHostGroupId = dedicatedHostGroupId,
        deletionProtection = deletionProtection,
        direction = direction,
        effectiveTime = effectiveTime,
        encryptionKey = encryptionKey,
        engine = engine,
        engineVersion = engineVersion,
        forceRestart = forceRestart,
        haMode = haMode,
        instanceNetworkType = instanceNetworkType,
        maintainTime = maintainTime,
        parameters = parameters,
        password = password,
        paymentType = paymentType,
        period = period,
        pgHbaConfs = pgHbaConfs,
        port = port,
        privateIpAddress = privateIpAddress,
        privateKey = privateKey,
        releasedKeepPolicy = releasedKeepPolicy,
        replicationAcl = replicationAcl,
        resourceGroupId = resourceGroupId,
        restoreTable = restoreTable,
        restoreTime = restoreTime,
        roleArn = roleArn,
        securityIps = securityIps,
        serverCert = serverCert,
        serverKey = serverKey,
        serverlessConfigs = serverlessConfigs,
        sourceBiz = sourceBiz,
        sourceDbInstanceId = sourceDbInstanceId,
        sslEnabled = sslEnabled,
        switchTime = switchTime,
        syncMode = syncMode,
        tableMeta = tableMeta,
        tcpConnectionType = tcpConnectionType,
        tdeStatus = tdeStatus,
        usedTime = usedTime,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
        zoneIdSlaveA = zoneIdSlaveA,
        zoneIdSlaveB = zoneIdSlaveB,
    )
}
