@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.RdsFunctions.getAccountsPlain
import com.pulumi.alicloud.rds.RdsFunctions.getCharacterSetNamesPlain
import com.pulumi.alicloud.rds.RdsFunctions.getClassDetailsPlain
import com.pulumi.alicloud.rds.RdsFunctions.getCollationTimeZonesPlain
import com.pulumi.alicloud.rds.RdsFunctions.getCrossRegionBackupsPlain
import com.pulumi.alicloud.rds.RdsFunctions.getCrossRegionsPlain
import com.pulumi.alicloud.rds.RdsFunctions.getInstanceClassInfosPlain
import com.pulumi.alicloud.rds.RdsFunctions.getInstanceClassesPlain
import com.pulumi.alicloud.rds.RdsFunctions.getInstanceEnginesPlain
import com.pulumi.alicloud.rds.RdsFunctions.getInstancesPlain
import com.pulumi.alicloud.rds.RdsFunctions.getModifyParameterLogsPlain
import com.pulumi.alicloud.rds.RdsFunctions.getRdsBackupsPlain
import com.pulumi.alicloud.rds.RdsFunctions.getRdsParameterGroupsPlain
import com.pulumi.alicloud.rds.RdsFunctions.getSlotsPlain
import com.pulumi.alicloud.rds.RdsFunctions.getZonesPlain
import com.pulumi.alicloud.rds.kotlin.inputs.GetAccountsPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetAccountsPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetCharacterSetNamesPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetCharacterSetNamesPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetClassDetailsPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetClassDetailsPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetCollationTimeZonesCollationTimeZone
import com.pulumi.alicloud.rds.kotlin.inputs.GetCollationTimeZonesPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetCollationTimeZonesPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetCrossRegionBackupsPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetCrossRegionBackupsPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetCrossRegionsPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetCrossRegionsPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetInstanceClassInfosInfo
import com.pulumi.alicloud.rds.kotlin.inputs.GetInstanceClassInfosPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetInstanceClassInfosPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetInstanceClassesPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetInstanceClassesPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetInstanceEnginesPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetInstanceEnginesPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetModifyParameterLogsPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetModifyParameterLogsPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetRdsBackupsPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetRdsBackupsPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetRdsParameterGroupsPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetRdsParameterGroupsPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetSlotsPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetSlotsPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.rds.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.rds.kotlin.outputs.GetAccountsResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetCharacterSetNamesResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetClassDetailsResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetCollationTimeZonesResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetCrossRegionBackupsResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetCrossRegionsResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceClassInfosResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceClassesResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceEnginesResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetModifyParameterLogsResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetRdsBackupsResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetRdsParameterGroupsResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetSlotsResult
import com.pulumi.alicloud.rds.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.rds.kotlin.outputs.GetAccountsResult.Companion.toKotlin as getAccountsResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetCharacterSetNamesResult.Companion.toKotlin as getCharacterSetNamesResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetClassDetailsResult.Companion.toKotlin as getClassDetailsResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetCollationTimeZonesResult.Companion.toKotlin as getCollationTimeZonesResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetCrossRegionBackupsResult.Companion.toKotlin as getCrossRegionBackupsResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetCrossRegionsResult.Companion.toKotlin as getCrossRegionsResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceClassInfosResult.Companion.toKotlin as getInstanceClassInfosResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceClassesResult.Companion.toKotlin as getInstanceClassesResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceEnginesResult.Companion.toKotlin as getInstanceEnginesResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetModifyParameterLogsResult.Companion.toKotlin as getModifyParameterLogsResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetRdsBackupsResult.Companion.toKotlin as getRdsBackupsResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetRdsParameterGroupsResult.Companion.toKotlin as getRdsParameterGroupsResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetSlotsResult.Companion.toKotlin as getSlotsResultToKotlin
import com.pulumi.alicloud.rds.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object RdsFunctions {
    /**
     * This data source provides the Rds Accounts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.120.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.rds.getAccounts({
     *     dbInstanceId: "example_value",
     *     nameRegex: "the_resource_name",
     * });
     * export const firstRdsAccountId = example.then(example => example.accounts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.rds.get_accounts(db_instance_id="example_value",
     *     name_regex="the_resource_name")
     * pulumi.export("firstRdsAccountId", example.accounts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Rds.GetAccounts.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRdsAccountId"] = example&#46;Apply(getAccountsResult => getAccountsResult&#46;Accounts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := rds.GetAccounts(ctx, &rds.GetAccountsArgs{
     * 			DbInstanceId: "example_value",
     * 			NameRegex:    pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRdsAccountId", example.Accounts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getAccounts(GetAccountsArgs.builder()
     *             .dbInstanceId("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstRdsAccountId", example.applyValue(getAccountsResult -> getAccountsResult.accounts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:rds:getAccounts
     *       Arguments:
     *         dbInstanceId: example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstRdsAccountId: ${example.accounts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccounts.
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: GetAccountsPlainArgs): GetAccountsResult =
        getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())

    /**
     * @see [getAccounts].
     * @param dbInstanceId The db instance id.
     * @param ids A list of Account IDs.
     * @param nameRegex A regex string to filter results by Account name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `Available`, `Unavailable`.
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(
        dbInstanceId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAccountsResult {
        val argument = GetAccountsPlainArgs(
            dbInstanceId = dbInstanceId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetAccountsPlainArgs].
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: suspend GetAccountsPlainArgsBuilder.() -> Unit): GetAccountsResult {
        val builder = GetAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountsResultToKotlin(getAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source is the character set supported by querying RDS instances.
     * > **NOTE:** Available in v1.198.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const names = alicloud.rds.getCharacterSetNames({
     *     engine: "MySQL",
     * });
     * export const firstRdsCharacterSetNames = names.then(names => names.names?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * names = alicloud.rds.get_character_set_names(engine="MySQL")
     * pulumi.export("firstRdsCharacterSetNames", names.names[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var names = AliCloud.Rds.GetCharacterSetNames.Invoke(new()
     *     {
     *         Engine = "MySQL",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRdsCharacterSetNames"] = names&#46;Apply(getCharacterSetNamesResult => getCharacterSetNamesResult&#46;Names[0]),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		names, err := rds.GetCharacterSetNames(ctx, &rds.GetCharacterSetNamesArgs{
     * 			Engine: "MySQL",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRdsCharacterSetNames", names.Names[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetCharacterSetNamesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var names = RdsFunctions.getCharacterSetNames(GetCharacterSetNamesArgs.builder()
     *             .engine("MySQL")
     *             .build());
     *         ctx.export("firstRdsCharacterSetNames", names.applyValue(getCharacterSetNamesResult -> getCharacterSetNamesResult.names()[0]));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   names:
     *     fn::invoke:
     *       Function: alicloud:rds:getCharacterSetNames
     *       Arguments:
     *         engine: MySQL
     * outputs:
     *   firstRdsCharacterSetNames: ${names.names[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCharacterSetNames.
     * @return A collection of values returned by getCharacterSetNames.
     */
    public suspend fun getCharacterSetNames(argument: GetCharacterSetNamesPlainArgs): GetCharacterSetNamesResult =
        getCharacterSetNamesResultToKotlin(getCharacterSetNamesPlain(argument.toJava()).await())

    /**
     * @see [getCharacterSetNames].
     * @param engine Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`.
     * @param outputFile
     * @return A collection of values returned by getCharacterSetNames.
     */
    public suspend fun getCharacterSetNames(engine: String, outputFile: String? = null): GetCharacterSetNamesResult {
        val argument = GetCharacterSetNamesPlainArgs(
            engine = engine,
            outputFile = outputFile,
        )
        return getCharacterSetNamesResultToKotlin(getCharacterSetNamesPlain(argument.toJava()).await())
    }

    /**
     * @see [getCharacterSetNames].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetCharacterSetNamesPlainArgs].
     * @return A collection of values returned by getCharacterSetNames.
     */
    public suspend fun getCharacterSetNames(argument: suspend GetCharacterSetNamesPlainArgsBuilder.() -> Unit): GetCharacterSetNamesResult {
        val builder = GetCharacterSetNamesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCharacterSetNamesResultToKotlin(getCharacterSetNamesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides details of the Rds specifications of current Alibaba Cloud users.
     * For information on RDS class details and how to use it, please refer to [What is RDS class details](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeclassdetails).
     * > **NOTE:** Available since v1.209.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.rds.getClassDetails({
     *     commodityCode: "bards",
     *     classCode: "mysql.n4.medium.2c",
     *     engineVersion: "8.0",
     *     engine: "MySQL",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.rds.get_class_details(commodity_code="bards",
     *     class_code="mysql.n4.medium.2c",
     *     engine_version="8.0",
     *     engine="MySQL")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Rds.GetClassDetails.Invoke(new()
     *     {
     *         CommodityCode = "bards",
     *         ClassCode = "mysql.n4.medium.2c",
     *         EngineVersion = "8.0",
     *         Engine = "MySQL",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetClassDetails(ctx, &rds.GetClassDetailsArgs{
     * 			CommodityCode: "bards",
     * 			ClassCode:     "mysql.n4.medium.2c",
     * 			EngineVersion: "8.0",
     * 			Engine:        "MySQL",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetClassDetailsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = RdsFunctions.getClassDetails(GetClassDetailsArgs.builder()
     *             .commodityCode("bards")
     *             .classCode("mysql.n4.medium.2c")
     *             .engineVersion("8.0")
     *             .engine("MySQL")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:rds:getClassDetails
     *       Arguments:
     *         commodityCode: bards
     *         classCode: mysql.n4.medium.2c
     *         engineVersion: '8.0'
     *         engine: MySQL
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClassDetails.
     * @return A collection of values returned by getClassDetails.
     */
    public suspend fun getClassDetails(argument: GetClassDetailsPlainArgs): GetClassDetailsResult =
        getClassDetailsResultToKotlin(getClassDetailsPlain(argument.toJava()).await())

    /**
     * @see [getClassDetails].
     * @param classCode The code of the instance type.
     * @param commodityCode The commodity code of the instance. Valid values:
     * * **bards**: The instance is a pay-as-you-go primary instance. This value is available on the China site (aliyun.com).
     * * **rds**: The instance is a subscription primary instance. This value is available on the China site (aliyun.com).
     * * **rords**: The instance is a pay-as-you-go read-only instance. This value is available on the China site (aliyun.com).
     * * **rds_rordspre_public_cn**: The instance is a subscription read-only instance. This value is available on the China site (aliyun.com).
     * * **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available on the International site (alibabacloud.com).
     * * **rds_intl**: The instance is a subscription primary instance. This value is available on the International site (alibabacloud.com).
     * * **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available on the International site (alibabacloud.com).
     * * **rds_rordspre_public_intl**: The instance is a subscription read-only instance. This value is available on the International site (alibabacloud.com).
     * @param engine Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
     * @param engineVersion Database version. Value options:
     * - MySQL: [ 5&#46;5、5&#46;6、5&#46;7、8&#46;0 ]
     * - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
     * - PostgreSQL: [ 10&#46;0、11&#46;0、12&#46;0、13&#46;0、14&#46;0、15&#46;0 ]
     * - MariaDB: [ 10&#46;3 ]
     * @return A collection of values returned by getClassDetails.
     */
    public suspend fun getClassDetails(
        classCode: String,
        commodityCode: String,
        engine: String,
        engineVersion: String,
    ): GetClassDetailsResult {
        val argument = GetClassDetailsPlainArgs(
            classCode = classCode,
            commodityCode = commodityCode,
            engine = engine,
            engineVersion = engineVersion,
        )
        return getClassDetailsResultToKotlin(getClassDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getClassDetails].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetClassDetailsPlainArgs].
     * @return A collection of values returned by getClassDetails.
     */
    public suspend fun getClassDetails(argument: suspend GetClassDetailsPlainArgsBuilder.() -> Unit): GetClassDetailsResult {
        val builder = GetClassDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClassDetailsResultToKotlin(getClassDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Operation to query the character set collations and time zones available for use in ApsaraDB RDS.
     * > **NOTE:** Available in v1.198.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const zones = alicloud.rds.getCollationTimeZones({
     *     outputFile: "./classes.txt",
     * });
     * export const firstRdsCollationTimeZones = zones.then(zones => zones.collationTimeZones?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * zones = alicloud.rds.get_collation_time_zones(output_file="./classes.txt")
     * pulumi.export("firstRdsCollationTimeZones", zones.collation_time_zones[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var zones = AliCloud.Rds.GetCollationTimeZones.Invoke(new()
     *     {
     *         OutputFile = "./classes.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRdsCollationTimeZones"] = zones&#46;Apply(getCollationTimeZonesResult => getCollationTimeZonesResult&#46;CollationTimeZones[0]),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		zones, err := rds.GetCollationTimeZones(ctx, &rds.GetCollationTimeZonesArgs{
     * 			OutputFile: pulumi.StringRef("./classes.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRdsCollationTimeZones", zones.CollationTimeZones[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetCollationTimeZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var zones = RdsFunctions.getCollationTimeZones(GetCollationTimeZonesArgs.builder()
     *             .outputFile("./classes.txt")
     *             .build());
     *         ctx.export("firstRdsCollationTimeZones", zones.applyValue(getCollationTimeZonesResult -> getCollationTimeZonesResult.collationTimeZones()[0]));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   zones:
     *     fn::invoke:
     *       Function: alicloud:rds:getCollationTimeZones
     *       Arguments:
     *         outputFile: ./classes.txt
     * outputs:
     *   firstRdsCollationTimeZones: ${zones.collationTimeZones[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCollationTimeZones.
     * @return A collection of values returned by getCollationTimeZones.
     */
    public suspend fun getCollationTimeZones(argument: GetCollationTimeZonesPlainArgs): GetCollationTimeZonesResult =
        getCollationTimeZonesResultToKotlin(getCollationTimeZonesPlain(argument.toJava()).await())

    /**
     * @see [getCollationTimeZones].
     * @param collationTimeZones An array that consists of the character set collations and time zones that are available for
     * use in ApsaraDB RDS.
     * @param outputFile File name where to save data source results (after running `pulumi up`).
     * @return A collection of values returned by getCollationTimeZones.
     */
    public suspend fun getCollationTimeZones(
        collationTimeZones: List<GetCollationTimeZonesCollationTimeZone>? =
            null,
        outputFile: String? = null,
    ): GetCollationTimeZonesResult {
        val argument = GetCollationTimeZonesPlainArgs(
            collationTimeZones = collationTimeZones,
            outputFile = outputFile,
        )
        return getCollationTimeZonesResultToKotlin(getCollationTimeZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getCollationTimeZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetCollationTimeZonesPlainArgs].
     * @return A collection of values returned by getCollationTimeZones.
     */
    public suspend fun getCollationTimeZones(argument: suspend GetCollationTimeZonesPlainArgsBuilder.() -> Unit): GetCollationTimeZonesResult {
        val builder = GetCollationTimeZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCollationTimeZonesResultToKotlin(getCollationTimeZonesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Rds Parameter Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.196.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const backups = alicloud.rds.getCrossRegionBackups({
     *     dbInstanceId: "example_value",
     *     startTime: "2022-12-01T00:00:00Z",
     *     endTime: "2022-12-16T00:00:00Z",
     * });
     * export const firstRdsCrossRegionBackups = backups.then(backups => backups.backups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * backups = alicloud.rds.get_cross_region_backups(db_instance_id="example_value",
     *     start_time="2022-12-01T00:00:00Z",
     *     end_time="2022-12-16T00:00:00Z")
     * pulumi.export("firstRdsCrossRegionBackups", backups.backups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var backups = AliCloud.Rds.GetCrossRegionBackups.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *         StartTime = "2022-12-01T00:00:00Z",
     *         EndTime = "2022-12-16T00:00:00Z",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRdsCrossRegionBackups"] = backups&#46;Apply(getCrossRegionBackupsResult => getCrossRegionBackupsResult&#46;Backups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		backups, err := rds.GetCrossRegionBackups(ctx, &rds.GetCrossRegionBackupsArgs{
     * 			DbInstanceId: "example_value",
     * 			StartTime:    pulumi.StringRef("2022-12-01T00:00:00Z"),
     * 			EndTime:      pulumi.StringRef("2022-12-16T00:00:00Z"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRdsCrossRegionBackups", backups.Backups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetCrossRegionBackupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var backups = RdsFunctions.getCrossRegionBackups(GetCrossRegionBackupsArgs.builder()
     *             .dbInstanceId("example_value")
     *             .startTime("2022-12-01T00:00:00Z")
     *             .endTime("2022-12-16T00:00:00Z")
     *             .build());
     *         ctx.export("firstRdsCrossRegionBackups", backups.applyValue(getCrossRegionBackupsResult -> getCrossRegionBackupsResult.backups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   backups:
     *     fn::invoke:
     *       Function: alicloud:rds:getCrossRegionBackups
     *       Arguments:
     *         dbInstanceId: example_value
     *         startTime: 2022-12-01T00:00:00Z
     *         endTime: 2022-12-16T00:00:00Z
     * outputs:
     *   firstRdsCrossRegionBackups: ${backups.backups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCrossRegionBackups.
     * @return A collection of values returned by getCrossRegionBackups.
     */
    public suspend fun getCrossRegionBackups(argument: GetCrossRegionBackupsPlainArgs): GetCrossRegionBackupsResult =
        getCrossRegionBackupsResultToKotlin(getCrossRegionBackupsPlain(argument.toJava()).await())

    /**
     * @see [getCrossRegionBackups].
     * @param backupId The ID of the cross-region data backup file.
     * @param crossBackupId The ID of the cross-region data backup file.
     * @param crossBackupRegion The ID of the destination region where the cross-region data backup file is stored.
     * > **NOTE:** Note You must specify the `cross_backup_id` parameter. Alternatively, you must specify the `start_time` and `end_time` parameters.
     * @param dbInstanceId The db instance id.
     * @param endTime The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     * @param ids A list of Cross Region Backup IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param startTime The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     * @return A collection of values returned by getCrossRegionBackups.
     */
    public suspend fun getCrossRegionBackups(
        backupId: String? = null,
        crossBackupId: String? = null,
        crossBackupRegion: String? = null,
        dbInstanceId: String,
        endTime: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        startTime: String? = null,
    ): GetCrossRegionBackupsResult {
        val argument = GetCrossRegionBackupsPlainArgs(
            backupId = backupId,
            crossBackupId = crossBackupId,
            crossBackupRegion = crossBackupRegion,
            dbInstanceId = dbInstanceId,
            endTime = endTime,
            ids = ids,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            startTime = startTime,
        )
        return getCrossRegionBackupsResultToKotlin(getCrossRegionBackupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCrossRegionBackups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetCrossRegionBackupsPlainArgs].
     * @return A collection of values returned by getCrossRegionBackups.
     */
    public suspend fun getCrossRegionBackups(argument: suspend GetCrossRegionBackupsPlainArgsBuilder.() -> Unit): GetCrossRegionBackupsResult {
        val builder = GetCrossRegionBackupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCrossRegionBackupsResultToKotlin(getCrossRegionBackupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides an available area for remote disaster recovery for RDS.
     * > **NOTE:** Available in v1.193.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const crossRegions = alicloud.rds.getCrossRegions({});
     * export const firstRdsCrossRegions = regions.ids[0];
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * cross_regions = alicloud.rds.get_cross_regions()
     * pulumi.export("firstRdsCrossRegions", regions["ids"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var crossRegions = AliCloud.Rds.GetCrossRegions.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRdsCrossRegions"] = regions&#46;Ids[0],
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		_, err := rds.GetCrossRegions(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRdsCrossRegions", regions.Ids[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetCrossRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var crossRegions = RdsFunctions.getCrossRegions();
     *         ctx.export("firstRdsCrossRegions", regions.ids()[0]);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   crossRegions:
     *     fn::invoke:
     *       Function: alicloud:rds:getCrossRegions
     *       Arguments: {}
     * outputs:
     *   firstRdsCrossRegions: ${regions.ids[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCrossRegions.
     * @return A collection of values returned by getCrossRegions.
     */
    public suspend fun getCrossRegions(argument: GetCrossRegionsPlainArgs): GetCrossRegionsResult =
        getCrossRegionsResultToKotlin(getCrossRegionsPlain(argument.toJava()).await())

    /**
     * @see [getCrossRegions].
     * @param outputFile
     * @return A collection of values returned by getCrossRegions.
     */
    public suspend fun getCrossRegions(outputFile: String? = null): GetCrossRegionsResult {
        val argument = GetCrossRegionsPlainArgs(
            outputFile = outputFile,
        )
        return getCrossRegionsResultToKotlin(getCrossRegionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCrossRegions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetCrossRegionsPlainArgs].
     * @return A collection of values returned by getCrossRegions.
     */
    public suspend fun getCrossRegions(argument: suspend GetCrossRegionsPlainArgsBuilder.() -> Unit): GetCrossRegionsResult {
        val builder = GetCrossRegionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCrossRegionsResultToKotlin(getCrossRegionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source operation to query the instance types that are available to specific instances of Alibaba Cloud.
     * > **NOTE:** Available in v1.196.0+
     * ## Example Usage
     * ```tf
     * data "alicloud_db_instance_class_infos" "resources" {
     *   commodity_code = "bards"
     *   order_type     = "BUY"
     *   output_file    = "./classes.txt"
     * }
     * output "first_db_instance_class" {
     *   value = "${data.alicloud_db_instance_class_infos.resources.infos.0}"
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstanceClassInfos.
     * @return A collection of values returned by getInstanceClassInfos.
     */
    public suspend fun getInstanceClassInfos(argument: GetInstanceClassInfosPlainArgs): GetInstanceClassInfosResult =
        getInstanceClassInfosResultToKotlin(getInstanceClassInfosPlain(argument.toJava()).await())

    /**
     * @see [getInstanceClassInfos].
     * @param commodityCode The commodity code of the instance. Valid values:
     * * **bards**: The instance is a pay-as-you-go primary instance. This value is available on the China site (aliyun.com).
     * * **rds**: The instance is a subscription primary instance. This value is available on the China site (aliyun.com).
     * * **rords**: The instance is a pay-as-you-go read-only instance. This value is available on the China site (aliyun.com).
     * * **rds_rordspre_public_cn**: The instance is a subscription read-only instance. This value is available on the China site (aliyun.com).
     * * **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available on the International site (alibabacloud.com).
     * * **rds_intl**: The instance is a subscription primary instance. This value is available on the International site (alibabacloud.com).
     * * **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available on the International site (alibabacloud.com).
     * * **rds_rordspre_public_intl**: The instance is a subscription read-only instance. This value is available on the International site (alibabacloud.com).
     * @param dbInstanceId The ID of the primary instance.
     * @param infos A list of Rds available resource. Each element contains the following attributes:
     * @param orderType FThe type of order that you want to query. Valid values:
     * * **BUY**: specifies the query orders that are used to purchase instances.
     * * **UPGRADE**: specifies the query orders that are used to change the specifications of instances.
     * * **RENEW**: specifies the query orders that are used to renew instances.
     * * **CONVERT**: specifies the query orders that are used to change the billing methods of instances.
     * @param outputFile File name where to save data source results (after running `pulumi up`).
     * > **NOTE**: If you use the CommodityCode parameter to query the instance types that are available to read-only instances, you must specify the DBInstanceId parameter.
     * @return A collection of values returned by getInstanceClassInfos.
     */
    public suspend fun getInstanceClassInfos(
        commodityCode: String,
        dbInstanceId: String? = null,
        infos: List<GetInstanceClassInfosInfo>? = null,
        orderType: String,
        outputFile: String? = null,
    ): GetInstanceClassInfosResult {
        val argument = GetInstanceClassInfosPlainArgs(
            commodityCode = commodityCode,
            dbInstanceId = dbInstanceId,
            infos = infos,
            orderType = orderType,
            outputFile = outputFile,
        )
        return getInstanceClassInfosResultToKotlin(getInstanceClassInfosPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceClassInfos].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetInstanceClassInfosPlainArgs].
     * @return A collection of values returned by getInstanceClassInfos.
     */
    public suspend fun getInstanceClassInfos(argument: suspend GetInstanceClassInfosPlainArgsBuilder.() -> Unit): GetInstanceClassInfosResult {
        val builder = GetInstanceClassInfosPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceClassInfosResultToKotlin(getInstanceClassInfosPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the RDS instance classes resource available info of Alibaba Cloud.
     * > **NOTE:** Available in v1.46.0+
     * ## Example Usage
     * ```tf
     * data "alicloud_db_instance_classes" "resources" {
     *   instance_charge_type = "PostPaid"
     *   engine               = "MySQL"
     *   engine_version       = "5.6"
     *   output_file          = "./classes.txt"
     * }
     * output "first_db_instance_class" {
     *   value = "${data.alicloud_db_instance_classes.resources.instance_classes.0.instance_class}"
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstanceClasses.
     * @return A collection of values returned by getInstanceClasses.
     */
    public suspend fun getInstanceClasses(argument: GetInstanceClassesPlainArgs): GetInstanceClassesResult =
        getInstanceClassesResultToKotlin(getInstanceClassesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceClasses].
     * @param category DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`, `serverless_basic`, `serverless_standard`, `serverless_ha`, `cluster`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
     * @param commodityCode The commodity code of the instance. Valid values:
     * * **bards**: The instance is a pay-as-you-go primary instance. This value is available on the China site (aliyun.com).
     * * **rds**: The instance is a subscription primary instance. This value is available on the China site (aliyun.com).
     * * **rords**: The instance is a pay-as-you-go read-only instance. This value is available on the China site (aliyun.com).
     * * **rds_rordspre_public_cn**: The instance is a subscription read-only instance. This value is available on the China site (aliyun.com).
     * * **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available on the International site (alibabacloud.com).
     * * **rds_intl**: The instance is a subscription primary instance. This value is available on the International site (alibabacloud.com).
     * * **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available on the International site (alibabacloud.com).
     * * **rds_rordspre_public_intl**: The instance is a subscription read-only instance. This value is available on the International site (alibabacloud.com).
     * * **rds_serverless_public_cn**: The instance is a subscription serverless instance. This value is available on the China site (aliyun.com).
     * * **rds_serverless_public_intl**: The instance is a subscription serverless instance. This value is available on the International site (alibabacloud.com).
     * > **NOTE**: The field `db_instance_id` will be ignored when `commodity_code` is not a read-only type.
     * @param dbInstanceClass The DB instance class type by the user.
     * @param dbInstanceId The ID of the instance.
     * > **NOTE**: The field `db_instance_id` will be ignored when `commodity_code` is not a read-only type.
     * @param dbInstanceStorageType The DB instance storage space required by the user. Valid values: "cloud_ssd", "local_ssd", "cloud_essd", "cloud_essd2", "cloud_essd3".
     * @param engine Database type. Valid values:"MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
     * @param engineVersion Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
     * @param instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid` and `Serverless`. Default to `PostPaid`.
     * @param multiZone Whether to show multi available zone. Default false to not show multi availability zone.
     * @param outputFile File name where to save data source results (after running `pulumi up`).
     * @param sortedBy
     * @param storageType It has been deprecated from version 1.134.0+ and using `db_instance_storage_type` instead.
     * @param zoneId The Zone to launch the DB instance.
     * @return A collection of values returned by getInstanceClasses.
     */
    public suspend fun getInstanceClasses(
        category: String? = null,
        commodityCode: String? = null,
        dbInstanceClass: String? = null,
        dbInstanceId: String? = null,
        dbInstanceStorageType: String? = null,
        engine: String? = null,
        engineVersion: String? = null,
        instanceChargeType: String? = null,
        multiZone: Boolean? = null,
        outputFile: String? = null,
        sortedBy: String? = null,
        storageType: String? = null,
        zoneId: String? = null,
    ): GetInstanceClassesResult {
        val argument = GetInstanceClassesPlainArgs(
            category = category,
            commodityCode = commodityCode,
            dbInstanceClass = dbInstanceClass,
            dbInstanceId = dbInstanceId,
            dbInstanceStorageType = dbInstanceStorageType,
            engine = engine,
            engineVersion = engineVersion,
            instanceChargeType = instanceChargeType,
            multiZone = multiZone,
            outputFile = outputFile,
            sortedBy = sortedBy,
            storageType = storageType,
            zoneId = zoneId,
        )
        return getInstanceClassesResultToKotlin(getInstanceClassesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceClasses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetInstanceClassesPlainArgs].
     * @return A collection of values returned by getInstanceClasses.
     */
    public suspend fun getInstanceClasses(argument: suspend GetInstanceClassesPlainArgsBuilder.() -> Unit): GetInstanceClassesResult {
        val builder = GetInstanceClassesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceClassesResultToKotlin(getInstanceClassesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the RDS instance engines resource available info of Alibaba Cloud.
     * > **NOTE:** Available in v1.46.0+
     * ## Example Usage
     * ```tf
     * data "alicloud_db_instance_engines" "resources" {
     *   instance_charge_type = "PostPaid"
     *   engine               = "MySQL"
     *   engine_version       = "5.6"
     *   output_file          = "./engines.txt"
     * }
     * output "first_db_category" {
     *   value = "${data.alicloud_db_instance_engines.resources.instance_engines.0.category}"
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstanceEngines.
     * @return A collection of values returned by getInstanceEngines.
     */
    public suspend fun getInstanceEngines(argument: GetInstanceEnginesPlainArgs): GetInstanceEnginesResult =
        getInstanceEnginesResultToKotlin(getInstanceEnginesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceEngines].
     * @param category DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
     * @param dbInstanceStorageType The DB instance storage space required by the user. Valid values: "cloud_ssd", "local_ssd", "cloud_essd", "cloud_essd2", "cloud_essd3".
     * @param engine Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
     * @param engineVersion Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
     * @param instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
     * @param multiZone Whether to show multi available zone. Default false to not show multi availability zone.
     * @param outputFile File name where to save data source results (after running `pulumi up`).
     * @param zoneId The Zone to launch the DB instance.
     * @return A collection of values returned by getInstanceEngines.
     */
    public suspend fun getInstanceEngines(
        category: String? = null,
        dbInstanceStorageType: String? = null,
        engine: String? = null,
        engineVersion: String? = null,
        instanceChargeType: String? = null,
        multiZone: Boolean? = null,
        outputFile: String? = null,
        zoneId: String? = null,
    ): GetInstanceEnginesResult {
        val argument = GetInstanceEnginesPlainArgs(
            category = category,
            dbInstanceStorageType = dbInstanceStorageType,
            engine = engine,
            engineVersion = engineVersion,
            instanceChargeType = instanceChargeType,
            multiZone = multiZone,
            outputFile = outputFile,
            zoneId = zoneId,
        )
        return getInstanceEnginesResultToKotlin(getInstanceEnginesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceEngines].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetInstanceEnginesPlainArgs].
     * @return A collection of values returned by getInstanceEngines.
     */
    public suspend fun getInstanceEngines(argument: suspend GetInstanceEnginesPlainArgsBuilder.() -> Unit): GetInstanceEnginesResult {
        val builder = GetInstanceEnginesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceEnginesResultToKotlin(getInstanceEnginesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `alicloud.rds.getInstances` data source provides a collection of RDS instances available in Alibaba Cloud account.
     * Filters support regular expression for the instance name, searches by tags, and other filters which are listed below.
     * > **NOTE:** Available since v1.7.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const dbInstancesDs = alicloud.rds.getInstances({
     *     nameRegex: "data-\\d+",
     *     status: "Running",
     *     tags: {
     *         type: "database",
     *         size: "tiny",
     *     },
     * });
     * export const firstDbInstanceId = dbInstancesDs.then(dbInstancesDs => dbInstancesDs.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * db_instances_ds = alicloud.rds.get_instances(name_regex="data-\\d+",
     *     status="Running",
     *     tags={
     *         "type": "database",
     *         "size": "tiny",
     *     })
     * pulumi.export("firstDbInstanceId", db_instances_ds.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var dbInstancesDs = AliCloud.Rds.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "data-\\d+",
     *         Status = "Running",
     *         Tags =
     *         {
     *             { "type", "database" },
     *             { "size", "tiny" },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDbInstanceId"] = dbInstancesDs&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		dbInstancesDs, err := rds.GetInstances(ctx, &rds.GetInstancesArgs{
     * 			NameRegex: pulumi.StringRef("data-\\d+"),
     * 			Status:    pulumi.StringRef("Running"),
     * 			Tags: map[string]interface{}{
     * 				"type": "database",
     * 				"size": "tiny",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDbInstanceId", dbInstancesDs.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var dbInstancesDs = RdsFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("data-\\d+")
     *             .status("Running")
     *             .tags(Map.ofEntries(
     *                 Map.entry("type", "database"),
     *                 Map.entry("size", "tiny")
     *             ))
     *             .build());
     *         ctx.export("firstDbInstanceId", dbInstancesDs.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   dbInstancesDs:
     *     fn::invoke:
     *       Function: alicloud:rds:getInstances
     *       Arguments:
     *         nameRegex: data-\d+
     *         status: Running
     *         tags:
     *           type: database
     *           size: tiny
     * outputs:
     *   firstDbInstanceId: ${dbInstancesDs.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param connectionMode `Standard` for standard access mode and `Safe` for high security access mode.
     * @param dbType `Primary` for primary instance, `Readonly` for read-only instance, `Guard` for disaster recovery instance, and `Temp` for temporary instance.
     * @param enableDetails Default to `false`. Set it to `true` can output parameter template about resource attributes.
     * @param engine Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`. If no value is specified, all types are returned.
     * @param ids A list of RDS instance IDs.
     * @param nameRegex A regex string to filter results by instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status Status of the instance.
     * @param tags A map of tags assigned to the DB instances.
     * Note: Before 1.60.0, the value's format is a `json` string which including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `"{\"key1\":\"value1\"}"`
     * @param vpcId Used to retrieve instances belong to specified VPC.
     * @param vswitchId Used to retrieve instances belong to specified `vswitch` resources.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        connectionMode: String? = null,
        dbType: String? = null,
        enableDetails: Boolean? = null,
        engine: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
        vswitchId: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            connectionMode = connectionMode,
            dbType = dbType,
            enableDetails = enableDetails,
            engine = engine,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
            tags = tags,
            vpcId = vpcId,
            vswitchId = vswitchId,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Rds Modify Parameter Logs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.174.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.rds.getModifyParameterLogs({
     *     dbInstanceId: "example_value",
     *     startTime: "2022-06-04T13:56Z",
     *     endTime: "2022-06-08T13:56Z",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.rds.get_modify_parameter_logs(db_instance_id="example_value",
     *     start_time="2022-06-04T13:56Z",
     *     end_time="2022-06-08T13:56Z")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Rds.GetModifyParameterLogs.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *         StartTime = "2022-06-04T13:56Z",
     *         EndTime = "2022-06-08T13:56Z",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetModifyParameterLogs(ctx, &rds.GetModifyParameterLogsArgs{
     * 			DbInstanceId: "example_value",
     * 			StartTime:    "2022-06-04T13:56Z",
     * 			EndTime:      "2022-06-08T13:56Z",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetModifyParameterLogsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getModifyParameterLogs(GetModifyParameterLogsArgs.builder()
     *             .dbInstanceId("example_value")
     *             .startTime("2022-06-04T13:56Z")
     *             .endTime("2022-06-08T13:56Z")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:rds:getModifyParameterLogs
     *       Arguments:
     *         dbInstanceId: example_value
     *         startTime: 2022-06-04T13:56Z
     *         endTime: 2022-06-08T13:56Z
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getModifyParameterLogs.
     * @return A collection of values returned by getModifyParameterLogs.
     */
    public suspend fun getModifyParameterLogs(argument: GetModifyParameterLogsPlainArgs): GetModifyParameterLogsResult =
        getModifyParameterLogsResultToKotlin(getModifyParameterLogsPlain(argument.toJava()).await())

    /**
     * @see [getModifyParameterLogs].
     * @param dbInstanceId The db instance id.
     * @param endTime The end time.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param startTime The start time.
     * @return A collection of values returned by getModifyParameterLogs.
     */
    public suspend fun getModifyParameterLogs(
        dbInstanceId: String,
        endTime: String,
        outputFile: String? = null,
        startTime: String,
    ): GetModifyParameterLogsResult {
        val argument = GetModifyParameterLogsPlainArgs(
            dbInstanceId = dbInstanceId,
            endTime = endTime,
            outputFile = outputFile,
            startTime = startTime,
        )
        return getModifyParameterLogsResultToKotlin(getModifyParameterLogsPlain(argument.toJava()).await())
    }

    /**
     * @see [getModifyParameterLogs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetModifyParameterLogsPlainArgs].
     * @return A collection of values returned by getModifyParameterLogs.
     */
    public suspend fun getModifyParameterLogs(argument: suspend GetModifyParameterLogsPlainArgsBuilder.() -> Unit): GetModifyParameterLogsResult {
        val builder = GetModifyParameterLogsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getModifyParameterLogsResultToKotlin(getModifyParameterLogsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Rds Backups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.149.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.rds.getRdsBackups({
     *     dbInstanceId: "example_value",
     * });
     * export const firstRdsBackupId = example.then(example => example.backups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.rds.get_rds_backups(db_instance_id="example_value")
     * pulumi.export("firstRdsBackupId", example.backups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Rds.GetRdsBackups.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRdsBackupId"] = example&#46;Apply(getRdsBackupsResult => getRdsBackupsResult&#46;Backups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := rds.GetRdsBackups(ctx, &rds.GetRdsBackupsArgs{
     * 			DbInstanceId: "example_value",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRdsBackupId", example.Backups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetRdsBackupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getRdsBackups(GetRdsBackupsArgs.builder()
     *             .dbInstanceId("example_value")
     *             .build());
     *         ctx.export("firstRdsBackupId", example.applyValue(getRdsBackupsResult -> getRdsBackupsResult.backups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:rds:getRdsBackups
     *       Arguments:
     *         dbInstanceId: example_value
     * outputs:
     *   firstRdsBackupId: ${example.backups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRdsBackups.
     * @return A collection of values returned by getRdsBackups.
     */
    public suspend fun getRdsBackups(argument: GetRdsBackupsPlainArgs): GetRdsBackupsResult =
        getRdsBackupsResultToKotlin(getRdsBackupsPlain(argument.toJava()).await())

    /**
     * @see [getRdsBackups].
     * @param backupMode BackupMode. Valid values: `Automated` and `Manual`.
     * @param backupStatus Backup task status. Valid values: `Automated` and `Manual`.
     * @param dbInstanceId The db instance id.
     * @param endTime The end time.
     * @param ids A list of Backup IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param startTime The start time.
     * @return A collection of values returned by getRdsBackups.
     */
    public suspend fun getRdsBackups(
        backupMode: String? = null,
        backupStatus: String? = null,
        dbInstanceId: String,
        endTime: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        startTime: String? = null,
    ): GetRdsBackupsResult {
        val argument = GetRdsBackupsPlainArgs(
            backupMode = backupMode,
            backupStatus = backupStatus,
            dbInstanceId = dbInstanceId,
            endTime = endTime,
            ids = ids,
            outputFile = outputFile,
            startTime = startTime,
        )
        return getRdsBackupsResultToKotlin(getRdsBackupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRdsBackups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetRdsBackupsPlainArgs].
     * @return A collection of values returned by getRdsBackups.
     */
    public suspend fun getRdsBackups(argument: suspend GetRdsBackupsPlainArgsBuilder.() -> Unit): GetRdsBackupsResult {
        val builder = GetRdsBackupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRdsBackupsResultToKotlin(getRdsBackupsPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getRdsParameterGroups.
     * @return A collection of values returned by getRdsParameterGroups.
     */
    public suspend fun getRdsParameterGroups(argument: GetRdsParameterGroupsPlainArgs): GetRdsParameterGroupsResult =
        getRdsParameterGroupsResultToKotlin(getRdsParameterGroupsPlain(argument.toJava()).await())

    /**
     * @see [getRdsParameterGroups].
     * @param enableDetails
     * @param ids
     * @param nameRegex
     * @param outputFile
     * @return A collection of values returned by getRdsParameterGroups.
     */
    public suspend fun getRdsParameterGroups(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetRdsParameterGroupsResult {
        val argument = GetRdsParameterGroupsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getRdsParameterGroupsResultToKotlin(getRdsParameterGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRdsParameterGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetRdsParameterGroupsPlainArgs].
     * @return A collection of values returned by getRdsParameterGroups.
     */
    public suspend fun getRdsParameterGroups(argument: suspend GetRdsParameterGroupsPlainArgsBuilder.() -> Unit): GetRdsParameterGroupsResult {
        val builder = GetRdsParameterGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRdsParameterGroupsResultToKotlin(getRdsParameterGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Rds Replication Slots of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.204.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.rds.getSlots({
     *     dbInstanceId: "example_value",
     * });
     * export const firstRdsSlotsName = example.then(example => example.slots?.[0]?.slotName);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.rds.get_slots(db_instance_id="example_value")
     * pulumi.export("firstRdsSlotsName", example.slots[0].slot_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Rds.GetSlots.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRdsSlotsName"] = example&#46;Apply(getSlotsResult => getSlotsResult&#46;Slots[0]?.SlotName),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := rds.GetSlots(ctx, &rds.GetSlotsArgs{
     * 			DbInstanceId: "example_value",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRdsSlotsName", example.Slots[0].SlotName)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetSlotsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getSlots(GetSlotsArgs.builder()
     *             .dbInstanceId("example_value")
     *             .build());
     *         ctx.export("firstRdsSlotsName", example.applyValue(getSlotsResult -> getSlotsResult.slots()[0].slotName()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:rds:getSlots
     *       Arguments:
     *         dbInstanceId: example_value
     * outputs:
     *   firstRdsSlotsName: ${example.slots[0].slotName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSlots.
     * @return A collection of values returned by getSlots.
     */
    public suspend fun getSlots(argument: GetSlotsPlainArgs): GetSlotsResult =
        getSlotsResultToKotlin(getSlotsPlain(argument.toJava()).await())

    /**
     * @see [getSlots].
     * @param dbInstanceId The db instance id.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The resource group id.
     * @return A collection of values returned by getSlots.
     */
    public suspend fun getSlots(
        dbInstanceId: String,
        outputFile: String? = null,
        resourceGroupId: String? = null,
    ): GetSlotsResult {
        val argument = GetSlotsPlainArgs(
            dbInstanceId = dbInstanceId,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
        )
        return getSlotsResultToKotlin(getSlotsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSlots].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetSlotsPlainArgs].
     * @return A collection of values returned by getSlots.
     */
    public suspend fun getSlots(argument: suspend GetSlotsPlainArgsBuilder.() -> Unit): GetSlotsResult {
        val builder = GetSlotsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSlotsResultToKotlin(getSlotsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for RDS that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available since v1.73.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.rds.getZones({
     *     engine: "MySQL",
     *     engineVersion: "8.0",
     *     instanceChargeType: "PostPaid",
     *     category: "Basic",
     *     dbInstanceStorageType: "cloud_essd",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.rds.get_zones(engine="MySQL",
     *     engine_version="8.0",
     *     instance_charge_type="PostPaid",
     *     category="Basic",
     *     db_instance_storage_type="cloud_essd")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Rds.GetZones.Invoke(new()
     *     {
     *         Engine = "MySQL",
     *         EngineVersion = "8.0",
     *         InstanceChargeType = "PostPaid",
     *         Category = "Basic",
     *         DbInstanceStorageType = "cloud_essd",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetZones(ctx, &rds.GetZonesArgs{
     * 			Engine:                pulumi.StringRef("MySQL"),
     * 			EngineVersion:         pulumi.StringRef("8.0"),
     * 			InstanceChargeType:    pulumi.StringRef("PostPaid"),
     * 			Category:              pulumi.StringRef("Basic"),
     * 			DbInstanceStorageType: pulumi.StringRef("cloud_essd"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rds.RdsFunctions;
     * import com.pulumi.alicloud.rds.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getZones(GetZonesArgs.builder()
     *             .engine("MySQL")
     *             .engineVersion("8.0")
     *             .instanceChargeType("PostPaid")
     *             .category("Basic")
     *             .dbInstanceStorageType("cloud_essd")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:rds:getZones
     *       Arguments:
     *         engine: MySQL
     *         engineVersion: '8.0'
     *         instanceChargeType: PostPaid
     *         category: Basic
     *         dbInstanceStorageType: cloud_essd
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param category DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`, `serverless_basic`, `serverless_standard`, `serverless_ha`, `cluster`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
     * @param dbInstanceStorageType The DB instance storage space required by the user. Valid values: "cloud_ssd", "local_ssd", "cloud_essd", "cloud_essd2", "cloud_essd3".
     * @param engine Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
     * @param engineVersion Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
     * @param instanceChargeType Filter the results by a specific instance charge type. Valid values: `PrePaid` and `PostPaid` and `Serverless`. Default to `PostPaid`.
     * @param multi It has been deprecated from version 1.137.0 and using `multi_zone` instead.
     * @param multiZone Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch RDS instances.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(
        category: String? = null,
        dbInstanceStorageType: String? = null,
        engine: String? = null,
        engineVersion: String? = null,
        instanceChargeType: String? = null,
        multi: Boolean? = null,
        multiZone: Boolean? = null,
        outputFile: String? = null,
    ): GetZonesResult {
        val argument = GetZonesPlainArgs(
            category = category,
            dbInstanceStorageType = dbInstanceStorageType,
            engine = engine,
            engineVersion = engineVersion,
            instanceChargeType = instanceChargeType,
            multi = multi,
            multiZone = multiZone,
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rds&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
