@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.kotlin.outputs.RdsParameterGroupParamDetail
import com.pulumi.alicloud.rds.kotlin.outputs.RdsParameterGroupParamDetail.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RdsParameterGroup].
 */
@PulumiTagMarker
public class RdsParameterGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RdsParameterGroupArgs = RdsParameterGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RdsParameterGroupArgsBuilder.() -> Unit) {
        val builder = RdsParameterGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RdsParameterGroup {
        val builtJavaResource = com.pulumi.alicloud.rds.RdsParameterGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RdsParameterGroup(builtJavaResource)
    }
}

/**
 * Provides a RDS Parameter Group resource.
 * For information about RDS Parameter Group and how to use it, see [What is Parameter Group](https://www.alibabacloud.com/help/en/doc-detail/144839.htm).
 * > **NOTE:** Available since v1.119.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.rds.RdsParameterGroup("default", {
 *     engine: "mysql",
 *     engineVersion: "5.7",
 *     paramDetails: [
 *         {
 *             paramName: "back_log",
 *             paramValue: "4000",
 *         },
 *         {
 *             paramName: "wait_timeout",
 *             paramValue: "86460",
 *         },
 *     ],
 *     parameterGroupDesc: name,
 *     parameterGroupName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.rds.RdsParameterGroup("default",
 *     engine="mysql",
 *     engine_version="5.7",
 *     param_details=[
 *         {
 *             "param_name": "back_log",
 *             "param_value": "4000",
 *         },
 *         {
 *             "param_name": "wait_timeout",
 *             "param_value": "86460",
 *         },
 *     ],
 *     parameter_group_desc=name,
 *     parameter_group_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.Rds.RdsParameterGroup("default", new()
 *     {
 *         Engine = "mysql",
 *         EngineVersion = "5.7",
 *         ParamDetails = new[]
 *         {
 *             new AliCloud.Rds.Inputs.RdsParameterGroupParamDetailArgs
 *             {
 *                 ParamName = "back_log",
 *                 ParamValue = "4000",
 *             },
 *             new AliCloud.Rds.Inputs.RdsParameterGroupParamDetailArgs
 *             {
 *                 ParamName = "wait_timeout",
 *                 ParamValue = "86460",
 *             },
 *         },
 *         ParameterGroupDesc = name,
 *         ParameterGroupName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := rds.NewRdsParameterGroup(ctx, "default", &rds.RdsParameterGroupArgs{
 * 			Engine:        pulumi.String("mysql"),
 * 			EngineVersion: pulumi.String("5.7"),
 * 			ParamDetails: rds.RdsParameterGroupParamDetailArray{
 * 				&rds.RdsParameterGroupParamDetailArgs{
 * 					ParamName:  pulumi.String("back_log"),
 * 					ParamValue: pulumi.String("4000"),
 * 				},
 * 				&rds.RdsParameterGroupParamDetailArgs{
 * 					ParamName:  pulumi.String("wait_timeout"),
 * 					ParamValue: pulumi.String("86460"),
 * 				},
 * 			},
 * 			ParameterGroupDesc: pulumi.String(name),
 * 			ParameterGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.RdsParameterGroup;
 * import com.pulumi.alicloud.rds.RdsParameterGroupArgs;
 * import com.pulumi.alicloud.rds.inputs.RdsParameterGroupParamDetailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new RdsParameterGroup("default", RdsParameterGroupArgs.builder()
 *             .engine("mysql")
 *             .engineVersion("5.7")
 *             .paramDetails(
 *                 RdsParameterGroupParamDetailArgs.builder()
 *                     .paramName("back_log")
 *                     .paramValue("4000")
 *                     .build(),
 *                 RdsParameterGroupParamDetailArgs.builder()
 *                     .paramName("wait_timeout")
 *                     .paramValue("86460")
 *                     .build())
 *             .parameterGroupDesc(name)
 *             .parameterGroupName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:rds:RdsParameterGroup
 *     properties:
 *       engine: mysql
 *       engineVersion: '5.7'
 *       paramDetails:
 *         - paramName: back_log
 *           paramValue: '4000'
 *         - paramName: wait_timeout
 *           paramValue: '86460'
 *       parameterGroupDesc: ${name}
 *       parameterGroupName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS Parameter Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/rdsParameterGroup:RdsParameterGroup example <id>
 * ```
 */
public class RdsParameterGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.rds.RdsParameterGroup,
) : KotlinCustomResource(javaResource, RdsParameterGroupMapper) {
    /**
     * The database engine. Valid values: `mysql`, `mariadb`, `PostgreSQL`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The version of the database engine. Valid values: mysql: `5.1`, `5.5`, `5.6`, `5.7`, `8.0`; mariadb: `10.3`; PostgreSQL: `10.0`, `11.0`, `12.0`, `13.0`, `14.0`, `15.0`.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Parameter list. See `param_detail` below.
     */
    public val paramDetails: Output<List<RdsParameterGroupParamDetail>>
        get() = javaResource.paramDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The description of the parameter template.
     */
    public val parameterGroupDesc: Output<String>?
        get() = javaResource.parameterGroupDesc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the parameter template.
     */
    public val parameterGroupName: Output<String>
        get() = javaResource.parameterGroupName().applyValue({ args0 -> args0 })
}

public object RdsParameterGroupMapper : ResourceMapper<RdsParameterGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rds.RdsParameterGroup::class == javaResource::class

    override fun map(javaResource: Resource): RdsParameterGroup = RdsParameterGroup(
        javaResource as
            com.pulumi.alicloud.rds.RdsParameterGroup,
    )
}

/**
 * @see [RdsParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RdsParameterGroup].
 */
public suspend fun rdsParameterGroup(
    name: String,
    block: suspend RdsParameterGroupResourceBuilder.() -> Unit,
): RdsParameterGroup {
    val builder = RdsParameterGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RdsParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rdsParameterGroup(name: String): RdsParameterGroup {
    val builder = RdsParameterGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
