@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.RdsParameterGroupArgs.builder
import com.pulumi.alicloud.rds.kotlin.inputs.RdsParameterGroupParamDetailArgs
import com.pulumi.alicloud.rds.kotlin.inputs.RdsParameterGroupParamDetailArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a RDS Parameter Group resource.
 * For information about RDS Parameter Group and how to use it, see [What is Parameter Group](https://www.alibabacloud.com/help/en/doc-detail/144839.htm).
 * > **NOTE:** Available since v1.119.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.rds.RdsParameterGroup("default", {
 *     engine: "mysql",
 *     engineVersion: "5.7",
 *     paramDetails: [
 *         {
 *             paramName: "back_log",
 *             paramValue: "4000",
 *         },
 *         {
 *             paramName: "wait_timeout",
 *             paramValue: "86460",
 *         },
 *     ],
 *     parameterGroupDesc: name,
 *     parameterGroupName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.rds.RdsParameterGroup("default",
 *     engine="mysql",
 *     engine_version="5.7",
 *     param_details=[
 *         {
 *             "param_name": "back_log",
 *             "param_value": "4000",
 *         },
 *         {
 *             "param_name": "wait_timeout",
 *             "param_value": "86460",
 *         },
 *     ],
 *     parameter_group_desc=name,
 *     parameter_group_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.Rds.RdsParameterGroup("default", new()
 *     {
 *         Engine = "mysql",
 *         EngineVersion = "5.7",
 *         ParamDetails = new[]
 *         {
 *             new AliCloud.Rds.Inputs.RdsParameterGroupParamDetailArgs
 *             {
 *                 ParamName = "back_log",
 *                 ParamValue = "4000",
 *             },
 *             new AliCloud.Rds.Inputs.RdsParameterGroupParamDetailArgs
 *             {
 *                 ParamName = "wait_timeout",
 *                 ParamValue = "86460",
 *             },
 *         },
 *         ParameterGroupDesc = name,
 *         ParameterGroupName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := rds.NewRdsParameterGroup(ctx, "default", &rds.RdsParameterGroupArgs{
 * 			Engine:        pulumi.String("mysql"),
 * 			EngineVersion: pulumi.String("5.7"),
 * 			ParamDetails: rds.RdsParameterGroupParamDetailArray{
 * 				&rds.RdsParameterGroupParamDetailArgs{
 * 					ParamName:  pulumi.String("back_log"),
 * 					ParamValue: pulumi.String("4000"),
 * 				},
 * 				&rds.RdsParameterGroupParamDetailArgs{
 * 					ParamName:  pulumi.String("wait_timeout"),
 * 					ParamValue: pulumi.String("86460"),
 * 				},
 * 			},
 * 			ParameterGroupDesc: pulumi.String(name),
 * 			ParameterGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.RdsParameterGroup;
 * import com.pulumi.alicloud.rds.RdsParameterGroupArgs;
 * import com.pulumi.alicloud.rds.inputs.RdsParameterGroupParamDetailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new RdsParameterGroup("default", RdsParameterGroupArgs.builder()
 *             .engine("mysql")
 *             .engineVersion("5.7")
 *             .paramDetails(
 *                 RdsParameterGroupParamDetailArgs.builder()
 *                     .paramName("back_log")
 *                     .paramValue("4000")
 *                     .build(),
 *                 RdsParameterGroupParamDetailArgs.builder()
 *                     .paramName("wait_timeout")
 *                     .paramValue("86460")
 *                     .build())
 *             .parameterGroupDesc(name)
 *             .parameterGroupName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:rds:RdsParameterGroup
 *     properties:
 *       engine: mysql
 *       engineVersion: '5.7'
 *       paramDetails:
 *         - paramName: back_log
 *           paramValue: '4000'
 *         - paramName: wait_timeout
 *           paramValue: '86460'
 *       parameterGroupDesc: ${name}
 *       parameterGroupName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS Parameter Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/rdsParameterGroup:RdsParameterGroup example <id>
 * ```
 * @property engine The database engine. Valid values: `mysql`, `mariadb`, `PostgreSQL`.
 * @property engineVersion The version of the database engine. Valid values: mysql: `5.1`, `5.5`, `5.6`, `5.7`, `8.0`; mariadb: `10.3`; PostgreSQL: `10.0`, `11.0`, `12.0`, `13.0`, `14.0`, `15.0`.
 * @property paramDetails Parameter list. See `param_detail` below.
 * @property parameterGroupDesc The description of the parameter template.
 * @property parameterGroupName The name of the parameter template.
 */
public data class RdsParameterGroupArgs(
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val paramDetails: Output<List<RdsParameterGroupParamDetailArgs>>? = null,
    public val parameterGroupDesc: Output<String>? = null,
    public val parameterGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.RdsParameterGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.RdsParameterGroupArgs =
        com.pulumi.alicloud.rds.RdsParameterGroupArgs.builder()
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .paramDetails(
                paramDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parameterGroupDesc(parameterGroupDesc?.applyValue({ args0 -> args0 }))
            .parameterGroupName(parameterGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsParameterGroupArgs].
 */
@PulumiTagMarker
public class RdsParameterGroupArgsBuilder internal constructor() {
    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var paramDetails: Output<List<RdsParameterGroupParamDetailArgs>>? = null

    private var parameterGroupDesc: Output<String>? = null

    private var parameterGroupName: Output<String>? = null

    /**
     * @param value The database engine. Valid values: `mysql`, `mariadb`, `PostgreSQL`.
     */
    @JvmName("kpripyysfvvfqktk")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The version of the database engine. Valid values: mysql: `5.1`, `5.5`, `5.6`, `5.7`, `8.0`; mariadb: `10.3`; PostgreSQL: `10.0`, `11.0`, `12.0`, `13.0`, `14.0`, `15.0`.
     */
    @JvmName("yjuttvswyqpgetjj")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Parameter list. See `param_detail` below.
     */
    @JvmName("nvouuylrnsgecwpg")
    public suspend fun paramDetails(`value`: Output<List<RdsParameterGroupParamDetailArgs>>) {
        this.paramDetails = value
    }

    @JvmName("xhcbwlqjvtttvtcy")
    public suspend fun paramDetails(vararg values: Output<RdsParameterGroupParamDetailArgs>) {
        this.paramDetails = Output.all(values.asList())
    }

    /**
     * @param values Parameter list. See `param_detail` below.
     */
    @JvmName("ecywskhehrolnwce")
    public suspend fun paramDetails(values: List<Output<RdsParameterGroupParamDetailArgs>>) {
        this.paramDetails = Output.all(values)
    }

    /**
     * @param value The description of the parameter template.
     */
    @JvmName("ucdgpkaisuustjnt")
    public suspend fun parameterGroupDesc(`value`: Output<String>) {
        this.parameterGroupDesc = value
    }

    /**
     * @param value The name of the parameter template.
     */
    @JvmName("gkyquphqtiutuiob")
    public suspend fun parameterGroupName(`value`: Output<String>) {
        this.parameterGroupName = value
    }

    /**
     * @param value The database engine. Valid values: `mysql`, `mariadb`, `PostgreSQL`.
     */
    @JvmName("skumosfsrchjkene")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The version of the database engine. Valid values: mysql: `5.1`, `5.5`, `5.6`, `5.7`, `8.0`; mariadb: `10.3`; PostgreSQL: `10.0`, `11.0`, `12.0`, `13.0`, `14.0`, `15.0`.
     */
    @JvmName("oivwgpemmgnnuqgx")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Parameter list. See `param_detail` below.
     */
    @JvmName("aqwypnblvfaruopb")
    public suspend fun paramDetails(`value`: List<RdsParameterGroupParamDetailArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paramDetails = mapped
    }

    /**
     * @param argument Parameter list. See `param_detail` below.
     */
    @JvmName("dihuwmpeypoyoklu")
    public suspend fun paramDetails(argument: List<suspend RdsParameterGroupParamDetailArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RdsParameterGroupParamDetailArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.paramDetails = mapped
    }

    /**
     * @param argument Parameter list. See `param_detail` below.
     */
    @JvmName("fevqpagnnrkmmbtj")
    public suspend fun paramDetails(vararg argument: suspend RdsParameterGroupParamDetailArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RdsParameterGroupParamDetailArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.paramDetails = mapped
    }

    /**
     * @param argument Parameter list. See `param_detail` below.
     */
    @JvmName("epnnqnemqfnixdlu")
    public suspend fun paramDetails(argument: suspend RdsParameterGroupParamDetailArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RdsParameterGroupParamDetailArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.paramDetails = mapped
    }

    /**
     * @param values Parameter list. See `param_detail` below.
     */
    @JvmName("lbejwtnplfpeyhnh")
    public suspend fun paramDetails(vararg values: RdsParameterGroupParamDetailArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramDetails = mapped
    }

    /**
     * @param value The description of the parameter template.
     */
    @JvmName("mvpqvsboiawatnar")
    public suspend fun parameterGroupDesc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterGroupDesc = mapped
    }

    /**
     * @param value The name of the parameter template.
     */
    @JvmName("nwduqjubcoavsqev")
    public suspend fun parameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterGroupName = mapped
    }

    internal fun build(): RdsParameterGroupArgs = RdsParameterGroupArgs(
        engine = engine,
        engineVersion = engineVersion,
        paramDetails = paramDetails,
        parameterGroupDesc = parameterGroupDesc,
        parameterGroupName = parameterGroupName,
    )
}
