@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RdsServiceLinkedRole].
 */
@PulumiTagMarker
public class RdsServiceLinkedRoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RdsServiceLinkedRoleArgs = RdsServiceLinkedRoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RdsServiceLinkedRoleArgsBuilder.() -> Unit) {
        val builder = RdsServiceLinkedRoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RdsServiceLinkedRole {
        val builtJavaResource = com.pulumi.alicloud.rds.RdsServiceLinkedRole(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RdsServiceLinkedRole(builtJavaResource)
    }
}

/**
 * Provides a RDS Service Linked Role.
 * For information about RDS Service Linked Role and how to use it, see [What is Service Linked Role&#46;](https://www.alibabacloud.com/help/en/doc-detail/171226.htm).
 * > **NOTE:** Available since v1.189.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.rds.RdsServiceLinkedRole("default", {serviceName: "AliyunServiceRoleForRdsPgsqlOnEcs"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.rds.RdsServiceLinkedRole("default", service_name="AliyunServiceRoleForRdsPgsqlOnEcs")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Rds.RdsServiceLinkedRole("default", new()
 *     {
 *         ServiceName = "AliyunServiceRoleForRdsPgsqlOnEcs",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewRdsServiceLinkedRole(ctx, "default", &rds.RdsServiceLinkedRoleArgs{
 * 			ServiceName: pulumi.String("AliyunServiceRoleForRdsPgsqlOnEcs"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.RdsServiceLinkedRole;
 * import com.pulumi.alicloud.rds.RdsServiceLinkedRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new RdsServiceLinkedRole("default", RdsServiceLinkedRoleArgs.builder()
 *             .serviceName("AliyunServiceRoleForRdsPgsqlOnEcs")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:rds:RdsServiceLinkedRole
 *     properties:
 *       serviceName: AliyunServiceRoleForRdsPgsqlOnEcs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS Service Linked Role can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/rdsServiceLinkedRole:RdsServiceLinkedRole default <service_name>
 * ```
 */
public class RdsServiceLinkedRole internal constructor(
    override val javaResource: com.pulumi.alicloud.rds.RdsServiceLinkedRole,
) : KotlinCustomResource(javaResource, RdsServiceLinkedRoleMapper) {
    /**
     * The Alibaba Cloud Resource Name (ARN) of the role.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the role.
     */
    public val roleId: Output<String>
        get() = javaResource.roleId().applyValue({ args0 -> args0 })

    /**
     * The name of the role.
     */
    public val roleName: Output<String>
        get() = javaResource.roleName().applyValue({ args0 -> args0 })

    /**
     * The product name for SLR. RDS can automatically create the following service-linked roles: `AliyunServiceRoleForRdsPgsqlOnEcs`, `AliyunServiceRoleForRDSProxyOnEcs`.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })
}

public object RdsServiceLinkedRoleMapper : ResourceMapper<RdsServiceLinkedRole> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rds.RdsServiceLinkedRole::class == javaResource::class

    override fun map(javaResource: Resource): RdsServiceLinkedRole = RdsServiceLinkedRole(
        javaResource
            as com.pulumi.alicloud.rds.RdsServiceLinkedRole,
    )
}

/**
 * @see [RdsServiceLinkedRole].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RdsServiceLinkedRole].
 */
public suspend fun rdsServiceLinkedRole(
    name: String,
    block: suspend RdsServiceLinkedRoleResourceBuilder.() -> Unit,
): RdsServiceLinkedRole {
    val builder = RdsServiceLinkedRoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RdsServiceLinkedRole].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rdsServiceLinkedRole(name: String): RdsServiceLinkedRole {
    val builder = RdsServiceLinkedRoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
