@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin

import com.pulumi.alicloud.rds.RdsServiceLinkedRoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RDS Service Linked Role.
 * For information about RDS Service Linked Role and how to use it, see [What is Service Linked Role&#46;](https://www.alibabacloud.com/help/en/doc-detail/171226.htm).
 * > **NOTE:** Available since v1.189.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.rds.RdsServiceLinkedRole("default", {serviceName: "AliyunServiceRoleForRdsPgsqlOnEcs"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.rds.RdsServiceLinkedRole("default", service_name="AliyunServiceRoleForRdsPgsqlOnEcs")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Rds.RdsServiceLinkedRole("default", new()
 *     {
 *         ServiceName = "AliyunServiceRoleForRdsPgsqlOnEcs",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewRdsServiceLinkedRole(ctx, "default", &rds.RdsServiceLinkedRoleArgs{
 * 			ServiceName: pulumi.String("AliyunServiceRoleForRdsPgsqlOnEcs"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rds.RdsServiceLinkedRole;
 * import com.pulumi.alicloud.rds.RdsServiceLinkedRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new RdsServiceLinkedRole("default", RdsServiceLinkedRoleArgs.builder()
 *             .serviceName("AliyunServiceRoleForRdsPgsqlOnEcs")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:rds:RdsServiceLinkedRole
 *     properties:
 *       serviceName: AliyunServiceRoleForRdsPgsqlOnEcs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS Service Linked Role can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rds/rdsServiceLinkedRole:RdsServiceLinkedRole default <service_name>
 * ```
 * @property serviceName The product name for SLR. RDS can automatically create the following service-linked roles: `AliyunServiceRoleForRdsPgsqlOnEcs`, `AliyunServiceRoleForRDSProxyOnEcs`.
 */
public data class RdsServiceLinkedRoleArgs(
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.RdsServiceLinkedRoleArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.RdsServiceLinkedRoleArgs =
        com.pulumi.alicloud.rds.RdsServiceLinkedRoleArgs.builder()
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsServiceLinkedRoleArgs].
 */
@PulumiTagMarker
public class RdsServiceLinkedRoleArgsBuilder internal constructor() {
    private var serviceName: Output<String>? = null

    /**
     * @param value The product name for SLR. RDS can automatically create the following service-linked roles: `AliyunServiceRoleForRdsPgsqlOnEcs`, `AliyunServiceRoleForRDSProxyOnEcs`.
     */
    @JvmName("joytidfxijfqxhoe")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The product name for SLR. RDS can automatically create the following service-linked roles: `AliyunServiceRoleForRdsPgsqlOnEcs`, `AliyunServiceRoleForRDSProxyOnEcs`.
     */
    @JvmName("qgolunjgxjirtsjw")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): RdsServiceLinkedRoleArgs = RdsServiceLinkedRoleArgs(
        serviceName = serviceName,
    )
}
