@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.DbInstanceEndpointNodeItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nodeId The ID of the node.
 * @property weight The weight of the node. Read requests are distributed based on the weight.Valid values: 0 to 100.
 */
public data class DbInstanceEndpointNodeItemArgs(
    public val nodeId: Output<String>,
    public val weight: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.DbInstanceEndpointNodeItemArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.DbInstanceEndpointNodeItemArgs =
        com.pulumi.alicloud.rds.inputs.DbInstanceEndpointNodeItemArgs.builder()
            .nodeId(nodeId.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbInstanceEndpointNodeItemArgs].
 */
@PulumiTagMarker
public class DbInstanceEndpointNodeItemArgsBuilder internal constructor() {
    private var nodeId: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The ID of the node.
     */
    @JvmName("eacnwrinqqayywgl")
    public suspend fun nodeId(`value`: Output<String>) {
        this.nodeId = value
    }

    /**
     * @param value The weight of the node. Read requests are distributed based on the weight.Valid values: 0 to 100.
     */
    @JvmName("tpyqngomefvlclxk")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The ID of the node.
     */
    @JvmName("ixueopeptjblpete")
    public suspend fun nodeId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeId = mapped
    }

    /**
     * @param value The weight of the node. Read requests are distributed based on the weight.Valid values: 0 to 100.
     */
    @JvmName("xanmfstekgapqteb")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): DbInstanceEndpointNodeItemArgs = DbInstanceEndpointNodeItemArgs(
        nodeId = nodeId ?: throw PulumiNullFieldException("nodeId"),
        weight = weight ?: throw PulumiNullFieldException("weight"),
    )
}
