@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetCharacterSetNamesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCharacterSetNames.
 * @property engine Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`.
 * @property outputFile
 */
public data class GetCharacterSetNamesPlainArgs(
    public val engine: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetCharacterSetNamesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetCharacterSetNamesPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetCharacterSetNamesPlainArgs.builder()
            .engine(engine.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCharacterSetNamesPlainArgs].
 */
@PulumiTagMarker
public class GetCharacterSetNamesPlainArgsBuilder internal constructor() {
    private var engine: String? = null

    private var outputFile: String? = null

    /**
     * @param value Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`.
     */
    @JvmName("vgttgofhocpdhtfh")
    public suspend fun engine(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value
     */
    @JvmName("bjskmlqdeniohnvl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetCharacterSetNamesPlainArgs = GetCharacterSetNamesPlainArgs(
        engine = engine ?: throw PulumiNullFieldException("engine"),
        outputFile = outputFile,
    )
}
