@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetClassDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClassDetails.
 * @property classCode The code of the instance type.
 * @property commodityCode The commodity code of the instance. Valid values:
 * * **bards**: The instance is a pay-as-you-go primary instance. This value is available on the China site (aliyun.com).
 * * **rds**: The instance is a subscription primary instance. This value is available on the China site (aliyun.com).
 * * **rords**: The instance is a pay-as-you-go read-only instance. This value is available on the China site (aliyun.com).
 * * **rds_rordspre_public_cn**: The instance is a subscription read-only instance. This value is available on the China site (aliyun.com).
 * * **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available on the International site (alibabacloud.com).
 * * **rds_intl**: The instance is a subscription primary instance. This value is available on the International site (alibabacloud.com).
 * * **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available on the International site (alibabacloud.com).
 * * **rds_rordspre_public_intl**: The instance is a subscription read-only instance. This value is available on the International site (alibabacloud.com).
 * @property engine Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
 * @property engineVersion Database version. Value options:
 * - MySQL: [ 5&#46;5、5&#46;6、5&#46;7、8&#46;0 ]
 * - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
 * - PostgreSQL: [ 10&#46;0、11&#46;0、12&#46;0、13&#46;0、14&#46;0、15&#46;0 ]
 * - MariaDB: [ 10&#46;3 ]
 */
public data class GetClassDetailsPlainArgs(
    public val classCode: String,
    public val commodityCode: String,
    public val engine: String,
    public val engineVersion: String,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetClassDetailsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetClassDetailsPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetClassDetailsPlainArgs.builder()
            .classCode(classCode.let({ args0 -> args0 }))
            .commodityCode(commodityCode.let({ args0 -> args0 }))
            .engine(engine.let({ args0 -> args0 }))
            .engineVersion(engineVersion.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClassDetailsPlainArgs].
 */
@PulumiTagMarker
public class GetClassDetailsPlainArgsBuilder internal constructor() {
    private var classCode: String? = null

    private var commodityCode: String? = null

    private var engine: String? = null

    private var engineVersion: String? = null

    /**
     * @param value The code of the instance type.
     */
    @JvmName("pjteuihrewhcwhmr")
    public suspend fun classCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.classCode = mapped
    }

    /**
     * @param value The commodity code of the instance. Valid values:
     * * **bards**: The instance is a pay-as-you-go primary instance. This value is available on the China site (aliyun.com).
     * * **rds**: The instance is a subscription primary instance. This value is available on the China site (aliyun.com).
     * * **rords**: The instance is a pay-as-you-go read-only instance. This value is available on the China site (aliyun.com).
     * * **rds_rordspre_public_cn**: The instance is a subscription read-only instance. This value is available on the China site (aliyun.com).
     * * **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available on the International site (alibabacloud.com).
     * * **rds_intl**: The instance is a subscription primary instance. This value is available on the International site (alibabacloud.com).
     * * **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available on the International site (alibabacloud.com).
     * * **rds_rordspre_public_intl**: The instance is a subscription read-only instance. This value is available on the International site (alibabacloud.com).
     */
    @JvmName("iihgluhayqwqwyar")
    public suspend fun commodityCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.commodityCode = mapped
    }

    /**
     * @param value Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
     */
    @JvmName("bxlloiktsdsevktr")
    public suspend fun engine(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Database version. Value options:
     * - MySQL: [ 5&#46;5、5&#46;6、5&#46;7、8&#46;0 ]
     * - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
     * - PostgreSQL: [ 10&#46;0、11&#46;0、12&#46;0、13&#46;0、14&#46;0、15&#46;0 ]
     * - MariaDB: [ 10&#46;3 ]
     */
    @JvmName("rywpttptvsqjphuj")
    public suspend fun engineVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    internal fun build(): GetClassDetailsPlainArgs = GetClassDetailsPlainArgs(
        classCode = classCode ?: throw PulumiNullFieldException("classCode"),
        commodityCode = commodityCode ?: throw PulumiNullFieldException("commodityCode"),
        engine = engine ?: throw PulumiNullFieldException("engine"),
        engineVersion = engineVersion ?: throw PulumiNullFieldException("engineVersion"),
    )
}
