@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetCollationTimeZonesCollationTimeZone.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The code of the instance type.
 * @property standardTimeOffset The offset of the UTC time. The offset is in the following format: (UTC+<i>HH:mm</i>).
 * @property timeZone The time zone that is available for use in ApsaraDB RDS.
 */
public data class GetCollationTimeZonesCollationTimeZone(
    public val description: String? = null,
    public val standardTimeOffset: String? = null,
    public val timeZone: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetCollationTimeZonesCollationTimeZone> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetCollationTimeZonesCollationTimeZone =
        com.pulumi.alicloud.rds.inputs.GetCollationTimeZonesCollationTimeZone.builder()
            .description(description?.let({ args0 -> args0 }))
            .standardTimeOffset(standardTimeOffset?.let({ args0 -> args0 }))
            .timeZone(timeZone?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCollationTimeZonesCollationTimeZone].
 */
@PulumiTagMarker
public class GetCollationTimeZonesCollationTimeZoneBuilder internal constructor() {
    private var description: String? = null

    private var standardTimeOffset: String? = null

    private var timeZone: String? = null

    /**
     * @param value The code of the instance type.
     */
    @JvmName("kqhoppjpacyxhoco")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value The offset of the UTC time. The offset is in the following format: (UTC+<i>HH:mm</i>).
     */
    @JvmName("doltqncsjwdqvevh")
    public suspend fun standardTimeOffset(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.standardTimeOffset = mapped
    }

    /**
     * @param value The time zone that is available for use in ApsaraDB RDS.
     */
    @JvmName("wxfsrrpnpwbpkakq")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.timeZone = mapped
    }

    internal fun build(): GetCollationTimeZonesCollationTimeZone =
        GetCollationTimeZonesCollationTimeZone(
            description = description,
            standardTimeOffset = standardTimeOffset,
            timeZone = timeZone,
        )
}
