@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetCollationTimeZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCollationTimeZones.
 * @property collationTimeZones An array that consists of the character set collations and time zones that are available for
 * use in ApsaraDB RDS.
 * @property outputFile File name where to save data source results (after running `pulumi up`).
 */
public data class GetCollationTimeZonesPlainArgs(
    public val collationTimeZones: List<GetCollationTimeZonesCollationTimeZone>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetCollationTimeZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetCollationTimeZonesPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetCollationTimeZonesPlainArgs.builder()
            .collationTimeZones(
                collationTimeZones?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCollationTimeZonesPlainArgs].
 */
@PulumiTagMarker
public class GetCollationTimeZonesPlainArgsBuilder internal constructor() {
    private var collationTimeZones: List<GetCollationTimeZonesCollationTimeZone>? = null

    private var outputFile: String? = null

    /**
     * @param value An array that consists of the character set collations and time zones that are available for
     * use in ApsaraDB RDS.
     */
    @JvmName("reocooikwthtlulm")
    public suspend fun collationTimeZones(`value`: List<GetCollationTimeZonesCollationTimeZone>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.collationTimeZones = mapped
    }

    /**
     * @param argument An array that consists of the character set collations and time zones that are available for
     * use in ApsaraDB RDS.
     */
    @JvmName("vrxwlxdrtkyfieou")
    public suspend fun collationTimeZones(argument: List<suspend GetCollationTimeZonesCollationTimeZoneBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCollationTimeZonesCollationTimeZoneBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.collationTimeZones = mapped
    }

    /**
     * @param argument An array that consists of the character set collations and time zones that are available for
     * use in ApsaraDB RDS.
     */
    @JvmName("jimdjkeqkttayxpw")
    public suspend fun collationTimeZones(vararg argument: suspend GetCollationTimeZonesCollationTimeZoneBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCollationTimeZonesCollationTimeZoneBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.collationTimeZones = mapped
    }

    /**
     * @param argument An array that consists of the character set collations and time zones that are available for
     * use in ApsaraDB RDS.
     */
    @JvmName("npnvnwrbphnjskcq")
    public suspend fun collationTimeZones(argument: suspend GetCollationTimeZonesCollationTimeZoneBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetCollationTimeZonesCollationTimeZoneBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.collationTimeZones = mapped
    }

    /**
     * @param values An array that consists of the character set collations and time zones that are available for
     * use in ApsaraDB RDS.
     */
    @JvmName("dmeywxgltfrfuree")
    public suspend fun collationTimeZones(vararg values: GetCollationTimeZonesCollationTimeZone) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.collationTimeZones = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi up`).
     */
    @JvmName("omdijcffebxotfuw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetCollationTimeZonesPlainArgs = GetCollationTimeZonesPlainArgs(
        collationTimeZones = collationTimeZones,
        outputFile = outputFile,
    )
}
