@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetCrossRegionBackupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCrossRegionBackups.
 * @property backupId The ID of the cross-region data backup file.
 * @property crossBackupId The ID of the cross-region data backup file.
 * @property crossBackupRegion The ID of the destination region where the cross-region data backup file is stored.
 * > **NOTE:** Note You must specify the `cross_backup_id` parameter. Alternatively, you must specify the `start_time` and `end_time` parameters.
 * @property dbInstanceId The db instance id.
 * @property endTime The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
 * @property ids A list of Cross Region Backup IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the resource group.
 * @property startTime The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
 */
public data class GetCrossRegionBackupsPlainArgs(
    public val backupId: String? = null,
    public val crossBackupId: String? = null,
    public val crossBackupRegion: String? = null,
    public val dbInstanceId: String,
    public val endTime: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val startTime: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetCrossRegionBackupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetCrossRegionBackupsPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetCrossRegionBackupsPlainArgs.builder()
            .backupId(backupId?.let({ args0 -> args0 }))
            .crossBackupId(crossBackupId?.let({ args0 -> args0 }))
            .crossBackupRegion(crossBackupRegion?.let({ args0 -> args0 }))
            .dbInstanceId(dbInstanceId.let({ args0 -> args0 }))
            .endTime(endTime?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .startTime(startTime?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCrossRegionBackupsPlainArgs].
 */
@PulumiTagMarker
public class GetCrossRegionBackupsPlainArgsBuilder internal constructor() {
    private var backupId: String? = null

    private var crossBackupId: String? = null

    private var crossBackupRegion: String? = null

    private var dbInstanceId: String? = null

    private var endTime: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var startTime: String? = null

    /**
     * @param value The ID of the cross-region data backup file.
     */
    @JvmName("xbtficnixtiyrebr")
    public suspend fun backupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.backupId = mapped
    }

    /**
     * @param value The ID of the cross-region data backup file.
     */
    @JvmName("vsueitlfvpmybkau")
    public suspend fun crossBackupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.crossBackupId = mapped
    }

    /**
     * @param value The ID of the destination region where the cross-region data backup file is stored.
     * > **NOTE:** Note You must specify the `cross_backup_id` parameter. Alternatively, you must specify the `start_time` and `end_time` parameters.
     */
    @JvmName("wngwjbvwyieifgyt")
    public suspend fun crossBackupRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.crossBackupRegion = mapped
    }

    /**
     * @param value The db instance id.
     */
    @JvmName("ubbxxufkmliwsvwd")
    public suspend fun dbInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbInstanceId = mapped
    }

    /**
     * @param value The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     */
    @JvmName("foivmwcgbgnqufkg")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endTime = mapped
    }

    /**
     * @param value A list of Cross Region Backup IDs.
     */
    @JvmName("daqsyyaxtrdstrxp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Cross Region Backup IDs.
     */
    @JvmName("hdaegrksgixrafbo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bkkmbffkpnpplmqo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("arnmiotahmrtrqxn")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
     */
    @JvmName("xlmwaaaujmlvscll")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startTime = mapped
    }

    internal fun build(): GetCrossRegionBackupsPlainArgs = GetCrossRegionBackupsPlainArgs(
        backupId = backupId,
        crossBackupId = crossBackupId,
        crossBackupRegion = crossBackupRegion,
        dbInstanceId = dbInstanceId ?: throw PulumiNullFieldException("dbInstanceId"),
        endTime = endTime,
        ids = ids,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        startTime = startTime,
    )
}
