@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetCrossRegionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCrossRegions.
 * @property outputFile
 */
public data class GetCrossRegionsPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetCrossRegionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetCrossRegionsPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetCrossRegionsPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCrossRegionsPlainArgs].
 */
@PulumiTagMarker
public class GetCrossRegionsPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value
     */
    @JvmName("fmwsnrkhirktgdct")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetCrossRegionsPlainArgs = GetCrossRegionsPlainArgs(
        outputFile = outputFile,
    )
}
