@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetInstanceClassInfosInfo.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property classCode The code of the instance type.
 * @property classGroup The instance family of the instance.
 * @property cpu The number of cores that are supported by the instance type. Unit: cores.
 * @property instructionSetArch The architecture of the instance type.
 * @property maxConnections The maximum number of connections that are supported by the instance type. Unit: connections.
 * @property maxIombps The maximum I/O bandwidth that is supported by the instance type. Unit: Mbit/s.
 * @property maxIops The maximum input/output operations per second (IOPS) that is supported by the instance type. Unit: operations per second.
 * @property memoryClass The memory capacity that is supported by the instance type. Unit: GB.
 * @property referencePrice The fee that you must pay for the instance type. Unit: cent (USD).
 */
public data class GetInstanceClassInfosInfo(
    public val classCode: String? = null,
    public val classGroup: String? = null,
    public val cpu: String? = null,
    public val instructionSetArch: String? = null,
    public val maxConnections: String? = null,
    public val maxIombps: String? = null,
    public val maxIops: String? = null,
    public val memoryClass: String? = null,
    public val referencePrice: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetInstanceClassInfosInfo> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetInstanceClassInfosInfo =
        com.pulumi.alicloud.rds.inputs.GetInstanceClassInfosInfo.builder()
            .classCode(classCode?.let({ args0 -> args0 }))
            .classGroup(classGroup?.let({ args0 -> args0 }))
            .cpu(cpu?.let({ args0 -> args0 }))
            .instructionSetArch(instructionSetArch?.let({ args0 -> args0 }))
            .maxConnections(maxConnections?.let({ args0 -> args0 }))
            .maxIombps(maxIombps?.let({ args0 -> args0 }))
            .maxIops(maxIops?.let({ args0 -> args0 }))
            .memoryClass(memoryClass?.let({ args0 -> args0 }))
            .referencePrice(referencePrice?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceClassInfosInfo].
 */
@PulumiTagMarker
public class GetInstanceClassInfosInfoBuilder internal constructor() {
    private var classCode: String? = null

    private var classGroup: String? = null

    private var cpu: String? = null

    private var instructionSetArch: String? = null

    private var maxConnections: String? = null

    private var maxIombps: String? = null

    private var maxIops: String? = null

    private var memoryClass: String? = null

    private var referencePrice: String? = null

    /**
     * @param value The code of the instance type.
     */
    @JvmName("rubkckhwubarspba")
    public suspend fun classCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.classCode = mapped
    }

    /**
     * @param value The instance family of the instance.
     */
    @JvmName("arogyonpgnhgudjq")
    public suspend fun classGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.classGroup = mapped
    }

    /**
     * @param value The number of cores that are supported by the instance type. Unit: cores.
     */
    @JvmName("eddrkujihakexorh")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cpu = mapped
    }

    /**
     * @param value The architecture of the instance type.
     */
    @JvmName("asywxhspqjmxfbru")
    public suspend fun instructionSetArch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instructionSetArch = mapped
    }

    /**
     * @param value The maximum number of connections that are supported by the instance type. Unit: connections.
     */
    @JvmName("shjvatkydpkadntq")
    public suspend fun maxConnections(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.maxConnections = mapped
    }

    /**
     * @param value The maximum I/O bandwidth that is supported by the instance type. Unit: Mbit/s.
     */
    @JvmName("kidbdbwkdqfcrxbg")
    public suspend fun maxIombps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.maxIombps = mapped
    }

    /**
     * @param value The maximum input/output operations per second (IOPS) that is supported by the instance type. Unit: operations per second.
     */
    @JvmName("emgeocaogpxqpbci")
    public suspend fun maxIops(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.maxIops = mapped
    }

    /**
     * @param value The memory capacity that is supported by the instance type. Unit: GB.
     */
    @JvmName("piqqhxoedncknyhi")
    public suspend fun memoryClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.memoryClass = mapped
    }

    /**
     * @param value The fee that you must pay for the instance type. Unit: cent (USD).
     */
    @JvmName("ttrcodrkvqanwfwp")
    public suspend fun referencePrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.referencePrice = mapped
    }

    internal fun build(): GetInstanceClassInfosInfo = GetInstanceClassInfosInfo(
        classCode = classCode,
        classGroup = classGroup,
        cpu = cpu,
        instructionSetArch = instructionSetArch,
        maxConnections = maxConnections,
        maxIombps = maxIombps,
        maxIops = maxIops,
        memoryClass = memoryClass,
        referencePrice = referencePrice,
    )
}
