@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetInstanceClassInfosPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceClassInfos.
 * @property commodityCode The commodity code of the instance. Valid values:
 * * **bards**: The instance is a pay-as-you-go primary instance. This value is available on the China site (aliyun.com).
 * * **rds**: The instance is a subscription primary instance. This value is available on the China site (aliyun.com).
 * * **rords**: The instance is a pay-as-you-go read-only instance. This value is available on the China site (aliyun.com).
 * * **rds_rordspre_public_cn**: The instance is a subscription read-only instance. This value is available on the China site (aliyun.com).
 * * **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available on the International site (alibabacloud.com).
 * * **rds_intl**: The instance is a subscription primary instance. This value is available on the International site (alibabacloud.com).
 * * **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available on the International site (alibabacloud.com).
 * * **rds_rordspre_public_intl**: The instance is a subscription read-only instance. This value is available on the International site (alibabacloud.com).
 * @property dbInstanceId The ID of the primary instance.
 * @property infos A list of Rds available resource. Each element contains the following attributes:
 * @property orderType FThe type of order that you want to query. Valid values:
 * * **BUY**: specifies the query orders that are used to purchase instances.
 * * **UPGRADE**: specifies the query orders that are used to change the specifications of instances.
 * * **RENEW**: specifies the query orders that are used to renew instances.
 * * **CONVERT**: specifies the query orders that are used to change the billing methods of instances.
 * @property outputFile File name where to save data source results (after running `pulumi up`).
 * > **NOTE**: If you use the CommodityCode parameter to query the instance types that are available to read-only instances, you must specify the DBInstanceId parameter.
 */
public data class GetInstanceClassInfosPlainArgs(
    public val commodityCode: String,
    public val dbInstanceId: String? = null,
    public val infos: List<GetInstanceClassInfosInfo>? = null,
    public val orderType: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetInstanceClassInfosPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetInstanceClassInfosPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetInstanceClassInfosPlainArgs.builder()
            .commodityCode(commodityCode.let({ args0 -> args0 }))
            .dbInstanceId(dbInstanceId?.let({ args0 -> args0 }))
            .infos(infos?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .orderType(orderType.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceClassInfosPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceClassInfosPlainArgsBuilder internal constructor() {
    private var commodityCode: String? = null

    private var dbInstanceId: String? = null

    private var infos: List<GetInstanceClassInfosInfo>? = null

    private var orderType: String? = null

    private var outputFile: String? = null

    /**
     * @param value The commodity code of the instance. Valid values:
     * * **bards**: The instance is a pay-as-you-go primary instance. This value is available on the China site (aliyun.com).
     * * **rds**: The instance is a subscription primary instance. This value is available on the China site (aliyun.com).
     * * **rords**: The instance is a pay-as-you-go read-only instance. This value is available on the China site (aliyun.com).
     * * **rds_rordspre_public_cn**: The instance is a subscription read-only instance. This value is available on the China site (aliyun.com).
     * * **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available on the International site (alibabacloud.com).
     * * **rds_intl**: The instance is a subscription primary instance. This value is available on the International site (alibabacloud.com).
     * * **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available on the International site (alibabacloud.com).
     * * **rds_rordspre_public_intl**: The instance is a subscription read-only instance. This value is available on the International site (alibabacloud.com).
     */
    @JvmName("anptrlnkjfwgsirh")
    public suspend fun commodityCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.commodityCode = mapped
    }

    /**
     * @param value The ID of the primary instance.
     */
    @JvmName("yelrpijlpfmjagve")
    public suspend fun dbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceId = mapped
    }

    /**
     * @param value A list of Rds available resource. Each element contains the following attributes:
     */
    @JvmName("kfvpnbugerxdbkwp")
    public suspend fun infos(`value`: List<GetInstanceClassInfosInfo>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.infos = mapped
    }

    /**
     * @param argument A list of Rds available resource. Each element contains the following attributes:
     */
    @JvmName("irfcrrblxindpyxa")
    public suspend fun infos(argument: List<suspend GetInstanceClassInfosInfoBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetInstanceClassInfosInfoBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.infos = mapped
    }

    /**
     * @param argument A list of Rds available resource. Each element contains the following attributes:
     */
    @JvmName("ddkqjcikbrjoggfn")
    public suspend fun infos(vararg argument: suspend GetInstanceClassInfosInfoBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetInstanceClassInfosInfoBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.infos = mapped
    }

    /**
     * @param argument A list of Rds available resource. Each element contains the following attributes:
     */
    @JvmName("ktefvsynmdfulwsa")
    public suspend fun infos(argument: suspend GetInstanceClassInfosInfoBuilder.() -> Unit) {
        val toBeMapped = listOf(GetInstanceClassInfosInfoBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.infos = mapped
    }

    /**
     * @param values A list of Rds available resource. Each element contains the following attributes:
     */
    @JvmName("jnivuqmucegkyuuv")
    public suspend fun infos(vararg values: GetInstanceClassInfosInfo) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.infos = mapped
    }

    /**
     * @param value FThe type of order that you want to query. Valid values:
     * * **BUY**: specifies the query orders that are used to purchase instances.
     * * **UPGRADE**: specifies the query orders that are used to change the specifications of instances.
     * * **RENEW**: specifies the query orders that are used to renew instances.
     * * **CONVERT**: specifies the query orders that are used to change the billing methods of instances.
     */
    @JvmName("whasbyhhotwuahdx")
    public suspend fun orderType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.orderType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi up`).
     * > **NOTE**: If you use the CommodityCode parameter to query the instance types that are available to read-only instances, you must specify the DBInstanceId parameter.
     */
    @JvmName("ptomsixtgbsgyaqc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetInstanceClassInfosPlainArgs = GetInstanceClassInfosPlainArgs(
        commodityCode = commodityCode ?: throw PulumiNullFieldException("commodityCode"),
        dbInstanceId = dbInstanceId,
        infos = infos,
        orderType = orderType ?: throw PulumiNullFieldException("orderType"),
        outputFile = outputFile,
    )
}
