@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetInstanceClassesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceClasses.
 * @property category DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`, `serverless_basic`, `serverless_standard`, `serverless_ha`, `cluster`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
 * @property commodityCode The commodity code of the instance. Valid values:
 * * **bards**: The instance is a pay-as-you-go primary instance. This value is available on the China site (aliyun.com).
 * * **rds**: The instance is a subscription primary instance. This value is available on the China site (aliyun.com).
 * * **rords**: The instance is a pay-as-you-go read-only instance. This value is available on the China site (aliyun.com).
 * * **rds_rordspre_public_cn**: The instance is a subscription read-only instance. This value is available on the China site (aliyun.com).
 * * **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available on the International site (alibabacloud.com).
 * * **rds_intl**: The instance is a subscription primary instance. This value is available on the International site (alibabacloud.com).
 * * **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available on the International site (alibabacloud.com).
 * * **rds_rordspre_public_intl**: The instance is a subscription read-only instance. This value is available on the International site (alibabacloud.com).
 * * **rds_serverless_public_cn**: The instance is a subscription serverless instance. This value is available on the China site (aliyun.com).
 * * **rds_serverless_public_intl**: The instance is a subscription serverless instance. This value is available on the International site (alibabacloud.com).
 * > **NOTE**: The field `db_instance_id` will be ignored when `commodity_code` is not a read-only type.
 * @property dbInstanceClass The DB instance class type by the user.
 * @property dbInstanceId The ID of the instance.
 * > **NOTE**: The field `db_instance_id` will be ignored when `commodity_code` is not a read-only type.
 * @property dbInstanceStorageType The DB instance storage space required by the user. Valid values: "cloud_ssd", "local_ssd", "cloud_essd", "cloud_essd2", "cloud_essd3".
 * @property engine Database type. Valid values:"MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
 * @property engineVersion Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
 * @property instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid` and `Serverless`. Default to `PostPaid`.
 * @property multiZone Whether to show multi available zone. Default false to not show multi availability zone.
 * @property outputFile File name where to save data source results (after running `pulumi up`).
 * @property sortedBy
 * @property storageType It has been deprecated from version 1.134.0+ and using `db_instance_storage_type` instead.
 * @property zoneId The Zone to launch the DB instance.
 */
public data class GetInstanceClassesPlainArgs(
    public val category: String? = null,
    public val commodityCode: String? = null,
    public val dbInstanceClass: String? = null,
    public val dbInstanceId: String? = null,
    public val dbInstanceStorageType: String? = null,
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val instanceChargeType: String? = null,
    public val multiZone: Boolean? = null,
    public val outputFile: String? = null,
    public val sortedBy: String? = null,
    public val storageType: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetInstanceClassesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetInstanceClassesPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetInstanceClassesPlainArgs.builder()
            .category(category?.let({ args0 -> args0 }))
            .commodityCode(commodityCode?.let({ args0 -> args0 }))
            .dbInstanceClass(dbInstanceClass?.let({ args0 -> args0 }))
            .dbInstanceId(dbInstanceId?.let({ args0 -> args0 }))
            .dbInstanceStorageType(dbInstanceStorageType?.let({ args0 -> args0 }))
            .engine(engine?.let({ args0 -> args0 }))
            .engineVersion(engineVersion?.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.let({ args0 -> args0 }))
            .multiZone(multiZone?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .sortedBy(sortedBy?.let({ args0 -> args0 }))
            .storageType(storageType?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceClassesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceClassesPlainArgsBuilder internal constructor() {
    private var category: String? = null

    private var commodityCode: String? = null

    private var dbInstanceClass: String? = null

    private var dbInstanceId: String? = null

    private var dbInstanceStorageType: String? = null

    private var engine: String? = null

    private var engineVersion: String? = null

    private var instanceChargeType: String? = null

    private var multiZone: Boolean? = null

    private var outputFile: String? = null

    private var sortedBy: String? = null

    private var storageType: String? = null

    private var zoneId: String? = null

    /**
     * @param value DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`, `serverless_basic`, `serverless_standard`, `serverless_ha`, `cluster`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
     */
    @JvmName("pxxlkratyximtasp")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value The commodity code of the instance. Valid values:
     * * **bards**: The instance is a pay-as-you-go primary instance. This value is available on the China site (aliyun.com).
     * * **rds**: The instance is a subscription primary instance. This value is available on the China site (aliyun.com).
     * * **rords**: The instance is a pay-as-you-go read-only instance. This value is available on the China site (aliyun.com).
     * * **rds_rordspre_public_cn**: The instance is a subscription read-only instance. This value is available on the China site (aliyun.com).
     * * **bards_intl**: The instance is a pay-as-you-go primary instance. This value is available on the International site (alibabacloud.com).
     * * **rds_intl**: The instance is a subscription primary instance. This value is available on the International site (alibabacloud.com).
     * * **rords_intl**: The instance is a pay-as-you-go read-only instance. This value is available on the International site (alibabacloud.com).
     * * **rds_rordspre_public_intl**: The instance is a subscription read-only instance. This value is available on the International site (alibabacloud.com).
     * * **rds_serverless_public_cn**: The instance is a subscription serverless instance. This value is available on the China site (aliyun.com).
     * * **rds_serverless_public_intl**: The instance is a subscription serverless instance. This value is available on the International site (alibabacloud.com).
     * > **NOTE**: The field `db_instance_id` will be ignored when `commodity_code` is not a read-only type.
     */
    @JvmName("jtqdvrerwpmhgjhd")
    public suspend fun commodityCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.commodityCode = mapped
    }

    /**
     * @param value The DB instance class type by the user.
     */
    @JvmName("atpvaunoncjhnvqa")
    public suspend fun dbInstanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceClass = mapped
    }

    /**
     * @param value The ID of the instance.
     * > **NOTE**: The field `db_instance_id` will be ignored when `commodity_code` is not a read-only type.
     */
    @JvmName("wqgxisdqsccxoxww")
    public suspend fun dbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceId = mapped
    }

    /**
     * @param value The DB instance storage space required by the user. Valid values: "cloud_ssd", "local_ssd", "cloud_essd", "cloud_essd2", "cloud_essd3".
     */
    @JvmName("bdnrohjfqqrcsstk")
    public suspend fun dbInstanceStorageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceStorageType = mapped
    }

    /**
     * @param value Database type. Valid values:"MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
     */
    @JvmName("mnlhwesbroqjphtl")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
     */
    @JvmName("chgfouvigesnnhnj")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    /**
     * @param value Filter the results by charge type. Valid values: `PrePaid` and `PostPaid` and `Serverless`. Default to `PostPaid`.
     */
    @JvmName("cmassoqbdtsippst")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Whether to show multi available zone. Default false to not show multi availability zone.
     */
    @JvmName("qmobrdmtrshrqdpo")
    public suspend fun multiZone(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.multiZone = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi up`).
     */
    @JvmName("ynkvonmxslijvfxm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("candmsefnbsjlulv")
    public suspend fun sortedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortedBy = mapped
    }

    /**
     * @param value It has been deprecated from version 1.134.0+ and using `db_instance_storage_type` instead.
     */
    @JvmName("lmpgtiihrbfiwbjd")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.storageType = mapped
    }

    /**
     * @param value The Zone to launch the DB instance.
     */
    @JvmName("ynqegfmtgrvlvgsp")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetInstanceClassesPlainArgs = GetInstanceClassesPlainArgs(
        category = category,
        commodityCode = commodityCode,
        dbInstanceClass = dbInstanceClass,
        dbInstanceId = dbInstanceId,
        dbInstanceStorageType = dbInstanceStorageType,
        engine = engine,
        engineVersion = engineVersion,
        instanceChargeType = instanceChargeType,
        multiZone = multiZone,
        outputFile = outputFile,
        sortedBy = sortedBy,
        storageType = storageType,
        zoneId = zoneId,
    )
}
