@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetInstanceEnginesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceEngines.
 * @property category DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
 * @property dbInstanceStorageType The DB instance storage space required by the user. Valid values: "cloud_ssd", "local_ssd", "cloud_essd", "cloud_essd2", "cloud_essd3".
 * @property engine Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
 * @property engineVersion Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
 * @property instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
 * @property multiZone Whether to show multi available zone. Default false to not show multi availability zone.
 * @property outputFile File name where to save data source results (after running `pulumi up`).
 * @property zoneId The Zone to launch the DB instance.
 */
public data class GetInstanceEnginesPlainArgs(
    public val category: String? = null,
    public val dbInstanceStorageType: String? = null,
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val instanceChargeType: String? = null,
    public val multiZone: Boolean? = null,
    public val outputFile: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetInstanceEnginesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetInstanceEnginesPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetInstanceEnginesPlainArgs.builder()
            .category(category?.let({ args0 -> args0 }))
            .dbInstanceStorageType(dbInstanceStorageType?.let({ args0 -> args0 }))
            .engine(engine?.let({ args0 -> args0 }))
            .engineVersion(engineVersion?.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.let({ args0 -> args0 }))
            .multiZone(multiZone?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceEnginesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceEnginesPlainArgsBuilder internal constructor() {
    private var category: String? = null

    private var dbInstanceStorageType: String? = null

    private var engine: String? = null

    private var engineVersion: String? = null

    private var instanceChargeType: String? = null

    private var multiZone: Boolean? = null

    private var outputFile: String? = null

    private var zoneId: String? = null

    /**
     * @param value DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
     */
    @JvmName("ndudpprvxqdrcgmr")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value The DB instance storage space required by the user. Valid values: "cloud_ssd", "local_ssd", "cloud_essd", "cloud_essd2", "cloud_essd3".
     */
    @JvmName("lvkagavbdoggqqvr")
    public suspend fun dbInstanceStorageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceStorageType = mapped
    }

    /**
     * @param value Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
     */
    @JvmName("bsblqerowyqbjjib")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
     */
    @JvmName("weeepbdwhnbgtylu")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    /**
     * @param value Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
     */
    @JvmName("ojhoyjtdhjktidvr")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Whether to show multi available zone. Default false to not show multi availability zone.
     */
    @JvmName("bancejdwlurtqmuy")
    public suspend fun multiZone(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.multiZone = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi up`).
     */
    @JvmName("pvmlihonfabcijyq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Zone to launch the DB instance.
     */
    @JvmName("noabasojkkbogrrb")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetInstanceEnginesPlainArgs = GetInstanceEnginesPlainArgs(
        category = category,
        dbInstanceStorageType = dbInstanceStorageType,
        engine = engine,
        engineVersion = engineVersion,
        instanceChargeType = instanceChargeType,
        multiZone = multiZone,
        outputFile = outputFile,
        zoneId = zoneId,
    )
}
