@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetModifyParameterLogsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getModifyParameterLogs.
 * @property dbInstanceId The db instance id.
 * @property endTime The end time.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property startTime The start time.
 */
public data class GetModifyParameterLogsPlainArgs(
    public val dbInstanceId: String,
    public val endTime: String,
    public val outputFile: String? = null,
    public val startTime: String,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetModifyParameterLogsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetModifyParameterLogsPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetModifyParameterLogsPlainArgs.builder()
            .dbInstanceId(dbInstanceId.let({ args0 -> args0 }))
            .endTime(endTime.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .startTime(startTime.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetModifyParameterLogsPlainArgs].
 */
@PulumiTagMarker
public class GetModifyParameterLogsPlainArgsBuilder internal constructor() {
    private var dbInstanceId: String? = null

    private var endTime: String? = null

    private var outputFile: String? = null

    private var startTime: String? = null

    /**
     * @param value The db instance id.
     */
    @JvmName("jrbuithmiwaplbrn")
    public suspend fun dbInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbInstanceId = mapped
    }

    /**
     * @param value The end time.
     */
    @JvmName("yuhlwxytqnuysekn")
    public suspend fun endTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endTime = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("fvcfmalnwccrdqyo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The start time.
     */
    @JvmName("tknjvfwnyhdvyngf")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.startTime = mapped
    }

    internal fun build(): GetModifyParameterLogsPlainArgs = GetModifyParameterLogsPlainArgs(
        dbInstanceId = dbInstanceId ?: throw PulumiNullFieldException("dbInstanceId"),
        endTime = endTime ?: throw PulumiNullFieldException("endTime"),
        outputFile = outputFile,
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
    )
}
