@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetRdsBackupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRdsBackups.
 * @property backupMode BackupMode. Valid values: `Automated` and `Manual`.
 * @property backupStatus Backup task status. Valid values: `Automated` and `Manual`.
 * @property dbInstanceId The db instance id.
 * @property endTime The end time.
 * @property ids A list of Backup IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property startTime The start time.
 */
public data class GetRdsBackupsPlainArgs(
    public val backupMode: String? = null,
    public val backupStatus: String? = null,
    public val dbInstanceId: String,
    public val endTime: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val startTime: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetRdsBackupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetRdsBackupsPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetRdsBackupsPlainArgs.builder()
            .backupMode(backupMode?.let({ args0 -> args0 }))
            .backupStatus(backupStatus?.let({ args0 -> args0 }))
            .dbInstanceId(dbInstanceId.let({ args0 -> args0 }))
            .endTime(endTime?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .startTime(startTime?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRdsBackupsPlainArgs].
 */
@PulumiTagMarker
public class GetRdsBackupsPlainArgsBuilder internal constructor() {
    private var backupMode: String? = null

    private var backupStatus: String? = null

    private var dbInstanceId: String? = null

    private var endTime: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var startTime: String? = null

    /**
     * @param value BackupMode. Valid values: `Automated` and `Manual`.
     */
    @JvmName("dvcqgkrlcftlbwql")
    public suspend fun backupMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.backupMode = mapped
    }

    /**
     * @param value Backup task status. Valid values: `Automated` and `Manual`.
     */
    @JvmName("hohrfbfnjcibonrq")
    public suspend fun backupStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.backupStatus = mapped
    }

    /**
     * @param value The db instance id.
     */
    @JvmName("emcphsocekesjpdj")
    public suspend fun dbInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbInstanceId = mapped
    }

    /**
     * @param value The end time.
     */
    @JvmName("msqpkeonlkbvrade")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endTime = mapped
    }

    /**
     * @param value A list of Backup IDs.
     */
    @JvmName("patfovogvptjwxnt")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Backup IDs.
     */
    @JvmName("xlpccqplmhlyawmv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("vdacafxwaeelcdnv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The start time.
     */
    @JvmName("datvgumegahsrjcv")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startTime = mapped
    }

    internal fun build(): GetRdsBackupsPlainArgs = GetRdsBackupsPlainArgs(
        backupMode = backupMode,
        backupStatus = backupStatus,
        dbInstanceId = dbInstanceId ?: throw PulumiNullFieldException("dbInstanceId"),
        endTime = endTime,
        ids = ids,
        outputFile = outputFile,
        startTime = startTime,
    )
}
