@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetRdsParameterGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRdsParameterGroups.
 * @property enableDetails
 * @property ids
 * @property nameRegex
 * @property outputFile
 */
public data class GetRdsParameterGroupsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetRdsParameterGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetRdsParameterGroupsPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetRdsParameterGroupsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRdsParameterGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetRdsParameterGroupsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value
     */
    @JvmName("lcuorvybxdawlcnh")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value
     */
    @JvmName("bibimgncpgwppvyc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("wxcsxmicilrtlnjg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("udacpdaubfbowmvf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("cflnwhsiuwqeimsx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetRdsParameterGroupsPlainArgs = GetRdsParameterGroupsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
