@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetSlotsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSlots.
 * @property dbInstanceId The db instance id.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The resource group id.
 */
public data class GetSlotsPlainArgs(
    public val dbInstanceId: String,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetSlotsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetSlotsPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetSlotsPlainArgs.builder()
            .dbInstanceId(dbInstanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSlotsPlainArgs].
 */
@PulumiTagMarker
public class GetSlotsPlainArgsBuilder internal constructor() {
    private var dbInstanceId: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    /**
     * @param value The db instance id.
     */
    @JvmName("ilotaosvvqlafemf")
    public suspend fun dbInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbInstanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wjfisroqvnretxcr")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("gxosnmhfghjmnjag")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    internal fun build(): GetSlotsPlainArgs = GetSlotsPlainArgs(
        dbInstanceId = dbInstanceId ?: throw PulumiNullFieldException("dbInstanceId"),
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
    )
}
