@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.GetZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZones.
 * @property category DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`, `serverless_basic`, `serverless_standard`, `serverless_ha`, `cluster`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
 * @property dbInstanceStorageType The DB instance storage space required by the user. Valid values: "cloud_ssd", "local_ssd", "cloud_essd", "cloud_essd2", "cloud_essd3".
 * @property engine Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
 * @property engineVersion Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
 * @property instanceChargeType Filter the results by a specific instance charge type. Valid values: `PrePaid` and `PostPaid` and `Serverless`. Default to `PostPaid`.
 * @property multi It has been deprecated from version 1.137.0 and using `multi_zone` instead.
 * @property multiZone Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch RDS instances.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetZonesPlainArgs(
    public val category: String? = null,
    public val dbInstanceStorageType: String? = null,
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val instanceChargeType: String? = null,
    @Deprecated(
        message = """
  It has been deprecated from version 1.137.0 and using `multi_zone` instead.
  """,
    )
    public val multi: Boolean? = null,
    public val multiZone: Boolean? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.GetZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.GetZonesPlainArgs =
        com.pulumi.alicloud.rds.inputs.GetZonesPlainArgs.builder()
            .category(category?.let({ args0 -> args0 }))
            .dbInstanceStorageType(dbInstanceStorageType?.let({ args0 -> args0 }))
            .engine(engine?.let({ args0 -> args0 }))
            .engineVersion(engineVersion?.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.let({ args0 -> args0 }))
            .multi(multi?.let({ args0 -> args0 }))
            .multiZone(multiZone?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZonesPlainArgs].
 */
@PulumiTagMarker
public class GetZonesPlainArgsBuilder internal constructor() {
    private var category: String? = null

    private var dbInstanceStorageType: String? = null

    private var engine: String? = null

    private var engineVersion: String? = null

    private var instanceChargeType: String? = null

    private var multi: Boolean? = null

    private var multiZone: Boolean? = null

    private var outputFile: String? = null

    /**
     * @param value DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`, `serverless_basic`, `serverless_standard`, `serverless_ha`, `cluster`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
     */
    @JvmName("bsrqdhssdbdcuajf")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value The DB instance storage space required by the user. Valid values: "cloud_ssd", "local_ssd", "cloud_essd", "cloud_essd2", "cloud_essd3".
     */
    @JvmName("fggnyrjuurrttvdx")
    public suspend fun dbInstanceStorageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceStorageType = mapped
    }

    /**
     * @param value Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
     */
    @JvmName("jqjpumtmlybbtanh")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
     */
    @JvmName("yqmdqqilxrwnjexh")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    /**
     * @param value Filter the results by a specific instance charge type. Valid values: `PrePaid` and `PostPaid` and `Serverless`. Default to `PostPaid`.
     */
    @JvmName("nrgbufxkptctxkvr")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value It has been deprecated from version 1.137.0 and using `multi_zone` instead.
     */
    @Deprecated(
        message = """
  It has been deprecated from version 1.137.0 and using `multi_zone` instead.
  """,
    )
    @JvmName("percotcnfnfsjeme")
    public suspend fun multi(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.multi = mapped
    }

    /**
     * @param value Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch RDS instances.
     */
    @JvmName("kevyklitpyodcmal")
    public suspend fun multiZone(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.multiZone = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("howodsixjlmrbcsq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetZonesPlainArgs = GetZonesPlainArgs(
        category = category,
        dbInstanceStorageType = dbInstanceStorageType,
        engine = engine,
        engineVersion = engineVersion,
        instanceChargeType = instanceChargeType,
        multi = multi,
        multiZone = multiZone,
        outputFile = outputFile,
    )
}
