@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.InstanceBabelfishConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property babelfishEnabled specifies whether to enable the Babelfish for the instance. If you set this parameter to **true**, you enable Babelfish for the instance. If you leave this parameter empty, you disable Babelfish for the instance.
 * @property masterUserPassword The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters:! @ # $ % ^ & * () _ + - =
 * @property masterUsername The name of the administrator account. The name can contain lowercase letters, digits, and underscores (_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
 * @property migrationMode The migration mode of the instance. Valid values: **single-db** and **multi-db**.
 */
public data class InstanceBabelfishConfigArgs(
    public val babelfishEnabled: Output<String>,
    public val masterUserPassword: Output<String>,
    public val masterUsername: Output<String>,
    public val migrationMode: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.InstanceBabelfishConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.InstanceBabelfishConfigArgs =
        com.pulumi.alicloud.rds.inputs.InstanceBabelfishConfigArgs.builder()
            .babelfishEnabled(babelfishEnabled.applyValue({ args0 -> args0 }))
            .masterUserPassword(masterUserPassword.applyValue({ args0 -> args0 }))
            .masterUsername(masterUsername.applyValue({ args0 -> args0 }))
            .migrationMode(migrationMode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceBabelfishConfigArgs].
 */
@PulumiTagMarker
public class InstanceBabelfishConfigArgsBuilder internal constructor() {
    private var babelfishEnabled: Output<String>? = null

    private var masterUserPassword: Output<String>? = null

    private var masterUsername: Output<String>? = null

    private var migrationMode: Output<String>? = null

    /**
     * @param value specifies whether to enable the Babelfish for the instance. If you set this parameter to **true**, you enable Babelfish for the instance. If you leave this parameter empty, you disable Babelfish for the instance.
     */
    @JvmName("gbpfxcmtrkavgsag")
    public suspend fun babelfishEnabled(`value`: Output<String>) {
        this.babelfishEnabled = value
    }

    /**
     * @param value The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters:! @ # $ % ^ & * () _ + - =
     */
    @JvmName("usxxtipheohbdrqg")
    public suspend fun masterUserPassword(`value`: Output<String>) {
        this.masterUserPassword = value
    }

    /**
     * @param value The name of the administrator account. The name can contain lowercase letters, digits, and underscores (_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
     */
    @JvmName("hivvxpjubgpnnlrh")
    public suspend fun masterUsername(`value`: Output<String>) {
        this.masterUsername = value
    }

    /**
     * @param value The migration mode of the instance. Valid values: **single-db** and **multi-db**.
     */
    @JvmName("ufndqeinirqchnsg")
    public suspend fun migrationMode(`value`: Output<String>) {
        this.migrationMode = value
    }

    /**
     * @param value specifies whether to enable the Babelfish for the instance. If you set this parameter to **true**, you enable Babelfish for the instance. If you leave this parameter empty, you disable Babelfish for the instance.
     */
    @JvmName("sbbslaeogjytxftw")
    public suspend fun babelfishEnabled(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.babelfishEnabled = mapped
    }

    /**
     * @param value The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters:! @ # $ % ^ & * () _ + - =
     */
    @JvmName("seecepmsgfsqhrki")
    public suspend fun masterUserPassword(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.masterUserPassword = mapped
    }

    /**
     * @param value The name of the administrator account. The name can contain lowercase letters, digits, and underscores (_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
     */
    @JvmName("ethwuneoamugbxqi")
    public suspend fun masterUsername(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.masterUsername = mapped
    }

    /**
     * @param value The migration mode of the instance. Valid values: **single-db** and **multi-db**.
     */
    @JvmName("jytmylerfjepvuhi")
    public suspend fun migrationMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationMode = mapped
    }

    internal fun build(): InstanceBabelfishConfigArgs = InstanceBabelfishConfigArgs(
        babelfishEnabled = babelfishEnabled ?: throw PulumiNullFieldException("babelfishEnabled"),
        masterUserPassword = masterUserPassword ?: throw PulumiNullFieldException("masterUserPassword"),
        masterUsername = masterUsername ?: throw PulumiNullFieldException("masterUsername"),
        migrationMode = migrationMode ?: throw PulumiNullFieldException("migrationMode"),
    )
}
