@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.InstancePgHbaConfArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property address The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
 * @property database The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
 * @property mask The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
 * @property method The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
 * @property option Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
 * @property priorityId The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
 * @property type The type of connection to the instance. Valid values:
 * * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
 * * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
 * * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
 * > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
 * @property user The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
 */
public data class InstancePgHbaConfArgs(
    public val address: Output<String>,
    public val database: Output<String>,
    public val mask: Output<String>? = null,
    public val method: Output<String>,
    public val option: Output<String>? = null,
    public val priorityId: Output<Int>,
    public val type: Output<String>,
    public val user: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.InstancePgHbaConfArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.InstancePgHbaConfArgs =
        com.pulumi.alicloud.rds.inputs.InstancePgHbaConfArgs.builder()
            .address(address.applyValue({ args0 -> args0 }))
            .database(database.applyValue({ args0 -> args0 }))
            .mask(mask?.applyValue({ args0 -> args0 }))
            .method(method.applyValue({ args0 -> args0 }))
            .option(option?.applyValue({ args0 -> args0 }))
            .priorityId(priorityId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .user(user.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstancePgHbaConfArgs].
 */
@PulumiTagMarker
public class InstancePgHbaConfArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var database: Output<String>? = null

    private var mask: Output<String>? = null

    private var method: Output<String>? = null

    private var option: Output<String>? = null

    private var priorityId: Output<Int>? = null

    private var type: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
     */
    @JvmName("phentxdxkfmcokmx")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
     */
    @JvmName("tpyncghvleeulpns")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
     */
    @JvmName("ckhtuairsvdnmbco")
    public suspend fun mask(`value`: Output<String>) {
        this.mask = value
    }

    /**
     * @param value The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
     */
    @JvmName("sbhfdudtnqyeefgm")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
     */
    @JvmName("sptdbnauiypvcqyk")
    public suspend fun option(`value`: Output<String>) {
        this.option = value
    }

    /**
     * @param value The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
     */
    @JvmName("xepqhqcrsojbkdhg")
    public suspend fun priorityId(`value`: Output<Int>) {
        this.priorityId = value
    }

    /**
     * @param value The type of connection to the instance. Valid values:
     * * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
     * * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
     * * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
     * > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
     */
    @JvmName("ftaajlowjmunubqj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
     */
    @JvmName("ilupjxjhintdqiig")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
     */
    @JvmName("xhcliyviudurimvc")
    public suspend fun address(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
     */
    @JvmName("pkjtqlccgngongrx")
    public suspend fun database(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
     */
    @JvmName("oobbbmcmkuroegqv")
    public suspend fun mask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mask = mapped
    }

    /**
     * @param value The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
     */
    @JvmName("wyiyadomxasscegj")
    public suspend fun method(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
     */
    @JvmName("jvqojihciulndxis")
    public suspend fun option(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.option = mapped
    }

    /**
     * @param value The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
     */
    @JvmName("gndouwbrqnlotdbi")
    public suspend fun priorityId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priorityId = mapped
    }

    /**
     * @param value The type of connection to the instance. Valid values:
     * * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
     * * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
     * * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
     * > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
     */
    @JvmName("kcpvkybqdlambkcn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
     */
    @JvmName("guxdmrdagktrpnpc")
    public suspend fun user(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): InstancePgHbaConfArgs = InstancePgHbaConfArgs(
        address = address ?: throw PulumiNullFieldException("address"),
        database = database ?: throw PulumiNullFieldException("database"),
        mask = mask,
        method = method ?: throw PulumiNullFieldException("method"),
        option = option,
        priorityId = priorityId ?: throw PulumiNullFieldException("priorityId"),
        type = type ?: throw PulumiNullFieldException("type"),
        user = user ?: throw PulumiNullFieldException("user"),
    )
}
