@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.InstanceServerlessConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoPause
 * @property maxCapacity The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
 * - MySQL: 1~8
 * - SQLServer: 2~8
 * - PostgreSQL: 1~12
 * @property minCapacity The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
 * - MySQL: 0.5~8
 * - SQLServer: 2~8 \(Supports integers only\).
 * - PostgreSQL: 0.5~12
 * @property switchForce Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
 * - true: enables the feature.
 * - false: disables the feature. This is the default value.
 * > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
 * > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
 */
public data class InstanceServerlessConfigArgs(
    public val autoPause: Output<Boolean>? = null,
    public val maxCapacity: Output<Double>,
    public val minCapacity: Output<Double>,
    public val switchForce: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.InstanceServerlessConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.InstanceServerlessConfigArgs =
        com.pulumi.alicloud.rds.inputs.InstanceServerlessConfigArgs.builder()
            .autoPause(autoPause?.applyValue({ args0 -> args0 }))
            .maxCapacity(maxCapacity.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity.applyValue({ args0 -> args0 }))
            .switchForce(switchForce?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceServerlessConfigArgs].
 */
@PulumiTagMarker
public class InstanceServerlessConfigArgsBuilder internal constructor() {
    private var autoPause: Output<Boolean>? = null

    private var maxCapacity: Output<Double>? = null

    private var minCapacity: Output<Double>? = null

    private var switchForce: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("vokcoqmdpkxtassm")
    public suspend fun autoPause(`value`: Output<Boolean>) {
        this.autoPause = value
    }

    /**
     * @param value The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
     * - MySQL: 1~8
     * - SQLServer: 2~8
     * - PostgreSQL: 1~12
     */
    @JvmName("njdpiadiewejilwj")
    public suspend fun maxCapacity(`value`: Output<Double>) {
        this.maxCapacity = value
    }

    /**
     * @param value The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
     * - MySQL: 0.5~8
     * - SQLServer: 2~8 \(Supports integers only\).
     * - PostgreSQL: 0.5~12
     */
    @JvmName("rjotsapvjdkhueiu")
    public suspend fun minCapacity(`value`: Output<Double>) {
        this.minCapacity = value
    }

    /**
     * @param value Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
     * - true: enables the feature.
     * - false: disables the feature. This is the default value.
     * > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
     * > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
     */
    @JvmName("xiayrrllurbormum")
    public suspend fun switchForce(`value`: Output<Boolean>) {
        this.switchForce = value
    }

    /**
     * @param value
     */
    @JvmName("ddxengtujnvowoed")
    public suspend fun autoPause(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPause = mapped
    }

    /**
     * @param value The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
     * - MySQL: 1~8
     * - SQLServer: 2~8
     * - PostgreSQL: 1~12
     */
    @JvmName("wmnlffcrfcwuyumq")
    public suspend fun maxCapacity(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
     * - MySQL: 0.5~8
     * - SQLServer: 2~8 \(Supports integers only\).
     * - PostgreSQL: 0.5~12
     */
    @JvmName("drprlhnvcbxckyij")
    public suspend fun minCapacity(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    /**
     * @param value Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
     * - true: enables the feature.
     * - false: disables the feature. This is the default value.
     * > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
     * > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
     */
    @JvmName("dlmdkvlbcohoelox")
    public suspend fun switchForce(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.switchForce = mapped
    }

    internal fun build(): InstanceServerlessConfigArgs = InstanceServerlessConfigArgs(
        autoPause = autoPause,
        maxCapacity = maxCapacity ?: throw PulumiNullFieldException("maxCapacity"),
        minCapacity = minCapacity ?: throw PulumiNullFieldException("minCapacity"),
        switchForce = switchForce,
    )
}
