@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.RdsCloneDbInstanceParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The parameters name.
 * @property value The parameters value.
 */
public data class RdsCloneDbInstanceParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.RdsCloneDbInstanceParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.RdsCloneDbInstanceParameterArgs =
        com.pulumi.alicloud.rds.inputs.RdsCloneDbInstanceParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsCloneDbInstanceParameterArgs].
 */
@PulumiTagMarker
public class RdsCloneDbInstanceParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The parameters name.
     */
    @JvmName("amhuwrukiyeylhos")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters value.
     */
    @JvmName("ccmyswovagplxyoh")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The parameters name.
     */
    @JvmName("puomvwrgjpvslbjc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters value.
     */
    @JvmName("afraieslxowspxbx")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): RdsCloneDbInstanceParameterArgs = RdsCloneDbInstanceParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
