@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.RdsDbProxyReadOnlyInstanceWeightArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceId The Id of the instance and its read-only instances that can run database.
 * @property weight Weight of instances that can run the database and their read-only instances. Read weights increase in increments of 100, and the maximum read weight is 10000.
 */
public data class RdsDbProxyReadOnlyInstanceWeightArgs(
    public val instanceId: Output<String>,
    public val weight: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.RdsDbProxyReadOnlyInstanceWeightArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.RdsDbProxyReadOnlyInstanceWeightArgs =
        com.pulumi.alicloud.rds.inputs.RdsDbProxyReadOnlyInstanceWeightArgs.builder()
            .instanceId(instanceId.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsDbProxyReadOnlyInstanceWeightArgs].
 */
@PulumiTagMarker
public class RdsDbProxyReadOnlyInstanceWeightArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var weight: Output<String>? = null

    /**
     * @param value The Id of the instance and its read-only instances that can run database.
     */
    @JvmName("qgksgpfpbbkhblde")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Weight of instances that can run the database and their read-only instances. Read weights increase in increments of 100, and the maximum read weight is 10000.
     */
    @JvmName("hllrgymbnpligfba")
    public suspend fun weight(`value`: Output<String>) {
        this.weight = value
    }

    /**
     * @param value The Id of the instance and its read-only instances that can run database.
     */
    @JvmName("wbcebwqytnlpniut")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Weight of instances that can run the database and their read-only instances. Read weights increase in increments of 100, and the maximum read weight is 10000.
     */
    @JvmName("obeodctocgviplpv")
    public suspend fun weight(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): RdsDbProxyReadOnlyInstanceWeightArgs = RdsDbProxyReadOnlyInstanceWeightArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        weight = weight ?: throw PulumiNullFieldException("weight"),
    )
}
