@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.RdsParameterGroupParamDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property paramName The name of a parameter.
 * @property paramValue The value of a parameter.
 */
public data class RdsParameterGroupParamDetailArgs(
    public val paramName: Output<String>,
    public val paramValue: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.RdsParameterGroupParamDetailArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.RdsParameterGroupParamDetailArgs =
        com.pulumi.alicloud.rds.inputs.RdsParameterGroupParamDetailArgs.builder()
            .paramName(paramName.applyValue({ args0 -> args0 }))
            .paramValue(paramValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsParameterGroupParamDetailArgs].
 */
@PulumiTagMarker
public class RdsParameterGroupParamDetailArgsBuilder internal constructor() {
    private var paramName: Output<String>? = null

    private var paramValue: Output<String>? = null

    /**
     * @param value The name of a parameter.
     */
    @JvmName("otvxscynxleaqecb")
    public suspend fun paramName(`value`: Output<String>) {
        this.paramName = value
    }

    /**
     * @param value The value of a parameter.
     */
    @JvmName("jbcsktndftkadlof")
    public suspend fun paramValue(`value`: Output<String>) {
        this.paramValue = value
    }

    /**
     * @param value The name of a parameter.
     */
    @JvmName("oktweejclvcencae")
    public suspend fun paramName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramName = mapped
    }

    /**
     * @param value The value of a parameter.
     */
    @JvmName("wemukfsnbvoxwmeb")
    public suspend fun paramValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramValue = mapped
    }

    internal fun build(): RdsParameterGroupParamDetailArgs = RdsParameterGroupParamDetailArgs(
        paramName = paramName ?: throw PulumiNullFieldException("paramName"),
        paramValue = paramValue ?: throw PulumiNullFieldException("paramValue"),
    )
}
