@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.RdsUpgradeDbInstanceParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The parameter name.
 * @property value The parameter value.
 */
public data class RdsUpgradeDbInstanceParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.RdsUpgradeDbInstanceParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.RdsUpgradeDbInstanceParameterArgs =
        com.pulumi.alicloud.rds.inputs.RdsUpgradeDbInstanceParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsUpgradeDbInstanceParameterArgs].
 */
@PulumiTagMarker
public class RdsUpgradeDbInstanceParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The parameter name.
     */
    @JvmName("mmmlwdkhicgonapp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("qrbodniktgillxbg")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The parameter name.
     */
    @JvmName("pebqaddeixxygtoa")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("smsqosnrvreqbmsl")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): RdsUpgradeDbInstanceParameterArgs = RdsUpgradeDbInstanceParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
