@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.inputs

import com.pulumi.alicloud.rds.inputs.ReadOnlyInstanceParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The parameter name.
 * @property value The parameter value.
 */
public data class ReadOnlyInstanceParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.rds.inputs.ReadOnlyInstanceParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.rds.inputs.ReadOnlyInstanceParameterArgs =
        com.pulumi.alicloud.rds.inputs.ReadOnlyInstanceParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReadOnlyInstanceParameterArgs].
 */
@PulumiTagMarker
public class ReadOnlyInstanceParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The parameter name.
     */
    @JvmName("ntijsxxgpxdvcwss")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("xgnjlcsejybqsaqt")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The parameter name.
     */
    @JvmName("yrjhkqxrrwhmvcte")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("mgpxukhyxrypqsmu")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ReadOnlyInstanceParameterArgs = ReadOnlyInstanceParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
