@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property nodeId The ID of the node.
 * @property weight The weight of the node. Read requests are distributed based on the weight.Valid values: 0 to 100.
 */
public data class DbInstanceEndpointNodeItem(
    public val nodeId: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.DbInstanceEndpointNodeItem): DbInstanceEndpointNodeItem = DbInstanceEndpointNodeItem(
            nodeId = javaType.nodeId(),
            weight = javaType.weight(),
        )
    }
}
