@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountDescription Database description.
 * @property accountName Name of database account.
 * @property accountType Privilege type of account.
 * @property databasePrivileges A list of database permissions the account has.
 * @property id The ID of the Account.
 * @property privExceeded Whether the maximum number of databases managed by the account is exceeded.
 * @property status The status of the resource.
 */
public data class GetAccountsAccount(
    public val accountDescription: String,
    public val accountName: String,
    public val accountType: String,
    public val databasePrivileges: List<GetAccountsAccountDatabasePrivilege>,
    public val id: String,
    public val privExceeded: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetAccountsAccount): GetAccountsAccount = GetAccountsAccount(
            accountDescription = javaType.accountDescription(),
            accountName = javaType.accountName(),
            accountType = javaType.accountType(),
            databasePrivileges = javaType.databasePrivileges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetAccountsAccountDatabasePrivilege.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            privExceeded = javaType.privExceeded(),
            status = javaType.status(),
        )
    }
}
