@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCharacterSetNames.
 * @property engine
 * @property id The provider-assigned unique ID for this managed resource.
 * @property names
 * @property outputFile
 */
public data class GetCharacterSetNamesResult(
    public val engine: String,
    public val id: String,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetCharacterSetNamesResult): GetCharacterSetNamesResult = GetCharacterSetNamesResult(
            engine = javaType.engine(),
            id = javaType.id(),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
