@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getClassDetails.
 * @property category The RDS edition of the instance. Valid values:
 * * **Basic**: Basic Edition.
 * * **HighAvailability**: High-availability Edition.
 * * **AlwaysOn**: Cluster Edition.
 * * **Finance**: Enterprise Edition.
 * @property classCode
 * @property classGroup The specification family.
 * @property commodityCode
 * @property cpu The number of CPU cores corresponding to the instance specification. Unit: pieces.
 * @property dbInstanceStorageType The storage type of the instance. Valid values:
 * * **local_ssd**: specifies to use local SSDs.
 * * **cloud_ssd**: specifies to use standard SSDs.
 * * **cloud_essd**: specifies to use enhanced SSDs (ESSDs).
 * * **cloud_essd2**: specifies to use enhanced SSDs (ESSDs).
 * * **cloud_essd3**: specifies to use enhanced SSDs (ESSDs).
 * @property engine
 * @property engineVersion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instructionSetArch The architecture of the instance type.
 * @property maxConnections The maximum number of connections.
 * @property maxIombps The maximum IO bandwidth corresponding to the instance specification. Unit: Mbps.
 * @property maxIops The maximum IOPS of the instance.
 * @property memoryClass The memory capacity that is supported by the instance type. Unit: GB.
 * @property referencePrice The fee that you must pay for the instance type. Unit: cent (RMB).
 */
public data class GetClassDetailsResult(
    public val category: String,
    public val classCode: String,
    public val classGroup: String,
    public val commodityCode: String,
    public val cpu: String,
    public val dbInstanceStorageType: String,
    public val engine: String,
    public val engineVersion: String,
    public val id: String,
    public val instructionSetArch: String,
    public val maxConnections: String,
    public val maxIombps: String,
    public val maxIops: String,
    public val memoryClass: String,
    public val referencePrice: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetClassDetailsResult): GetClassDetailsResult = GetClassDetailsResult(
            category = javaType.category(),
            classCode = javaType.classCode(),
            classGroup = javaType.classGroup(),
            commodityCode = javaType.commodityCode(),
            cpu = javaType.cpu(),
            dbInstanceStorageType = javaType.dbInstanceStorageType(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            id = javaType.id(),
            instructionSetArch = javaType.instructionSetArch(),
            maxConnections = javaType.maxConnections(),
            maxIombps = javaType.maxIombps(),
            maxIops = javaType.maxIops(),
            memoryClass = javaType.memoryClass(),
            referencePrice = javaType.referencePrice(),
        )
    }
}
