@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCollationTimeZones.
 * @property collationTimeZones
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 */
public data class GetCollationTimeZonesResult(
    public val collationTimeZones: List<GetCollationTimeZonesCollationTimeZone>? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetCollationTimeZonesResult): GetCollationTimeZonesResult = GetCollationTimeZonesResult(
            collationTimeZones = javaType.collationTimeZones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetCollationTimeZonesCollationTimeZone.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
