@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backupEndTime The time when the cross-region data backup file was generated.
 * @property backupMethod The method that is used to generate the cross-region data backup file. Valid values:
 * `L` - logical backup.
 * `P` - physical backup.
 * @property backupSetScale The level at which the cross-region data backup file is generated.
 * `0` - instance-level backup.
 * `1` - database-level backup.
 * @property backupSetStatus TThe status of the cross-region data backup. Valid values:
 * `0` - The cross-region data backup is successful.
 * `1` - The cross-region data backup failed.
 * @property backupStartTime The time when the cross-region data backup started.
 * @property backupType The type of the cross-region data backup. Valid values:F: full data backup
 * `F` - full data backup.
 * `I` - incremental data backup.
 * @property category The RDS edition of the instance. Valid values:
 * `Basic` - Basic Edition.
 * `HighAvailability` - High-availability Edition.
 * `Finance` - Enterprise Edition. This edition is supported only by the China site (aliyun.com).
 * @property consistentTime The point in time that is indicated by the data in the cross-region data backup file.
 * @property crossBackupDownloadLink The external URL from which you can download the cross-region data backup file.
 * @property crossBackupId The ID of the cross-region data backup file.
 * @property crossBackupRegion The ID of the destination region where the cross-region data backup file of the instance is stored.
 * @property crossBackupSetFile The name of the compressed package that contains the cross-region data backup file.
 * @property crossBackupSetLocation The location where the cross-region data backup file is stored.
 * @property crossBackupSetSize The size of the cross-region data backup file. Unit: bytes.
 * @property dbInstanceStorageType The storage type.
 * @property engine The engine of the database.
 * @property engineVersion The version of the database engine.
 * @property id The ID of the cross-region data backup file.
 * @property instanceId The ID of the instance. This parameter is used to determine whether the instance that generates the cross-region data backup file is a primary or secondary instance.
 * @property recoveryBeginTime The start time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
 * @property recoveryEndTime The end time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
 * @property restoreRegions An array that consists of the regions to which the cross-region data backup file can be restored.
 */
public data class GetCrossRegionBackupsBackup(
    public val backupEndTime: String,
    public val backupMethod: String,
    public val backupSetScale: String,
    public val backupSetStatus: Int,
    public val backupStartTime: String,
    public val backupType: String,
    public val category: String,
    public val consistentTime: String,
    public val crossBackupDownloadLink: String,
    public val crossBackupId: String,
    public val crossBackupRegion: String,
    public val crossBackupSetFile: String,
    public val crossBackupSetLocation: String,
    public val crossBackupSetSize: Int,
    public val dbInstanceStorageType: String,
    public val engine: String,
    public val engineVersion: String,
    public val id: String,
    public val instanceId: Int,
    public val recoveryBeginTime: String,
    public val recoveryEndTime: String,
    public val restoreRegions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetCrossRegionBackupsBackup): GetCrossRegionBackupsBackup = GetCrossRegionBackupsBackup(
            backupEndTime = javaType.backupEndTime(),
            backupMethod = javaType.backupMethod(),
            backupSetScale = javaType.backupSetScale(),
            backupSetStatus = javaType.backupSetStatus(),
            backupStartTime = javaType.backupStartTime(),
            backupType = javaType.backupType(),
            category = javaType.category(),
            consistentTime = javaType.consistentTime(),
            crossBackupDownloadLink = javaType.crossBackupDownloadLink(),
            crossBackupId = javaType.crossBackupId(),
            crossBackupRegion = javaType.crossBackupRegion(),
            crossBackupSetFile = javaType.crossBackupSetFile(),
            crossBackupSetLocation = javaType.crossBackupSetLocation(),
            crossBackupSetSize = javaType.crossBackupSetSize(),
            dbInstanceStorageType = javaType.dbInstanceStorageType(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            recoveryBeginTime = javaType.recoveryBeginTime(),
            recoveryEndTime = javaType.recoveryEndTime(),
            restoreRegions = javaType.restoreRegions().map({ args0 -> args0 }),
        )
    }
}
